/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import gov.nasa.giss.gui.filechooser.SaveFileChooser;
import gov.nasa.giss.panoply.PanDisplayFrame;
import gov.nasa.giss.panoply.PanImageUtilities;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSaveImageAsAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanSaveImageAsAction.class);
    private static final String GIF_EXT = "gif";
    private static final String JPG_EXT = "jpg";
    private static final String JPEG_EXT = "jpeg";
    private static final String PDF_EXT = "pdf";
    private static final String PNG_EXT = "png";
    private static final String PS_EXT = "ps";
    private static final String TIF_EXT = "tif";
    private static final String TIFF_EXT = "tiff";
    private static final String[] EXTENSIONS = new String[]{"gif", "jpg", "jpeg", "pdf", "png", "ps", "tif", "tiff"};
    private static final String DOT = ".";
    private static final String ACTION_NAME = PanProperties.SOURCES.getString("save-image-as");
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static SaveFileChooser saveChooser_;
    private PanDisplayFrame parent_;
    private String fnameRoot_;
    private String fnameExt_;
    private File outputFile_;

    public PanSaveImageAsAction(PanDisplayFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
        this.flush();
    }

    public synchronized void flush() {
        this.fnameRoot_ = null;
        this.fnameExt_ = PREFS.getString("save:image.extension").toLowerCase();
        this.outputFile_ = null;
    }

    public void setFnameRoot(String root) {
        this.fnameRoot_ = root;
        if (this.fnameExt_ == null || this.fnameExt_.length() == 0) {
            this.fnameExt_ = PREFS.getString("save:image.extension").toLowerCase();
        }
        this.outputFile_ = null;
    }

    public File getFile() {
        return this.outputFile_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if (this.fnameExt_ == null) {
            this.fnameExt_ = PREFS.getString("save:image.extension").toLowerCase();
        }
        boolean goodExtension = false;
        for (String extension : EXTENSIONS) {
            if (!this.fnameExt_.equalsIgnoreCase(extension)) continue;
            goodExtension = true;
            break;
        }
        if (!goodExtension) {
            this.fnameExt_ = PNG_EXT;
        }
        if ((file = this.queryForFilename(this.fnameRoot_, this.fnameExt_)) == null) {
            return;
        }
        String fname = file.getName();
        if (fname == null) {
            return;
        }
        int lastDot = fname.lastIndexOf(DOT);
        if (lastDot == 0) {
            return;
        }
        this.fnameRoot_ = fname.substring(0, lastDot);
        String lcname = fname.toLowerCase();
        boolean goodExtension2 = false;
        for (String extension : EXTENSIONS) {
            if (!lcname.endsWith(DOT + extension)) continue;
            this.fnameExt_ = extension;
            PREFS.set("save:image.extension", extension.toUpperCase());
            goodExtension2 = true;
            break;
        }
        if (!goodExtension2) {
            this.fnameRoot_ = fname;
            fname = this.fnameRoot_ + DOT + this.fnameExt_;
            file = new File(file.getParent(), fname);
        }
        this.parent_.setTitle(this.fnameRoot_);
        this.outputFile_ = file;
        boolean saved = PanSaveImageAsAction.saveImage(file, this.parent_);
    }

    private File queryForFilename(String nameroot, String extension) {
        String plotname = nameroot + DOT + extension;
        if (saveChooser_ == null) {
            saveChooser_ = new SaveFileChooser(plotname);
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("GIF image", GIF_EXT));
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("JPEG image", JPG_EXT, JPEG_EXT));
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("PDF file", PDF_EXT));
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("PNG image", PNG_EXT));
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("PostScript file", PS_EXT));
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("TIFF image", TIF_EXT, TIFF_EXT));
            String dpath = PREFS.getString("path:save");
            if (dpath.length() > 0) {
                try {
                    saveChooser_.setCurrentDirectory(new File(dpath));
                }
                catch (Exception ignore) {}
            }
        } else {
            saveChooser_.setFileName(plotname);
        }
        saveChooser_.setExtension(extension);
        int returnVal = saveChooser_.showSaveDialog(this.parent_);
        if (returnVal != 0) {
            return null;
        }
        File file = saveChooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        if (fname == null || fname.equals("")) {
            return null;
        }
        PREFS.set("path:save", file.getParent());
        return file;
    }

    public static boolean saveImage(File f, PanDisplayFrame df) {
        try {
            String lcname = f.getName().toLowerCase();
            if (lcname.endsWith(".gif")) {
                return PanImageUtilities.saveAsGif(f, df);
            }
            if (lcname.endsWith(".jpg") || lcname.endsWith(".jpeg")) {
                return PanImageUtilities.saveAsJpeg(f, df);
            }
            if (lcname.endsWith(".pdf")) {
                return PanImageUtilities.saveAsPdf(f, df);
            }
            if (lcname.endsWith(".ps")) {
                return PanImageUtilities.saveAsPs(f, df);
            }
            if (lcname.endsWith(".png")) {
                return PanImageUtilities.saveAsPng(f, df);
            }
            if (lcname.endsWith(".tif") || lcname.endsWith(".tiff")) {
                return PanImageUtilities.saveAsTiff(f, df);
            }
            throw new RuntimeException("Unknown extension.");
        }
        catch (Exception exc) {
            logger_.error("Could not save image to a file.");
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(df, "Save Error", "Unable to save image.\n" + exc.toString());
            return false;
        }
    }

    public static String[] getExtensions() {
        return new String[]{GIF_EXT.toUpperCase(), JPEG_EXT.toUpperCase(), PDF_EXT.toUpperCase(), PNG_EXT.toUpperCase(), PS_EXT.toUpperCase(), TIFF_EXT.toUpperCase()};
    }
}

