/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import gov.nasa.giss.gui.filechooser.SaveFileChooser;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class PanSaveDataAsAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanSaveDataAsAction.class);
    private static final double MISSING_VALUE = -1.0E30;
    public static final String NC_EXT = "nc";
    public static final String DOT = ".";
    public static final String DOT_NC = ".nc";
    private static final String ACTION_NAME = PanProperties.SOURCES.getString("save-data-as");
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static SaveFileChooser saveChooser_;
    private PanPlotFrame parent_;
    private String fnameRoot_;
    private File outputFile_;

    public PanSaveDataAsAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
        this.flush();
    }

    public synchronized void flush() {
        this.fnameRoot_ = null;
        this.outputFile_ = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = this.queryForFilename(this.fnameRoot_)) == null) {
            return;
        }
        String fname = file.getName();
        if (fname == null) {
            return;
        }
        int lastDot = fname.lastIndexOf(DOT);
        if (lastDot == 0) {
            return;
        }
        this.fnameRoot_ = fname.substring(0, lastDot);
        String lcname = fname.toLowerCase();
        if (!lcname.endsWith(DOT_NC)) {
            this.fnameRoot_ = fname;
            fname = this.fnameRoot_ + DOT_NC;
            file = new File(file.getParent(), fname);
        }
        this.outputFile_ = file;
        PanSaveDataAsAction.saveData(file, this.parent_);
    }

    private File queryForFilename(String nameroot) {
        String plotname = nameroot + DOT + NC_EXT;
        if (saveChooser_ == null) {
            saveChooser_ = new SaveFileChooser(plotname);
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("NC", NC_EXT));
            String dpath = PREFS.getString("path:save");
            if (dpath.length() > 0) {
                try {
                    saveChooser_.setCurrentDirectory(new File(dpath));
                }
                catch (Exception ignore) {}
            }
        } else {
            saveChooser_.setFileName(plotname);
        }
        saveChooser_.setExtension(NC_EXT);
        int returnVal = saveChooser_.showSaveDialog(this.parent_);
        if (returnVal != 0) {
            return null;
        }
        File file = saveChooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        if (fname == null || fname.equals("")) {
            return null;
        }
        PREFS.set("path:save", file.getParent());
        return file;
    }

    public static void saveData(File f, PanPlotFrame df) {
        int row;
        NetcdfFileWriter writer;
        PanAbstractData2D data = (PanAbstractData2D)df.getData();
        Dimension size = data.getSize();
        try {
            writer = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, f.toString());
        }
        catch (Exception exc) {
            return;
        }
        Group g = writer.addGroup(null, "root");
        String xname = data.getXAxisName();
        String xunits = data.getXAxisUnits();
        String xnamelc = xname.toLowerCase();
        ucar.nc2.Dimension xDim = writer.addDimension(g, xnamelc, size.width);
        String yname = data.getYAxisName();
        String yunits = data.getYAxisUnits();
        String ynamelc = yname.toLowerCase();
        ucar.nc2.Dimension yDim = writer.addDimension(g, ynamelc, size.height);
        Variable vx = writer.addVariable(g, xnamelc, DataType.DOUBLE, xnamelc);
        if (xunits != null) {
            writer.addVariableAttribute(vx, new Attribute("units", xunits));
        }
        Variable vy = writer.addVariable(g, ynamelc, DataType.DOUBLE, ynamelc);
        if (yunits != null) {
            writer.addVariableAttribute(vy, new Attribute("units", yunits));
        }
        ArrayList<ucar.nc2.Dimension> dims = new ArrayList<ucar.nc2.Dimension>();
        dims.add(yDim);
        dims.add(xDim);
        Variable vv = writer.addVariable(g, "data", DataType.DOUBLE, dims);
        writer.addVariableAttribute(vv, new Attribute("long_name", "data"));
        writer.addVariableAttribute(vv, new Attribute("missing_value", new Double(-1.0E30)));
        String units = data.getUnits();
        if (units != null) {
            writer.addVariableAttribute(vv, new Attribute("units", data.getUnits()));
        }
        try {
            writer.create();
        }
        catch (IOException exc) {
            logger_.error("could not create file '{}'", (Object)exc.toString());
            return;
        }
        ArrayDouble array = new ArrayDouble.D1(size.width);
        Index ima = array.getIndex();
        for (int col = 0; col < size.width; ++col) {
            array.setDouble(ima.set(col), data.getColX(col));
        }
        try {
            writer.write(vx, array);
        }
        catch (Exception exc) {
            logger_.error("writing file x dimension variable");
            exc.printStackTrace();
            return;
        }
        array = new ArrayDouble.D1(size.height);
        ima = array.getIndex();
        for (row = 0; row < size.height; ++row) {
            array.setDouble(ima.set(row), data.getRowY(row));
        }
        try {
            writer.write(vy, array);
        }
        catch (Exception exc) {
            logger_.error("writing file y dimension variable");
            exc.printStackTrace();
            return;
        }
        array = new ArrayDouble.D2(size.height, size.width);
        ima = array.getIndex();
        for (row = 0; row < size.height; ++row) {
            for (int col = 0; col < size.width; ++col) {
                double value = data.valueAt(col, row);
                if (Double.isNaN(value)) {
                    value = -1.0E30;
                }
                array.setDouble(ima.set(row, col), value);
            }
        }
        try {
            writer.write(vv, array);
        }
        catch (Exception exc) {
            logger_.error("writing data variable");
            exc.printStackTrace();
            return;
        }
        try {
            writer.close();
        }
        catch (IOException exc) {
            logger_.error("closing file");
            exc.printStackTrace();
        }
    }
}

