/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalog;
import gov.nasa.giss.netcdf.NcCatalogNode;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.panoply.PanBookmarksNode;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanRemoveOneSourceAction
extends AbstractAction {
    private PanSourcesFrame parent_;

    public PanRemoveOneSourceAction(PanSourcesFrame f) {
        super(PanProperties.SOURCES.getString("clear"));
        this.parent_ = f;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null) {
            return;
        }
        if (node instanceof NcNode) {
            if (node instanceof NcDataset) {
                this.parent_.getSubpanel(PanSourcesFrame.Subpanel.DATASETS).removeNode(node);
            }
        } else if (node instanceof NcCatalogNode) {
            if (node instanceof NcCatalog) {
                this.parent_.getSubpanel(PanSourcesFrame.Subpanel.CATALOGS).removeNode(node);
            }
        } else if (node instanceof PanBookmarksNode) {
            this.parent_.getSubpanel(PanSourcesFrame.Subpanel.BOOKMARKS).removeNode(node);
        }
    }
}

