/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalogDataset;
import gov.nasa.giss.netcdf.NcCatalogNode;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.awt.event.ActionEvent;
import java.net.URI;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOpenCatalogDatasetAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanOpenCatalogDatasetAction.class);
    private PanSourcesFrame parent_;

    public PanOpenCatalogDatasetAction(PanSourcesFrame parent) {
        super(PanProperties.SOURCES.getString("open-catalog-dataset"));
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null) {
            return;
        }
        if (!(node instanceof NcCatalogNode)) {
            logger_.warn("Trying to open catalog dataset from non-NcCatalogNode");
            return;
        }
        if (!(node instanceof NcCatalogDataset)) {
            return;
        }
        URI uri = ((NcCatalogDataset)node).getURI();
        if (uri == null) {
            return;
        }
        try {
            PanFileUtilities.openDataset(this.parent_, uri.toURL());
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }
}

