/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.menu.GissMenu;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanLargerPlotAction
extends AbstractAction {
    private PanPlotFrame pframe_;

    public PanLargerPlotAction(PanPlotFrame pframe) {
        super("Show Larger");
        this.pframe_ = pframe;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Rectangle rr = GuiUtilities.getMainScreenBounds();
        PanPlotMeta pmeta = this.pframe_.getMeta();
        Dimension fsize = this.pframe_.getSize();
        if (fsize == null) {
            fsize = this.pframe_.getPreferredSize();
        }
        if (rr.height - fsize.height > 50) {
            int oldSF = pmeta.getSizeFactor();
            this.pframe_.setSizeFactor(oldSF + 10);
        } else {
            this.setEnabled(false);
        }
        PanMenuBar mbar = this.pframe_.getPanMenuBar();
        GissMenu viewMenu = mbar.getMenuByName("view-menu");
        viewMenu.refresh();
    }
}

