/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.filechooser.SaveFileChooser;
import gov.nasa.giss.panoply.PanFileConstants;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportSettingsAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanExportSettingsAction.class);
    public static final String DOT = ".";
    private static final String ACTION_NAME = PanProperties.MENUS.getString("export-settings");
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static SaveFileChooser saveChooser_;
    private PanPlotFrame parent_;
    private String fnameRoot_;
    private File file_;

    public PanExportSettingsAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    public File getFile() {
        return this.file_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = this.queryForFilename(this.fnameRoot_, "panset")) == null) {
            return;
        }
        String fname = file.getName();
        if (fname == null) {
            return;
        }
        if (fname.toLowerCase().endsWith(".panset")) {
            int lastDot = fname.lastIndexOf(DOT);
            this.fnameRoot_ = fname.substring(0, lastDot);
            this.file_ = new File(file.getParent(), fname);
        } else {
            this.fnameRoot_ = fname;
            fname = fname + DOT + "panset";
            this.file_ = new File(file.getParent(), fname);
        }
        this.parent_.toFront();
    }

    private File queryForFilename(String froot, String fext) {
        int returnVal;
        String plotname = froot + DOT + fext;
        if (saveChooser_ == null) {
            saveChooser_ = new SaveFileChooser(plotname);
        } else {
            saveChooser_.resetChoosableFileFilters();
            saveChooser_.setFileName(plotname);
        }
        saveChooser_.addChoosableFileFilter(PanFileConstants.SETTINGS_FILTER);
        saveChooser_.setExtension(fext);
        String dpath = PREFS.getString("path:save");
        if (dpath.length() > 0) {
            try {
                saveChooser_.setCurrentDirectory(new File(dpath));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if ((returnVal = saveChooser_.showSaveDialog(this.parent_)) != 0) {
            return null;
        }
        File file = saveChooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        if (fname == null || fname.equals("")) {
            return null;
        }
        PREFS.set("path:save", file.getParent());
        return file;
    }
}

