/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import gov.nasa.giss.gui.filechooser.SaveFileChooser;
import gov.nasa.giss.panoply.PanKmzOptionsDialog;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportKmzAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanExportKmzAction.class);
    private static final String KMZ_EXT = "kmz";
    private static final String DOT = ".";
    private static final String DOT_KMZ = ".kmz";
    private static final String ACTION_NAME = PanProperties.SOURCES.getString("export-kmz");
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static SaveFileChooser saveChooser_;
    private PanPlotFrame parent_;
    private String fnameRoot_;
    private File outputFile_;

    public PanExportKmzAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
        this.flush();
    }

    public synchronized void flush() {
        this.fnameRoot_ = null;
        this.outputFile_ = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        PanKmzOptionsDialog kod = new PanKmzOptionsDialog(this.parent_);
        kod.setVisible(true);
        if (!kod.isSuccessful()) {
            return;
        }
        boolean fillTransparent = kod.isFillTransparent();
        boolean borderVisible = kod.isBorderVisible();
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = this.queryForFilename(this.fnameRoot_)) == null) {
            return;
        }
        String fname = file.getName();
        if (fname == null) {
            return;
        }
        int lastDot = fname.lastIndexOf(DOT);
        if (lastDot == 0) {
            return;
        }
        this.fnameRoot_ = fname.substring(0, lastDot);
        String lcname = fname.toLowerCase();
        if (!lcname.endsWith(DOT_KMZ)) {
            this.fnameRoot_ = fname;
            fname = this.fnameRoot_ + DOT_KMZ;
            file = new File(file.getParent(), fname);
        }
        this.outputFile_ = file;
        try {
            PanExportKmzAction.saveKmz(file, this.fnameRoot_, this.parent_, fillTransparent, borderVisible);
        }
        catch (Exception exc) {
            logger_.error("Could not write KMZ info to a file.");
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(this.parent_, "Save Error", "Unable to write KMZ file.\n" + exc.toString());
        }
    }

    private File queryForFilename(String nameroot) {
        String plotname = nameroot + DOT_KMZ;
        if (saveChooser_ == null) {
            saveChooser_ = new SaveFileChooser(plotname);
            saveChooser_.setDialogTitle(ACTION_NAME + "\u2026");
            saveChooser_.addChoosableFileFilter(new ExtFileFilter(KMZ_EXT));
            String dpath = PREFS.getString("path:save");
            if (dpath.length() > 0) {
                try {
                    saveChooser_.setCurrentDirectory(new File(dpath));
                }
                catch (Exception ignore) {}
            }
        } else {
            saveChooser_.setFileName(plotname);
        }
        int returnVal = saveChooser_.showSaveDialog(this.parent_);
        if (returnVal != 0) {
            return null;
        }
        File file = saveChooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        if (fname == null || fname.equals("")) {
            return null;
        }
        PREFS.set("path:save", file.getParent());
        return file;
    }

    private static void saveKmz(File f, String fnameRoot, PanPlotFrame pframe, boolean fillTransparent, boolean borderVisible) throws IOException {
        PanLonLatPlot plot = (PanLonLatPlot)pframe.getPlot();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
        PanExportKmzAction.writeKml(fnameRoot, out, plot);
        PanExportKmzAction.writeMap(fnameRoot, out, plot, fillTransparent, borderVisible);
        out.close();
    }

    private static void writeKml(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot plot) throws IOException {
        String[] kmlStrs;
        double[] bounds = plot.getLonLatBounds();
        zipstream.putNextEntry(new ZipEntry(fnameRoot + ".kml"));
        for (String s : kmlStrs = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", "<kml xmlns=\"http://earth.google.com/kml/2.0\">\n", "<GroundOverlay>\n", "<name>" + fnameRoot + "</name>\n", "<Icon><href>" + fnameRoot + ".png</href></Icon>\n", "<LatLonBox>\n", "<west>" + bounds[0] + "</west>\n", "<north>" + bounds[1] + "</north>\n", "<east>" + bounds[2] + "</east>\n", "<south>" + bounds[3] + "</south>\n", "</LatLonBox>\n", "</GroundOverlay>\n", "</kml>\n"}) {
            byte[] bytes = s.getBytes("UTF-8");
            zipstream.write(bytes, 0, bytes.length);
        }
        zipstream.closeEntry();
    }

    private static void writeMap(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot plot, boolean fillTransparent, boolean borderVisible) throws IOException {
        zipstream.putNextEntry(new ZipEntry(fnameRoot + ".png"));
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        BufferedImage img = plot.getEquirectImage(fillTransparent, borderVisible);
        ImageIO.write((RenderedImage)img, "png", bstream);
        byte[] bytes = bstream.toByteArray();
        zipstream.write(bytes, 0, bytes.length);
        zipstream.closeEntry();
    }
}

