/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import gov.nasa.giss.gui.filechooser.SaveFileChooser;
import gov.nasa.giss.panoply.PanDisplayFrame;
import gov.nasa.giss.panoply.PanGeoTiffWriter;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportGeotiffAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanExportGeotiffAction.class);
    private static final String TIF_EXT = "tif";
    private static final String TIFF_EXT = "tiff";
    private static final String DOT = ".";
    private static final String DOT_TIF = ".tif";
    private static final String DOT_TIFF = ".tiff";
    private static final String ACTION_NAME = PanProperties.SOURCES.getString("export-geotiff");
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static SaveFileChooser saveChooser_;
    private PanDisplayFrame parent_;
    private String fnameRoot_;
    private File outputFile_;
    private static PanGeoTiffWriter geotiffWriter_;

    public PanExportGeotiffAction(PanDisplayFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
        this.flush();
    }

    public synchronized void flush() {
        this.fnameRoot_ = null;
        this.outputFile_ = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = this.queryForFilename(this.fnameRoot_)) == null) {
            return;
        }
        String fname = file.getName();
        if (fname == null) {
            return;
        }
        int lastDot = fname.lastIndexOf(DOT);
        if (lastDot == 0) {
            return;
        }
        this.fnameRoot_ = fname.substring(0, lastDot);
        String lcname = fname.toLowerCase();
        if (!lcname.endsWith(DOT_TIFF)) {
            this.fnameRoot_ = fname;
            fname = this.fnameRoot_ + DOT_TIFF;
            file = new File(file.getParent(), fname);
        }
        this.outputFile_ = file;
        PanExportGeotiffAction.saveGeotiff(file, this.fnameRoot_, this.parent_);
    }

    private File queryForFilename(String nameroot) {
        String plotname = nameroot + DOT_TIFF;
        if (saveChooser_ == null) {
            saveChooser_ = new SaveFileChooser(plotname);
            saveChooser_.setDialogTitle(ACTION_NAME + "\u2026");
            saveChooser_.addChoosableFileFilter(new ExtFileFilter("GeoTIFF file", TIFF_EXT, TIF_EXT));
            String dpath = PREFS.getString("path:save");
            if (dpath.length() > 0) {
                try {
                    saveChooser_.setCurrentDirectory(new File(dpath));
                }
                catch (Exception ignore) {}
            }
        } else {
            saveChooser_.setFileName(plotname);
        }
        int returnVal = saveChooser_.showSaveDialog(this.parent_);
        if (returnVal != 0) {
            return null;
        }
        File file = saveChooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        if (fname == null || fname.equals("")) {
            return null;
        }
        PREFS.set("path:save", file.getParent());
        return file;
    }

    private static void saveGeotiff(File f, String froot, PanDisplayFrame df) {
        PanPlotFrame pf = (PanPlotFrame)df;
        PanLonLatPlot plot = (PanLonLatPlot)pf.getPlot();
        double[] bounds = plot.getLonLatBounds();
        BufferedImage img = plot.getEquirectImage(true, false);
        if (geotiffWriter_ == null) {
            geotiffWriter_ = new PanGeoTiffWriter();
        } else {
            geotiffWriter_.flush();
        }
        geotiffWriter_.setImage(img);
        try {
            geotiffWriter_.write(f);
        }
        catch (Exception exc) {
            logger_.error("Could not write GeoTIFF data to a file.");
            exc.printStackTrace();
        }
    }
}

