/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import gov.nasa.giss.gui.filechooser.SaveFileChooser;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.tasks.PanExportCdlTask;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportCdlAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanExportCdlAction.class);
    private static final String CDL_EXT = "cdl";
    private static final String DOT = ".";
    private static final String DOT_CDL = ".cdl";
    private static final String ACTION_NAME = PanProperties.SOURCES.getString("export-cdl");
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static SaveFileChooser saveChooser_;
    private PanSourcesFrame parent_;

    public PanExportCdlAction(PanSourcesFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null) {
            return;
        }
        if (!(node instanceof NcNode)) {
            logger_.warn("Trying to Export CDL from non-NcNode");
            return;
        }
        if (!(node instanceof NcDataset) && !(node instanceof NcVariable)) {
            return;
        }
        String fnameRoot = null;
        if (node instanceof NcDataset) {
            fnameRoot = ((NcDataset)node).getName();
            int lastDot = fnameRoot.lastIndexOf(DOT);
            if (lastDot == 0) {
                return;
            }
            if (lastDot > -1) {
                fnameRoot = fnameRoot.substring(0, lastDot);
            }
        } else {
            fnameRoot = ((NcVariable)node).getName();
        }
        File file = this.queryForFilename(fnameRoot);
        if (file == null) {
            return;
        }
        String fname = file.getName();
        if (fname == null) {
            return;
        }
        int lastDot = fname.lastIndexOf(DOT);
        if (lastDot == 0) {
            return;
        }
        fnameRoot = fname.substring(0, lastDot);
        String lcname = fname.toLowerCase();
        if (!lcname.endsWith(DOT_CDL)) {
            fnameRoot = fname;
            fname = fnameRoot + DOT_CDL;
            file = new File(file.getParent(), fname);
        }
        PanExportCdlTask task = new PanExportCdlTask(this.parent_, (NcNode)node, file);
        this.parent_.addTask(task);
    }

    private File queryForFilename(String fnameRoot) {
        String plotname = fnameRoot + DOT_CDL;
        if (saveChooser_ == null) {
            saveChooser_ = new SaveFileChooser(plotname);
            saveChooser_.setDialogTitle(ACTION_NAME + "\u2026");
            saveChooser_.addChoosableFileFilter(new ExtFileFilter(CDL_EXT));
            String dpath = PREFS.getString("path:save");
            if (dpath.length() > 0) {
                try {
                    saveChooser_.setCurrentDirectory(new File(dpath));
                }
                catch (Exception ignore) {}
            }
        } else {
            saveChooser_.setFileName(plotname);
        }
        int returnVal = saveChooser_.showSaveDialog(this.parent_);
        if (returnVal != 0) {
            return null;
        }
        File file = saveChooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        if (fname == null || fname.equals("")) {
            return null;
        }
        PREFS.set("path:save", file.getParent());
        return file;
    }
}

