/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import gov.nasa.giss.gui.filechooser.SaveFileChooser;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.gui.task.TaskListener;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.panoply.PanAnimationFormat;
import gov.nasa.giss.panoply.PanAnimationOptionsDialog;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.tasks.PanExportAnimationTask;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class PanExportAnimationAction
extends AbstractAction
implements TaskListener {
    public static final String DOT = ".";
    private static final String ACTION_NAME = PanProperties.MENUS.getString("export-animation");
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static SaveFileChooser saveChooser_;
    private PanPlotFrame parent_;
    private File file_;
    private String fnameRoot_;
    private PanAnimationFormat format_;
    private NcDimension[] dimensions_;
    private Task animationTask_;
    private boolean animationInProgress_;

    public PanExportAnimationAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
        this.flush();
    }

    public void cancel() {
        if (this.animationInProgress_) {
            this.animationTask_.cancel(true);
            this.parent_.setAnimationInProgress(false);
            GuiUtilities.showSlowMessage(this.parent_, "Animation Canceled", "The animation was canceled before completion.");
        }
    }

    public synchronized void flush() {
        this.fnameRoot_ = null;
        this.format_ = PanAnimationFormat.QUICKTIME;
        this.file_ = null;
    }

    public File getFile() {
        return this.file_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        PanAnimationOptionsDialog aod = new PanAnimationOptionsDialog(this.parent_);
        aod.setVisible(true);
        if (!aod.isSuccessful()) {
            return;
        }
        this.format_ = aod.getFormat();
        String fnameExt = this.format_.getExtension().toLowerCase();
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = this.queryForFilename(this.fnameRoot_, fnameExt)) == null) {
            return;
        }
        String fname = file.getName();
        if (fname == null) {
            return;
        }
        if (fname.toLowerCase().endsWith(DOT + fnameExt)) {
            int lastDot = fname.lastIndexOf(DOT);
            this.fnameRoot_ = fname.substring(0, lastDot);
            this.file_ = new File(file.getParent(), fname);
        } else {
            this.fnameRoot_ = fname;
            fname = fname + DOT + fnameExt;
            this.file_ = new File(file.getParent(), fname);
        }
        int quality = aod.getQuality();
        int frate = aod.getFrameRate();
        boolean subtitles = aod.isDimSubtitled();
        this.dimensions_ = aod.getDimensions();
        aod.dispose();
        this.animationTask_ = new PanExportAnimationTask(this.format_, this.file_, this.parent_, quality, frate, this.dimensions_, subtitles);
        this.parent_.toFront();
        this.parent_.setAnimationInProgress(true);
        this.animationTask_.addTaskListener(this);
        this.setEnabled(false);
        this.animationInProgress_ = true;
        this.parent_.addTask(this.animationTask_);
    }

    private File queryForFilename(String froot, String fext) {
        int returnVal;
        String plotname = froot + DOT + fext;
        if (saveChooser_ == null) {
            saveChooser_ = new SaveFileChooser(plotname);
        } else {
            saveChooser_.resetChoosableFileFilters();
            saveChooser_.setFileName(plotname);
        }
        saveChooser_.addChoosableFileFilter(new ExtFileFilter(this.format_.toString(), fext));
        saveChooser_.setExtension(fext);
        String dpath = PREFS.getString("path:save");
        if (dpath.length() > 0) {
            try {
                saveChooser_.setCurrentDirectory(new File(dpath));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if ((returnVal = saveChooser_.showSaveDialog(this.parent_)) != 0) {
            return null;
        }
        File file = saveChooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        if (fname == null || fname.equals("")) {
            return null;
        }
        PREFS.set("path:save", file.getParent());
        return file;
    }

    @Override
    public void taskCommenced(Task t) {
        this.animationInProgress_ = true;
    }

    @Override
    public void taskCompleted(Task t) {
        this.animationInProgress_ = false;
        this.setEnabled(true);
    }

    @Override
    public void taskCanceled(Task t) {
        this.animationInProgress_ = false;
        this.setEnabled(true);
    }
}

