/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanPlotSize;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.tasks.PanCreatePlotTask;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class PanCreatePlotAction
extends AbstractAction {
    private static final String LON_LAT_OPTION = "Lon-Lat";
    private static final String LAT_VERT_OPTION = "Lat-Vert";
    private static final String LON_VERT_OPTION = "Lon-Vert";
    private static final String TIME_LAT_OPTION = "Time-Lat";
    private static JOptionPane lonLatTimePane_;
    private static JOptionPane lonLatVertTimePane_;
    private static JOptionPane lonLatVertPane_;
    private static JOptionPane latVertTimePane_;
    private PanSourcesFrame parent_;
    private JOptionPane plotSelectionPane_;
    private PanCreatePlotTask creator_;

    public PanCreatePlotAction(PanSourcesFrame f) {
        super(PanProperties.SOURCES.getString("create-plot"));
        this.parent_ = f;
    }

    public boolean isBusy() {
        return this.creator_ != null && this.creator_.isBusy();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isBusy()) {
            return;
        }
        this.createPlot(null);
    }

    public void createPlot(PanPlotSize size) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null || !(node instanceof NcNode)) {
            return;
        }
        if (!(node instanceof NcVariable)) {
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        if (!ncvar.isPlottable()) {
            return;
        }
        if (ncvar.hasLonLat() && ncvar.hasLatVert() && ncvar.hasTimeLat()) {
            if (lonLatVertTimePane_ == null) {
                lonLatVertTimePane_ = new JOptionPane("This variable has dimensions of longitude, latitude, vertical,\nand time. What kind of plot would you like to create?", 3, 1, null, new String[]{LON_LAT_OPTION, LAT_VERT_OPTION, LON_VERT_OPTION, TIME_LAT_OPTION, "Cancel"}, LON_LAT_OPTION);
            }
            this.plotSelectionPane_ = lonLatVertTimePane_;
        } else if (ncvar.hasLonLat() && ncvar.hasLatVert()) {
            if (lonLatVertPane_ == null) {
                lonLatVertPane_ = new JOptionPane("This variable has dimensions of longitude, latitude, and\nvertical. What kind of plot would you like to create?", 3, 1, null, new String[]{LON_LAT_OPTION, LAT_VERT_OPTION, LON_VERT_OPTION, "Cancel"}, LON_LAT_OPTION);
            }
            this.plotSelectionPane_ = lonLatVertPane_;
        } else if (ncvar.hasLonLat() && ncvar.hasTimeLat()) {
            if (lonLatTimePane_ == null) {
                lonLatTimePane_ = new JOptionPane("This variable has dimensions of longitude, latitude, and\ntime. What kind of plot would you like to create?", 3, 1, null, new String[]{LON_LAT_OPTION, TIME_LAT_OPTION, "Cancel"}, LON_LAT_OPTION);
            }
            this.plotSelectionPane_ = lonLatTimePane_;
        } else if (ncvar.hasLatVert() && ncvar.hasTimeLat()) {
            if (latVertTimePane_ == null) {
                latVertTimePane_ = new JOptionPane("This variable has dimensions of latitude, vertical, and\ntime. What kind of plot would you like to create?", 3, 1, null, new String[]{LAT_VERT_OPTION, TIME_LAT_OPTION, "Cancel"}, LAT_VERT_OPTION);
            }
            this.plotSelectionPane_ = latVertTimePane_;
        } else {
            if (ncvar.hasLonLat()) {
                this.createPlot(PanPlotType.LON_LAT, ncvar, size);
                return;
            }
            if (ncvar.hasLatVert()) {
                this.createPlot(PanPlotType.LAT_VERT, ncvar, size);
                return;
            }
            if (ncvar.hasLonVert()) {
                this.createPlot(PanPlotType.LON_VERT, ncvar, size);
                return;
            }
            if (ncvar.hasTimeLat()) {
                this.createPlot(PanPlotType.TIME_LAT, ncvar, size);
                return;
            }
            return;
        }
        this.plotSelectionPane_.createDialog(this.parent_, "Select Plot Type").setVisible(true);
        Object choice = this.plotSelectionPane_.getValue();
        if (choice == null) {
            return;
        }
        String cString = choice.toString();
        if (cString.equals(LON_LAT_OPTION)) {
            this.createPlot(PanPlotType.LON_LAT, ncvar, size);
        } else if (cString.equals(LAT_VERT_OPTION)) {
            this.createPlot(PanPlotType.LAT_VERT, ncvar, size);
        } else if (cString.equals(LON_VERT_OPTION)) {
            this.createPlot(PanPlotType.LON_VERT, ncvar, size);
        } else if (cString.equals(TIME_LAT_OPTION)) {
            this.createPlot(PanPlotType.TIME_LAT, ncvar, size);
        }
    }

    public void createPlot(PanPlotType plotType, NcVariable ncvar, PanPlotSize size) {
        if (plotType == null) {
            throw new IllegalArgumentException("Plot type is null.");
        }
        this.creator_ = new PanCreatePlotTask(plotType, ncvar, size);
        this.parent_.addTask(this.creator_);
    }
}

