/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanCombinePlotDialog;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.tasks.PanCombinePlotTask;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCombinePlotAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanCombinePlotAction.class);
    private PanSourcesFrame parent_;
    private PanCombinePlotTask combiner_;

    public PanCombinePlotAction(PanSourcesFrame f) {
        super(PanProperties.SOURCES.getString("combine-plot"));
        this.parent_ = f;
    }

    public boolean isBusy() {
        return this.combiner_ != null && this.combiner_.isBusy();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanCombinePlotDialog cpod = new PanCombinePlotDialog(this.parent_);
        cpod.setVisible(true);
        if (!cpod.isSuccessful()) {
            return;
        }
        this.addToExistingPlot(cpod.getTarget());
    }

    public void addToExistingPlot(String target) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null || !(node instanceof NcNode)) {
            return;
        }
        if (!(node instanceof NcVariable)) {
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        PanFrame pframe = null;
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame) || !frame.isVisible() || !frame.getTitle().equals(target)) continue;
            pframe = (PanPlotFrame)frame;
            break;
        }
        if (pframe == null) {
            return;
        }
        this.combiner_ = new PanCombinePlotTask((PanPlotFrame)pframe, ncvar);
        pframe.addTask(this.combiner_);
        this.parent_.refresh();
    }
}

