/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.actions;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalog;
import gov.nasa.giss.netcdf.NcCatalogDataset;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanBookmarkType;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAddBookmarkAction
extends AbstractAction {
    private static Logger logger_ = LoggerFactory.getLogger(PanAddBookmarkAction.class);
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private PanSourcesFrame parent_;

    public PanAddBookmarkAction(PanSourcesFrame f) {
        super(PanProperties.MENUS.getString("add-bookmark"));
        this.parent_ = f;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanBookmark b;
        block19: {
            TreeTableNode node = this.parent_.getSelectedNode();
            if (node == null) {
                return;
            }
            b = null;
            if (node instanceof NcNode) {
                if (!(node instanceof NcDataset)) {
                    return;
                }
                NcDataset ncd = (NcDataset)node;
                URL url = ncd.getURL();
                String prot = url.getProtocol();
                try {
                    if (prot.equals("file")) {
                        b = new PanBookmark(PanBookmarkType.LOCAL_DATASET, (Object)url, null);
                        break block19;
                    }
                    if (prot.equals("http") || prot.equals("https") || prot.equals("ftp")) {
                        b = new PanBookmark(PanBookmarkType.REMOTE_DATASET, (Object)url, null);
                        break block19;
                    }
                    throw new IllegalArgumentException("Dataset access protocol not understood");
                }
                catch (Exception exc) {
                    logger_.warn("Bad bookmark : {}", (Object)exc.toString());
                }
            } else if (node instanceof NcCatalog) {
                NcCatalog cc = (NcCatalog)node;
                try {
                    b = new PanBookmark(PanBookmarkType.CATALOG, (Object)cc.getURI(), cc.getName());
                }
                catch (Exception exc) {
                    logger_.warn("Bad bookmark : {}", (Object)exc.toString());
                }
            } else if (node instanceof NcCatalogDataset) {
                NcCatalogDataset cd = (NcCatalogDataset)node;
                if (!cd.getAllowsChildren()) {
                    return;
                }
                try {
                    b = new PanBookmark(PanBookmarkType.CATALOG, (Object)cd.getCatalogURL(), cd.getName());
                }
                catch (Exception exc) {
                    logger_.warn("Bad bookmark : {}", (Object)exc.toString());
                }
            } else {
                return;
            }
        }
        if (b == null) {
            return;
        }
        PanSourcesFrame.findFrame(true).addBookmarksNode(b);
        PanMenuBar mbar = this.parent_.getPanMenuBar();
        if (mbar == null) {
            return;
        }
        mbar.refresh();
    }
}

