/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanImageFormat;
import gov.nasa.giss.panoply.PanImageUtilities;
import gov.nasa.giss.panoply.PanOverlayList;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProjectionPrefs;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotMetaCL;
import gov.nasa.giss.text.TextUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.LogManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanoplyCL {
    private static final String[] OPEN_DATA = new String[]{"opd", "opendataset", "opendata"};
    private static final String[] SELECT_DATA = new String[]{"chd", "selectdataset", "selectdata"};
    private static final String[] CLOSE_DATA = new String[]{"rmd", "closedataset", "closedata"};
    private static final String[] OPEN_VAR = new String[]{"opv", "openvariable", "openvar"};
    private static final String[] SELECT_VAR = new String[]{"chv", "selectvariable", "selectvar"};
    private static final String[] CLOSE_VAR = new String[]{"rmv", "closevariable", "closevar"};
    private static final String[] OPEN_PLOT = new String[]{"opp", "openplot"};
    private static final String[] SELECT_PLOT = new String[]{"chp", "selectplot"};
    private static final String[] CLOSE_PLOT = new String[]{"rmp", "closeplot"};
    private static final String[] SAVE_PLOT = new String[]{"svp", "saveplot"};
    private static final String[] PLOT_SET = new String[]{"stp", "plotset"};
    private static final String[] DIM_SET = new String[]{"std", "dimset"};
    private static final String[] DIM_STEP = new String[]{"sti", "dimstep"};
    private static final String[] READ_PREFS = new String[]{"rdf", "readprefs"};
    private static final String[] RESET_PREFS = new String[]{"rrf", "resetprefs"};
    private static final String[] PREF_SET = new String[]{"stf", "prefset"};
    private static final String[] PREFS_COPY = new String[]{"cpf", "prefcopy"};
    private static final String[] SAVE_PREFS = new String[]{"svf", "saveprefs"};
    private static final String[] PRINT_LIST = new String[]{"prt", "print", "printlist"};
    private static final String[] QUIT = new String[]{"qqq", "qq", "quit", "bye", "done", "."};
    private static final String[] COMMENT = new String[]{"#", "//"};
    private static Logger logger_;
    private static ArrayList<NcDataset> datasets_;
    private static ArrayList<NcVariable> variables_;
    private static ArrayList<PanPlotMetaCL> pmetas_;
    private static int dCurrent_;
    private static int vCurrent_;
    private static int pCurrent_;

    public static void main(String ... args) {
        String ss;
        System.setProperty("java.awt.headless", "true");
        try {
            InputStream is = PanoplyCL.class.getResourceAsStream("properties/logging.properties");
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Exception exc) {
            logger_.error("Could not load logging properties. Will use defaults.");
            logger_.error("Error was: {}", (Object)exc.getMessage());
        }
        logger_ = LoggerFactory.getLogger(Panoply.class);
        if (logger_.isInfoEnabled()) {
            logger_.trace("PanoplyCL launched");
            logger_.trace("Logger isWarnEnabled  {}", (Object)logger_.isWarnEnabled());
            logger_.trace("Logger isInfoEnabled  {}", (Object)logger_.isInfoEnabled());
            logger_.trace("Logger isDebugEnabled {}", (Object)logger_.isDebugEnabled());
            logger_.trace("Logger isTraceEnabled {}", (Object)logger_.isTraceEnabled());
        }
        PanPreferences prefs = PanPreferences.getPrefs();
        File script = PanoplyCL.parseCommandLineOptions(args);
        BufferedReader reader = PanoplyCL.openInput(script);
        boolean onToNext = true;
        while (onToNext && (ss = PanoplyCL.readLine(reader)) != null) {
            onToNext = PanoplyCL.processLine(ss);
        }
        PanoplyCL.closeInput(reader);
        PanoplyCL.quit();
    }

    private static File parseCommandLineOptions(String ... args) {
        boolean optionsAllowed = true;
        ArrayList<String> fnames = new ArrayList<String>();
        String scriptPath = null;
        for (int i = 0; i < args.length; ++i) {
            if (optionsAllowed && args[i].startsWith("-")) {
                if (args[i].equals("--")) {
                    optionsAllowed = false;
                    continue;
                }
                String optname = args[i].substring(1);
                if (optname.equals("s") || optname.equals("script")) {
                    if (++i >= args.length) {
                        logger_.error("No value provided for -" + optname);
                        System.exit(1);
                    }
                    scriptPath = args[i];
                    continue;
                }
                logger_.warn("Unknown option {}", (Object)optname);
                continue;
            }
            fnames.add(args[i]);
        }
        File script = null;
        if (scriptPath != null) {
            try {
                script = new File(scriptPath);
            }
            catch (Exception exc) {
                logger_.error("Could not create File from '{}'", (Object)scriptPath);
                System.exit(2);
            }
            if (script != null && !script.exists()) {
                logger_.error("No file found at '{}'", (Object)scriptPath);
                System.exit(2);
            }
        }
        return script;
    }

    private static BufferedReader openInput(File f) {
        if (f == null) {
            InputStreamReader r = new InputStreamReader(System.in);
            return new BufferedReader(r);
        }
        try {
            FileInputStream is = new FileInputStream(f);
            InputStreamReader r = new InputStreamReader((InputStream)is, "UTF-8");
            return new BufferedReader(r);
        }
        catch (Exception exc) {
            logger_.error("FATAL: Could not create file reader");
            System.exit(2);
            return null;
        }
    }

    private static void closeInput(BufferedReader br) {
        try {
            br.close();
        }
        catch (Exception exc) {
            logger_.error("FATAL: Could not close script");
            System.exit(2);
        }
    }

    private static String readLine(BufferedReader br) {
        String ss = null;
        try {
            ss = br.readLine();
        }
        catch (Exception exc) {
            logger_.error("FATAL: Could not read from script");
            System.exit(2);
        }
        if (ss != null) {
            ss = StringUtils.chomp(ss);
            ss = StringUtils.strip(ss);
        }
        if (ss.indexOf("\\u") > -1) {
            try {
                ss = TextUtilities.convertUnicode(ss);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ss;
    }

    private static boolean processLine(String ss) {
        if (ss.length() == 0 || PanoplyCL.commandMatches(ss, COMMENT)) {
            return true;
        }
        if (PanoplyCL.commandMatches(ss, QUIT)) {
            return false;
        }
        if (PanoplyCL.commandMatches(ss, OPEN_DATA)) {
            int response = PanoplyCL.getDataset(PanoplyCL.getParamString(ss, OPEN_DATA));
            if (response > -1) {
                dCurrent_ = response;
                System.out.printf("Dataset has index %d%n", response + 1);
            }
        } else if (PanoplyCL.commandMatches(ss, SELECT_DATA)) {
            int response = PanoplyCL.selectDataset(PanoplyCL.getParamString(ss, SELECT_DATA));
            if (response > -1) {
                dCurrent_ = response;
                System.out.printf("Dataset has index %d%n", response + 1);
            }
        } else if (PanoplyCL.commandMatches(ss, OPEN_VAR)) {
            int response = PanoplyCL.getVariable(PanoplyCL.getParamString(ss, OPEN_VAR));
            if (response > -1) {
                vCurrent_ = response;
                System.out.printf("Variable has index %d%n", response + 1);
            }
        } else if (PanoplyCL.commandMatches(ss, SELECT_VAR)) {
            int response = PanoplyCL.selectVariable(PanoplyCL.getParamString(ss, SELECT_VAR));
            if (response > -1) {
                vCurrent_ = response;
                System.out.printf("Variable has index %d%n", response + 1);
            }
        } else if (PanoplyCL.commandMatches(ss, OPEN_PLOT)) {
            int response = PanoplyCL.makePlot(PanoplyCL.getParamString(ss, OPEN_PLOT));
            if (response > -1) {
                pCurrent_ = response;
                System.out.printf("Plot has index %d%n", response + 1);
            }
        } else if (PanoplyCL.commandMatches(ss, SELECT_PLOT)) {
            int response = PanoplyCL.selectPlot(PanoplyCL.getParamString(ss, SELECT_PLOT));
            if (response > -1) {
                pCurrent_ = response;
                System.out.printf("Plot has index %d%n", response + 1);
            }
        } else if (PanoplyCL.commandMatches(ss, PLOT_SET)) {
            int response = PanoplyCL.setPlotSetting(PanoplyCL.getParamString(ss, PLOT_SET));
        } else if (PanoplyCL.commandMatches(ss, DIM_SET)) {
            int response = PanoplyCL.setPlotDataDimension(PanoplyCL.getParamString(ss, DIM_SET));
        } else if (PanoplyCL.commandMatches(ss, DIM_STEP)) {
            int response = PanoplyCL.stepPlotDataDimension(PanoplyCL.getParamString(ss, DIM_STEP));
        } else if (PanoplyCL.commandMatches(ss, PRINT_LIST)) {
            int response = PanoplyCL.printList(PanoplyCL.getParamString(ss, PRINT_LIST));
        } else if (PanoplyCL.commandMatches(ss, PREFS_COPY)) {
            int response = PanoplyCL.copySettingsToPreferences();
            if (response > -1) {
                System.out.println("Plot settings copied to preferences.");
            }
        } else if (PanoplyCL.commandMatches(ss, SAVE_PLOT)) {
            int n = PanoplyCL.savePlot(PanoplyCL.getParamString(ss, SAVE_PLOT));
        } else if (PanoplyCL.commandMatches(ss, READ_PREFS)) {
            PanPreferences.getPrefs().read();
            System.out.println("Plot defaults read from user prefs file.");
        } else if (PanoplyCL.commandMatches(ss, RESET_PREFS)) {
            PanPreferences.getPrefs().restoreDefaults();
            System.out.println("Plot defaults reset.");
        } else if (!PanoplyCL.commandMatches(ss, PREF_SET) && !ss.startsWith("saveprefs")) {
            System.out.printf("WARNING: Unknown command %s%n", ss);
        }
        return true;
    }

    private static boolean commandMatches(String ss, String[] command) {
        if (ss == null) {
            logger_.error("FATAL: Null parameter");
            System.exit(2);
        }
        for (int i = 0; i < command.length; ++i) {
            if (!ss.equals(command[i]) && !ss.startsWith(command[i])) continue;
            return true;
        }
        return false;
    }

    private static String getParamString(String ss, String[] command) {
        if (ss == null) {
            System.out.println("FATAL: Null parameter");
            System.exit(2);
        }
        for (int i = 0; i < command.length; ++i) {
            if (!ss.startsWith(command[i] + " ") && !ss.equals(command[i])) continue;
            ss = StringUtils.strip(StringUtils.removeStart(ss, command[i]));
            break;
        }
        return ss;
    }

    private static int getDataset(String ss) {
        if (ss.length() == 0) {
            System.err.println("ERROR: Zero-length parameter");
            return -1;
        }
        File ff = null;
        try {
            ff = new File(ss);
        }
        catch (Exception exc) {
            System.err.printf("ERROR: Bad dataset path specification: %s%n", ss);
            return -1;
        }
        if (!ff.exists()) {
            System.err.printf("ERROR: No file at %s%n", ss);
            return -1;
        }
        NcDataset ncd = PanFileUtilities.openLocalDatasetCL(ff);
        if (ncd != null) {
            datasets_.add(ncd);
            return datasets_.indexOf(ncd);
        }
        return -1;
    }

    private static int selectDataset(String ss) {
        if (ss.length() == 0) {
            System.err.println("ERROR: Zero-length parameter");
            return -1;
        }
        try {
            int dnum = Integer.parseInt(ss) - 1;
            if (dnum > -1 && dnum < datasets_.size()) {
                dCurrent_ = dnum;
                return dnum;
            }
            System.err.printf("ERROR: No dataset at index %s%n", ss);
            return -1;
        }
        catch (Exception exc) {
            System.err.printf("ERROR: Could not parse index %s%n", ss);
            return -1;
        }
    }

    private static int getVariable(String ss) {
        if (ss.length() == 0) {
            System.err.println("ERROR: Zero-length parameter");
            return -1;
        }
        NcDataset ncd = null;
        if (datasets_.size() == 0) {
            System.err.println("ERROR: No datasets open yet");
            return -1;
        }
        ncd = datasets_.get(dCurrent_);
        try {
            NcVariable ncv = new NcVariable(ncd, ss);
            variables_.add(ncv);
            return variables_.indexOf(ncv);
        }
        catch (Exception exc) {
            System.err.println("ERROR: Could not create NcVariable");
            System.err.printf("MESSAGE: %s%n", exc);
            return -1;
        }
    }

    private static int selectVariable(String ss) {
        if (ss.length() == 0) {
            logger_.error("ERROR: Zero-length parameter");
            return -1;
        }
        try {
            int vnum = Integer.parseInt(ss) - 1;
            if (vnum > -1 && vnum < variables_.size()) {
                vCurrent_ = vnum;
                return vnum;
            }
            System.err.printf("ERROR: No variable at index %s%n", ss);
            return -1;
        }
        catch (Exception exc) {
            System.err.printf("ERROR: Could not parse index %s%n", ss);
            return -1;
        }
    }

    private static int makePlot(String ss) {
        if (ss.length() == 0) {
            logger_.error("ERROR: Zero-length parameter");
            return -1;
        }
        NcVariable ncv = null;
        if (variables_.size() == 0) {
            System.err.println("ERROR: No variable selected yet");
            return -1;
        }
        ncv = variables_.get(vCurrent_);
        try {
            Object plot = null;
            if (ss.equalsIgnoreCase("lonlat")) {
                PanPlotMetaCL pmeta = new PanPlotMetaCL(PanPlotType.LON_LAT, 120);
                PanAbstractData data = pmeta.createData(ncv);
                data.getMinimumValue();
                pmeta.createPlot();
                pmetas_.add(pmeta);
                return pmetas_.indexOf(pmeta);
            }
        }
        catch (Exception exc) {
            System.err.println("ERROR: Could not create plot.");
            System.err.printf("MESSAGE: %s%n", exc);
            exc.printStackTrace();
            return -1;
        }
        return -1;
    }

    private static int selectPlot(String ss) {
        if (ss.length() == 0) {
            logger_.error("ERROR: Zero-length parameter");
            return -1;
        }
        try {
            int pnum = Integer.parseInt(ss) - 1;
            if (pnum > -1 && pnum < pmetas_.size()) {
                pCurrent_ = pnum;
                return pnum;
            }
            System.err.printf("ERROR: No plot at index %s%n", ss);
            return -1;
        }
        catch (Exception exc) {
            System.err.printf("ERROR: Could not parse index %s%n", ss);
            return -1;
        }
    }

    private static int setPlotSetting(String ss) {
        if (ss.length() == 0) {
            logger_.error("ERROR: Zero-length parameter");
            return -1;
        }
        Object plot = null;
        if (pmetas_.size() == 0) {
            System.err.println("ERROR: No plot selected yet");
            return -1;
        }
        PanPlotMetaCL pmeta = pmetas_.get(pCurrent_);
        int space = ss.indexOf(" ");
        if (space < 0) {
            System.err.println("ERROR: Key and value required");
            return -1;
        }
        String skey = ss.substring(0, space);
        String svalue = ss.substring(space + 1);
        boolean success = pmeta.setCL(skey, svalue);
        if (pmeta.setCL(skey, svalue)) {
            System.out.printf("Setting accepted for key %s%n", skey);
            return 1;
        }
        System.out.printf("Setting rejected for key %s%n", skey);
        return -1;
    }

    private static int setPlotDataDimension(String ss) {
        if (ss.length() == 0) {
            logger_.error("ERROR: Zero-length parameter");
            return -1;
        }
        Object plot = null;
        if (pmetas_.size() == 0) {
            System.err.println("ERROR: No plot selected yet");
            return -1;
        }
        String[] tokens = ss.split(" ");
        if (tokens.length > 3) {
            System.err.println("ERROR: Too many parameters.");
            return -1;
        }
        int[] dimsets = new int[tokens.length];
        try {
            for (int i = 0; i < tokens.length; ++i) {
                dimsets[i] = Integer.parseInt(tokens[i]) - 1;
                if (dimsets[i] >= 0) continue;
                System.err.println("ERROR: Bad dimension setting");
                return -1;
            }
        }
        catch (Exception exc) {
            System.err.println("ERROR: Could not parse parameter(s) as integer(s)");
            return -1;
        }
        PanPlotMeta meta = pmetas_.get(pCurrent_);
        try {
            if (dimsets.length == 3) {
                meta.setDataSlice(dimsets[0], dimsets[1], dimsets[2], null);
            } else if (dimsets.length == 2) {
                meta.setDataSlice(0, dimsets[0], dimsets[1], null);
            } else {
                meta.setDataSlice(0, 0, dimsets[0], null);
            }
        }
        catch (Exception exc) {
            System.err.println("ERROR: Bad dimension setting");
            System.err.printf("MESSAGE: %s%n", exc);
            return -1;
        }
        return 1;
    }

    private static int stepPlotDataDimension(String ss) {
        String[] tokens;
        Object plot = null;
        String[] stringArray = tokens = ss.length() > 0 ? ss.split(" ") : new String[]{};
        if (tokens.length > 2) {
            System.err.println("ERROR: Too many parameters.");
            return -1;
        }
        int[] dimsets = new int[tokens.length];
        try {
            for (int i = 0; i < tokens.length; ++i) {
                dimsets[i] = Integer.parseInt(tokens[i]) - 1;
                if (dimsets[i] >= 0) continue;
                System.err.println("ERROR: Bad dimension setting");
                return -1;
            }
        }
        catch (Exception exc) {
            System.err.println("ERROR: Could not parse parameter(s) as integer(s)");
            return -1;
        }
        PanAbstractData data = pmetas_.get(pCurrent_).getData();
        try {
            NcArray nca;
            NcArray ncArray = nca = tokens.length == 2 ? data.getArray(dimsets[0]) : data.getArray(0);
            if (dimsets.length == 2) {
                int current = nca.getSliceIndex(dimsets[1]);
            } else if (dimsets.length == 1) {
                int current = nca.getSliceIndex(dimsets[0]);
            } else {
                int current = nca.getSliceIndex(0) + 1;
            }
        }
        catch (Exception exc) {
            System.err.println("ERROR: Bad dimension setting");
            System.err.printf("MESSAGE: %s%n", exc);
            return -1;
        }
        return 1;
    }

    private static int copySettingsToPreferences() {
        Object plot = null;
        if (pmetas_.size() == 0) {
            System.err.println("ERROR: No plot selected yet.");
            return -1;
        }
        pmetas_.get(pCurrent_).copySettingsToPrefs();
        return 1;
    }

    private static int savePlot(String ss) {
        PanAbstractPlot plot = null;
        if (pmetas_.size() == 0) {
            System.err.println("ERROR: No plot selected yet");
            return -1;
        }
        plot = pmetas_.get(pCurrent_).getPlot();
        if (ss.length() == 0) {
            logger_.error("ERROR: Zero-length parameter");
            return -1;
        }
        int space = ss.indexOf(" ");
        if (space < 0) {
            System.err.println("ERROR: Format and filename required.");
            return -1;
        }
        String fstring = ss.substring(0, space);
        PanImageFormat pif = PanImageFormat.match(fstring);
        if (pif == null) {
            System.err.printf("ERROR: Could not match image format '%s'%n", fstring);
            return -1;
        }
        ss = ss.substring(space + 1);
        File f = null;
        try {
            f = new File(ss);
        }
        catch (Exception exc) {
            System.err.println("ERROR: Could not save plot.");
            System.err.printf("MESSAGE: %s%n", exc);
            exc.printStackTrace();
            return -1;
        }
        boolean success = false;
        try {
            switch (pif) {
                case GIF: {
                    success = PanImageUtilities.saveAsGif(f, plot);
                    break;
                }
                case JPEG: {
                    success = PanImageUtilities.saveAsJpeg(f, plot);
                    break;
                }
                case PDF: {
                    success = PanImageUtilities.saveAsPdf(f, plot);
                    break;
                }
                case PNG: {
                    success = PanImageUtilities.saveAsPng(f, plot);
                    break;
                }
                case PS: {
                    success = PanImageUtilities.saveAsPs(f, plot);
                    break;
                }
                case TIFF: {
                    success = PanImageUtilities.saveAsTiff(f, plot);
                }
            }
        }
        catch (Exception exc) {
            System.err.println("ERROR: Could not save plot.");
            System.err.printf("MESSAGE: %s%n", exc);
            exc.printStackTrace();
        }
        if (!success) {
            return -1;
        }
        System.out.println("Plot image saved");
        return 1;
    }

    private static int printList(String ss) {
        if (ss.length() == 0) {
            logger_.error("ERROR: Zero-length parameter");
            return -1;
        }
        if (ss.startsWith("plotsets")) {
            if (pmetas_.size() == 0) {
                System.out.println("WARNING: No plot selected");
                return -1;
            }
            pmetas_.get(pCurrent_).writeSettingsCL();
        } else if (ss.startsWith("plotdims")) {
            if (pmetas_.size() == 0) {
                System.out.println("WARNING: No plot selected");
                return -1;
            }
            pmetas_.get(pCurrent_).writeDimsCL();
        } else if (ss.startsWith("plots")) {
            for (int i = 0; i < pmetas_.size(); ++i) {
                PanPlotMeta pmeta = pmetas_.get(i);
                if (pmeta == null) continue;
                System.out.printf("plot %d : %s%n", i + 1, pmeta.getString("plot:caption.title"));
            }
        } else if (ss.startsWith("datasets")) {
            for (int i = 0; i < datasets_.size(); ++i) {
                NcDataset ncd = datasets_.get(i);
                if (ncd == null) continue;
                System.out.printf("data %d : %s%n", i + 1, ncd);
            }
        } else if (ss.equals("vars") || ss.equals("variables")) {
            for (int i = 0; i < variables_.size(); ++i) {
                NcVariable ncv = variables_.get(i);
                if (ncv == null) continue;
                System.out.printf("var %d : %s%n", i + 1, ncv);
            }
        } else if (!ss.startsWith("vardims")) {
            if (ss.startsWith("overlays")) {
                PanOverlayList.getList().printList();
            } else if (ss.startsWith("colorbars")) {
                PanColorTableList.getList().printList();
            } else if (ss.startsWith("projections")) {
                PanProjectionPrefs.printList();
            } else {
                System.err.println("ERROR: Unknown command");
                return -1;
            }
        }
        return 1;
    }

    public static void quit() {
        for (NcDataset ncd : datasets_) {
            try {
                ncd.close();
            }
            catch (Exception exception) {}
        }
        System.exit(0);
    }

    static {
        datasets_ = new ArrayList();
        variables_ = new ArrayList();
        pmetas_ = new ArrayList();
        dCurrent_ = -1;
        vCurrent_ = -1;
        pCurrent_ = -1;
    }
}

