/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcFilenameFilter;
import gov.nasa.giss.netcdf.NcGribUtilities;
import gov.nasa.giss.netcdf.NcUtilities;
import gov.nasa.giss.panoply.PanAboutFrame;
import gov.nasa.giss.panoply.PanAuthenticationManager;
import gov.nasa.giss.panoply.PanClient;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanMacApplication;
import gov.nasa.giss.panoply.PanOpenFileChooser;
import gov.nasa.giss.panoply.PanOverlayList;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanServer;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.LogManager;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Panoply
implements ActionListener {
    private static Logger logger_ = LoggerFactory.getLogger(Panoply.class);
    private static long SPLASH_MILLIS = 2000L;
    private static ArrayList<File> dataFiles_;
    private static boolean allowMulti_;
    private static PanServer server_;
    private static boolean starting_;
    private static boolean quitting_;

    public static void main(String ... args) {
        starting_ = true;
        try {
            InputStream is = Panoply.class.getResourceAsStream("properties/logging.properties");
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Exception exc) {
            logger_.warn("Could not load logging properties. Will use defaults.");
        }
        if (logger_.isInfoEnabled()) {
            logger_.info("Panoply launched");
            logger_.info("Logger isWarnEnabled  {}", (Object)logger_.isWarnEnabled());
            logger_.info("Logger isInfoEnabled  {}", (Object)logger_.isInfoEnabled());
            logger_.info("Logger isDebugEnabled {}", (Object)logger_.isDebugEnabled());
            logger_.info("Logger isTraceEnabled {}", (Object)logger_.isTraceEnabled());
        }
        PanPreferences prefs = PanPreferences.getPrefs();
        String version = PanProperties.VERSION.getString("version");
        NcUtilities.initHttpClient("Panoply/" + version + " (http://www.giss.nasa.gov/tools/panoply/)", new PanAuthenticationManager());
        NcUtilities.initCache("Panoply", "gov.nasa.giss.Panoply");
        NcGribUtilities.initGribHandling();
        NcGribUtilities.setGrib1Strict(prefs.getBoolean("grib:strict"));
        Panoply.handleCommandLineOptions(args);
        if (!allowMulti_ && !PlatformUtilities.isMacintosh() && Panoply.isAlreadyRunning()) {
            System.exit(0);
        }
        new Panoply();
        starting_ = false;
    }

    public Panoply() {
        File[] ff;
        PanOpenFileChooser chooser;
        int returnVal;
        try {
            System.setProperty("swing.aatext", "true");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            String os = System.getProperty("os.name").toString();
            if (!os.startsWith("Linux") && !os.startsWith("linux")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exc) {
            logger_.warn("Unable to load native look and feel");
        }
        try {
            if (PlatformUtilities.isMacintosh()) {
                new PanMacApplication();
            }
        }
        catch (Exception exc) {
            logger_.warn("Failed to create PanMacApplication");
            exc.printStackTrace();
        }
        PanPreferences prefs = PanPreferences.getPrefs();
        PanAboutFrame aboutFrame = null;
        long splashStop = 0L;
        if (prefs.getBoolean("launch:splash")) {
            final PanAboutFrame af = aboutFrame = PanAboutFrame.findFrame(true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    af.reveal();
                }
            });
            splashStop = System.currentTimeMillis() + SPLASH_MILLIS;
        }
        final PanSourcesFrame sourcesFrame = PanSourcesFrame.findFrame(true);
        PanColorTableList.getList();
        PanOverlayList.getList();
        if (dataFiles_ != null) {
            for (File f : dataFiles_) {
                try {
                    PanFileUtilities.openDataset(sourcesFrame, f);
                }
                catch (Exception exc) {
                    logger_.warn("Skipping {} due to {}", (Object)f.getName(), (Object)exc.toString());
                }
            }
        }
        if (splashStop > 0L) {
            int counter = 0;
            while (System.currentTimeMillis() < splashStop) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (++counter <= 10) continue;
            }
        }
        if (aboutFrame != null) {
            aboutFrame.setVisible(false);
            aboutFrame.setLaunched(true);
        }
        if (sourcesFrame.getDatasetsSubpanel().getDatasetCount() == 0 && prefs.getBoolean("launch:dialog") && (returnVal = (chooser = PanOpenFileChooser.getDataChooser()).showOpenDialog(sourcesFrame)) == 0 && (ff = chooser.getSelectedFiles()) != null) {
            for (File f : ff) {
                PanFileUtilities.openLocalFile(sourcesFrame, f);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                sourcesFrame.setVisible(true);
            }
        });
        Timer t = new Timer(5001, this);
        t.setInitialDelay(5001);
        t.start();
    }

    public static boolean isStarting() {
        return starting_;
    }

    public static void quit() {
        if (quitting_) {
            return;
        }
        quitting_ = true;
        try {
            PanPreferences.getPrefs().save();
            if (server_ != null) {
                server_.close();
            }
            NcUtilities.clearCache();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.exit(0);
    }

    private static void handleCommandLineOptions(String ... args) {
        boolean optionsAllowed = true;
        String dataPath = null;
        ArrayList<String> dataFnames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (optionsAllowed && args[i].startsWith("-")) {
                Marker fatal;
                if (args[i].equals("-m") || args[i].equals("-multi")) {
                    allowMulti_ = true;
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("-datapath")) {
                    if (dataPath != null) {
                        fatal = MarkerFactory.getMarker("FATAL");
                        logger_.error(fatal, "Data path specified more than once");
                        System.exit(1);
                    }
                    if (++i >= args.length) {
                        fatal = MarkerFactory.getMarker("FATAL");
                        logger_.error(fatal, "No value provided for option '-datapath'");
                        System.exit(1);
                        continue;
                    }
                    if (args[i].startsWith("-")) {
                        fatal = MarkerFactory.getMarker("FATAL");
                        logger_.error(fatal, "Bad data path specification '{}'", (Object)args[i]);
                        System.exit(1);
                        continue;
                    }
                    dataPath = args[i];
                    continue;
                }
                if (args[i].equals("-NSDocumentRevisionsDebugMode")) {
                    ++i;
                    continue;
                }
                if (args[i].equals("--")) {
                    optionsAllowed = false;
                    continue;
                }
                fatal = MarkerFactory.getMarker("FATAL");
                logger_.error(fatal, "Unknown command-line option '{}'", (Object)args[i]);
                System.exit(1);
                continue;
            }
            dataFnames.add(args[i]);
        }
        dataFiles_ = new ArrayList(dataFnames.size());
        if (dataFnames.size() > 0) {
            File dataPathdir = null;
            try {
                if (dataPath != null) {
                    dataPathdir = new File(dataPath);
                }
            }
            catch (Exception exc) {
                Marker fatal = MarkerFactory.getMarker("FATAL");
                logger_.error(fatal, "Bad data path specification '{}'", (Object)dataPath);
                System.exit(2);
            }
            for (String fname : dataFnames) {
                if (!NcFilenameFilter.accept(fname)) {
                    logger_.warn("Skipping '{}'. No netCDF filename extension", (Object)fname);
                    continue;
                }
                try {
                    File f = new File(dataPathdir, fname);
                    if (f.exists()) {
                        dataFiles_.add(new File(dataPathdir, fname));
                        continue;
                    }
                    logger_.warn("Skipping '{}'. Does not exist", (Object)fname);
                }
                catch (Exception exc) {
                    logger_.warn("Skipping '{}' due to {} ", (Object)fname, (Object)exc.toString());
                }
            }
        }
    }

    private static boolean isAlreadyRunning() {
        try {
            PanClient client = new PanClient(dataFiles_);
            logger_.info("A copy of Panoply is already running");
            return true;
        }
        catch (Exception exc) {
            try {
                server_ = new PanServer();
            }
            catch (Exception exc2) {
                logger_.error("Could not create PanServer due to {}", (Object)exc2.toString());
            }
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (quitting_) {
            return;
        }
        if (!PlatformUtilities.isMacintosh()) {
            boolean oneIsVisible = false;
            for (Frame frame : Frame.getFrames()) {
                if (!frame.isVisible()) continue;
                oneIsVisible = true;
                break;
            }
            if (!oneIsVisible) {
                Panoply.quit();
                return;
            }
        }
        EventQueue.invokeLater(new Runnable(){
            int prefCounter_ = 0;

            @Override
            public void run() {
                ++this.prefCounter_;
                if (this.prefCounter_ > 40 && !quitting_) {
                    PanPreferences.getPrefs().save();
                    this.prefCounter_ = 0;
                }
            }
        });
    }
}

