/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanNumberFormatMenu;
import gov.nasa.giss.panoply.PanVertUnit;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.PanXVertData;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public abstract class PanXVertGridControls
extends PanAbstractControlsPanel {
    protected PanEnumMenu yUnitsMenu_;
    protected PanNumberFormatMenu yFormatMenu_;
    protected JRadioButton dfltYAxisCapButton_;
    protected JRadioButton userYAxisCapButton_;
    protected JTextField yAxisCapTF_;
    protected JTextField minVertTF_;
    protected JTextField maxVertTF_;
    protected JCheckBox yAxisInvertedCB_;

    public PanXVertGridControls(String id, PanPlotMeta pmeta) {
        super(id, pmeta);
    }

    protected void createLayout() {
        FlexingGridLayout fgl = new FlexingGridLayout(6, 5, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setColumnWeight(5, 9999.0f);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add(Box.createHorizontalStrut(8), new FGConstraint(2, 0));
    }

    protected void addVertControls() {
        JLabel vertLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Vert Axis: ");
        JLabel vertLabel1 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Min ");
        JLabel vertLabel2 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Max ");
        JLabel vertLabel3 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, " \u2012 ");
        this.maxVertTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:yaxis.max", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:yaxis.max")), 6);
        this.minVertTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:yaxis.min", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:yaxis.min")), 6);
        this.maxVertTF_.setHorizontalAlignment(4);
        this.minVertTF_.setHorizontalAlignment(4);
        this.yAxisInvertedCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:yaxis.inverted", "Flip axis?", this.pmeta_.getBoolean("plot:yaxis.inverted"));
        QuickBox vertRangeBox = QuickBox.createLeftBox(vertLabel1, this.minVertTF_, vertLabel2, this.maxVertTF_, vertLabel3, this.yAxisInvertedCB_);
        JLabel unitsLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Units: ");
        this.yUnitsMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.SMALL, "plot:yaxis.units", PanVertUnit.class);
        this.yUnitsMenu_.setSelectedItem(this.pmeta_.getString("plot:yaxis.units"));
        JLabel formatLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ",  Format: ");
        this.yFormatMenu_ = PanWidgetUtils.getNumberFormatMenu(PanWidgetUtils.Size.SMALL, "plot:yaxis.pattern");
        this.yFormatMenu_.setSelectedItem(this.pmeta_.getString("plot:yaxis.pattern"));
        this.yFormatMenu_.setEnabled(this.yUnitsMenu_.getSelectedItem() != PanVertUnit.INDEX);
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel, this.yUnitsMenu_, formatLabel, this.yFormatMenu_);
        JLabel captionLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Caption: ");
        this.dfltYAxisCapButton_ = PanWidgetUtils.getRadioButton(PanWidgetUtils.Size.SMALL, "plot:yaxis.label.default", "Default", this.pmeta_.getBoolean("plot:yaxis.label.default"));
        this.userYAxisCapButton_ = PanWidgetUtils.getRadioButton(PanWidgetUtils.Size.SMALL, null, "Other: ", !this.pmeta_.getBoolean("plot:yaxis.label.default"));
        ButtonGroup axisChoices = new ButtonGroup();
        axisChoices.add(this.dfltYAxisCapButton_);
        axisChoices.add(this.userYAxisCapButton_);
        this.yAxisCapTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:yaxis.label.usertext", this.pmeta_.getString("plot:yaxis.label.usertext"));
        QuickBox axisCapBox = QuickBox.createHorizontalBox(captionLabel, this.dfltYAxisCapButton_, this.userYAxisCapButton_, this.yAxisCapTF_);
        this.add((Component)vertLabel, new FGConstraint(0, 0, 0.0, 0.5));
        this.add((Component)vertRangeBox, new FGConstraint(1, 0, 0.0, 0.5));
        this.add((Component)unitsBox, new FGConstraint(1, 1, 0.0, 0.5));
        this.add((Component)axisCapBox, new FGConstraint(1, 2, 0.0, 0.5));
        int tfh = this.yAxisCapTF_.getPreferredSize().height;
        this.yAxisCapTF_.setMinimumSize(new Dimension(175, tfh));
        this.yAxisCapTF_.setPreferredSize(new Dimension(300, tfh));
        this.yAxisCapTF_.setMaximumSize(new Dimension(1000, tfh));
    }

    protected void attachVertListeners() {
        FocusListener vertFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanXVertGridControls.this.handleVertExtrema(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener vertAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanXVertGridControls.this.handleVertExtrema(e);
            }
        };
        this.maxVertTF_.addFocusListener(vertFL);
        this.minVertTF_.addFocusListener(vertFL);
        this.maxVertTF_.addActionListener(vertAL);
        this.minVertTF_.addActionListener(vertAL);
        this.yAxisInvertedCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanXVertGridControls.this.pmeta_.setBoolean("plot:yaxis.inverted", PanXVertGridControls.this.yAxisInvertedCB_.isSelected());
            }
        });
        this.yUnitsMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanXVertGridControls.this.handleYUnits(e);
            }
        });
        this.yFormatMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanXVertGridControls.this.pmeta_.setString("plot:yaxis.pattern", PanXVertGridControls.this.yFormatMenu_.getSelectedItem().toString());
            }
        });
        this.dfltYAxisCapButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanXVertGridControls.this.pmeta_.setBoolean("plot:yaxis.label.default", PanXVertGridControls.this.dfltYAxisCapButton_.isSelected());
            }
        });
        this.userYAxisCapButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanXVertGridControls.this.pmeta_.setBoolean("plot:yaxis.label.default", !PanXVertGridControls.this.userYAxisCapButton_.isSelected());
            }
        });
        this.yAxisCapTF_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanXVertGridControls.this.pmeta_.setString("plot:yaxis.label.usertext", PanXVertGridControls.this.yAxisCapTF_.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.yAxisCapTF_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanXVertGridControls.this.pmeta_.setString("plot:yaxis.label.usertext", PanXVertGridControls.this.yAxisCapTF_.getText());
            }
        });
    }

    protected void handleYUnits(EventObject e) {
        PanVertUnit unit = (PanVertUnit)this.yUnitsMenu_.getSelectedItem();
        this.pmeta_.setString("plot:yaxis.units", unit.getValue());
        PanXVertData data = (PanXVertData)this.getData();
        data.setVertAxisScheme(unit);
        double min = data.getTopBound();
        double max = data.getBottomBound();
        if (min > max) {
            double foo = min;
            min = max;
            max = foo;
        } else if (min == max) {
            max = min + 0.01;
        }
        this.minVertTF_.setText(PanConstants.PFORMAT_4G.sprintf(min));
        this.maxVertTF_.setText(PanConstants.PFORMAT_4G.sprintf(max));
        this.handleVertExtrema(null);
        this.yFormatMenu_.setEnabled(unit != PanVertUnit.INDEX);
    }

    protected void handleVertExtrema(EventObject e) {
        double max = 0.0;
        double min = 0.0;
        double oldmax = this.pmeta_.getDouble("plot:yaxis.max");
        double oldmin = this.pmeta_.getDouble("plot:yaxis.min");
        if (e == null || e.getSource() == this.maxVertTF_) {
            try {
                max = TextUtilities.parseDouble(this.maxVertTF_.getText());
            }
            catch (Exception exc) {
                this.maxVertTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
                return;
            }
        } else {
            max = oldmax;
        }
        if (e == null || e.getSource() == this.minVertTF_) {
            try {
                min = TextUtilities.parseDouble(this.minVertTF_.getText());
            }
            catch (Exception exc) {
                this.minVertTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
                return;
            }
        } else {
            min = oldmin;
        }
        if (e == null) {
            this.pmeta_.setDouble("plot:yaxis.min", min);
            this.pmeta_.setDouble("plot:yaxis.max", max);
        } else if (e.getSource() == this.maxVertTF_) {
            if (max <= min) {
                this.maxVertTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            } else {
                this.pmeta_.setDouble("plot:yaxis.max", max);
            }
        } else if (e.getSource() == this.minVertTF_) {
            if (min >= max) {
                this.minVertTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            } else {
                this.pmeta_.setDouble("plot:yaxis.min", min);
            }
        }
    }
}

