/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanVertUnit;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Converter;
import ucar.units.Unit;

public abstract class PanXVertData
extends PanAbstractData2D {
    private static Logger logger_ = LoggerFactory.getLogger(PanXVertData.class);
    protected PanVertUnit yAxisScheme_ = null;
    protected Converter vertConverter1_ = null;
    protected Converter vertConverter2_ = null;
    protected double xPxlPerDeg_;
    protected double yPxlPer_;
    private boolean needsEdgeTest_ = true;
    private double userYMin_ = Double.NaN;
    private double userYMax_ = Double.NaN;
    protected double logTBound_ = Double.NaN;
    protected double logBBound_ = Double.NaN;

    public PanXVertData(NcArray2D nca2D, Dimension size) {
        this(nca2D, size.width, size.height);
    }

    public PanXVertData(NcArray2D nca2D, int width, int height) {
        super(nca2D, width, height);
    }

    @Override
    public String getYAxisName() {
        String yname = this.getYAxis().getLongName();
        StringBuilder sb = new StringBuilder();
        if (yname.indexOf(" (") > -1) {
            sb.append(yname.substring(0, yname.indexOf(" (")));
        } else {
            sb.append(yname);
        }
        return sb.toString();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.needsEdgeTest_ = true;
    }

    @Override
    public String getYAxisUnits() {
        String yunits = this.getYAxis().getUnits();
        if (yunits.equals("") || yunits.equals("-")) {
            return null;
        }
        return yunits;
    }

    public PanVertUnit getVertAxisScheme() {
        return this.yAxisScheme_;
    }

    public void setVertAxisScheme(String scheme) {
        if (PanVertUnit.SCALAR.matches(scheme)) {
            this.setVertAxisScheme(PanVertUnit.SCALAR);
        } else if (PanVertUnit.LOG10.matches(scheme)) {
            this.setVertAxisScheme(PanVertUnit.LOG10);
        } else if (PanVertUnit.INDEX.matches(scheme)) {
            this.setVertAxisScheme(PanVertUnit.INDEX);
        } else {
            throw new IllegalArgumentException("Scheme name does not match a PanVertUnit");
        }
    }

    public void setVertAxisScheme(PanVertUnit scheme) {
        this.yAxisScheme_ = scheme;
        this.userYMin_ = Double.NaN;
        this.userYMax_ = Double.NaN;
        this.needsEdgeTest_ = true;
        this.updateGrid();
        this.setBoundsChanged();
        this.fireDataChanged("axis");
    }

    public double getTopBound() {
        if (this.needsEdgeTest_) {
            this.updateGrid();
        }
        return this.tBound_;
    }

    public double getBottomBound() {
        if (this.needsEdgeTest_) {
            this.updateGrid();
        }
        return this.bBound_;
    }

    public void setVertRange(double min, double max) {
        this.userYMin_ = min;
        this.userYMax_ = max;
        this.needsEdgeTest_ = true;
        this.updateGrid();
        this.setBoundsChanged();
        this.fireDataChanged("axis");
    }

    @Override
    protected void updateGrid() {
        int i;
        this.xPxlPerDeg_ = (double)this.gridWidth_ / (this.rBound_ - this.lBound_);
        for (i = 0; i < this.gridWidth_; ++i) {
            this.colX_[i] = this.lBound_ + ((double)i + 0.5) / this.xPxlPerDeg_;
        }
        if (this.ncArrays_[1] != null) {
            Unit u1 = ((NcArray2D)this.ncArrays_[0]).getYAxis().getUcarUnits();
            Unit u2 = ((NcArray2D)this.ncArrays_[1]).getYAxis().getUcarUnits();
            try {
                this.vertConverter1_ = u1.getConverterTo(u2);
                this.vertConverter2_ = u2.getConverterTo(u1);
            }
            catch (Exception exc) {
                this.vertConverter1_ = null;
                this.vertConverter2_ = null;
            }
        } else {
            this.vertConverter1_ = null;
            this.vertConverter2_ = null;
        }
        if (Double.isNaN(this.userYMin_) || Double.isNaN(this.userYMax_)) {
            this.tBound_ = Double.NaN;
            this.bBound_ = Double.NaN;
            for (i = 0; i < 2; ++i) {
                double b;
                double t;
                if (this.ncArrays_[i] == null || this.combination_ == PanCombinationType.A1_ONLY && i == 1 || this.combination_ == PanCombinationType.A2_ONLY && i == 0) continue;
                NcAxis yAxis = ((NcArray2D)this.ncArrays_[i]).getYAxis();
                int isize = yAxis.getSize();
                double[][] yBounds = yAxis.getBounds();
                double[] yValues = yAxis.getValues();
                if (this.yAxisScheme_ == PanVertUnit.INDEX) {
                    t = 0.0;
                    b = isize;
                } else {
                    t = yBounds[0][0];
                    b = yBounds[isize - 1][1];
                    if (i == 1 && this.vertConverter2_ != null) {
                        t = this.vertConverter2_.convert(t);
                        b = this.vertConverter2_.convert(b);
                    }
                }
                if (Double.isNaN(this.tBound_)) {
                    this.tBound_ = t;
                    this.bBound_ = b;
                    continue;
                }
                if (b < t) {
                    this.tBound_ = Math.min(this.tBound_, t);
                    this.bBound_ = Math.max(this.bBound_, b);
                    continue;
                }
                this.tBound_ = Math.max(this.tBound_, t);
                this.bBound_ = Math.min(this.bBound_, b);
            }
        } else {
            NcAxis yAxis = null;
            yAxis = this.combination_ == PanCombinationType.A2_ONLY ? ((NcArray2D)this.ncArrays_[1]).getYAxis() : ((NcArray2D)this.ncArrays_[0]).getYAxis();
            if (this.yAxisScheme_ == PanVertUnit.INDEX) {
                this.tBound_ = this.userYMin_;
                this.bBound_ = this.userYMax_;
            } else if (yAxis.isPositive()) {
                this.tBound_ = this.userYMax_;
                this.bBound_ = this.userYMin_;
            } else {
                this.tBound_ = this.userYMin_;
                this.bBound_ = this.userYMax_;
            }
        }
        if (this.yAxisScheme_ == PanVertUnit.LOG10) {
            if (this.tBound_ <= 0.0) {
                this.tBound_ = 1.0E-50;
            }
            if (this.bBound_ <= 0.0) {
                this.bBound_ = 1.0E-50;
            }
            this.logTBound_ = Math.log10(this.tBound_);
            this.logBBound_ = Math.log10(this.bBound_);
            this.yPxlPer_ = (double)this.gridHeight_ / (this.logBBound_ - this.logTBound_);
            for (int j = 0; j < this.gridHeight_; ++j) {
                this.rowY_[j] = this.logTBound_ + ((double)j + 0.5) / this.yPxlPer_;
            }
        } else {
            this.yPxlPer_ = (double)this.gridHeight_ / (this.bBound_ - this.tBound_);
            for (int j = 0; j < this.gridHeight_; ++j) {
                this.rowY_[j] = this.tBound_ + ((double)j + 0.5) / this.yPxlPer_;
            }
        }
        this.needsEdgeTest_ = false;
    }

    public Point2D.Double transformXY2GridCoords(double x, double y) {
        double xx = this.lBound_ + x / this.xPxlPerDeg_;
        double yy = this.tBound_ + y / this.yPxlPer_;
        return new Point2D.Double(xx, yy);
    }
}

