/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.menu.GissCheckBoxMenuItem;
import gov.nasa.giss.gui.menu.GissMenuItem;
import gov.nasa.giss.panoply.PanAboutFrame;
import gov.nasa.giss.panoply.PanColorTableBrowser;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanHiddenMacFrame;
import gov.nasa.giss.panoply.PanMenu;
import gov.nasa.giss.panoply.PanOverlayBrowser;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferencesFrame;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;

public class PanWindowMenu
extends PanMenu {
    private JCheckBoxMenuItem miShowDatasets_;
    private JCheckBoxMenuItem miShowColorTables_;
    private JCheckBoxMenuItem miShowOverlays_;
    private JCheckBoxMenuItem miPreferences_;
    private JCheckBoxMenuItem miAbout_;
    private int coreItemsCount_;

    public PanWindowMenu(PanFrame parent) {
        super(parent, "window-menu");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanWindowMenu.this.pframe_.setState(1);
            }
        };
        GissMenuItem jmi = this.makeItemFromProperties("minimize-window", a);
        this.add(jmi);
        if (PlatformUtilities.isMacintosh()) {
            jmi.setEnabled(!(parent instanceof PanHiddenMacFrame));
        } else {
            jmi.setEnabled(true);
        }
        this.addSeparator();
        this.miShowDatasets_ = this.makeCheckBoxItemFromProperties("show-sources-window", null);
        this.miShowDatasets_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanSourcesFrame.findFrame(true).reveal();
                PanWindowMenu.this.miShowDatasets_.setSelected(true);
            }
        });
        this.add(this.miShowDatasets_).setEnabled(true);
        this.miShowColorTables_ = this.makeCheckBoxItemFromProperties("show-colorbar-window", null);
        this.miShowColorTables_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanColorTableBrowser.findFrame(true).reveal();
                PanWindowMenu.this.miShowColorTables_.setSelected(true);
            }
        });
        this.add(this.miShowColorTables_).setEnabled(true);
        this.miShowOverlays_ = this.makeCheckBoxItemFromProperties("show-overlay-window", null);
        this.miShowOverlays_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanOverlayBrowser.findFrame(true).reveal();
                PanWindowMenu.this.miShowOverlays_.setSelected(true);
            }
        });
        this.add(this.miShowOverlays_).setEnabled(true);
        this.coreItemsCount_ = this.getItemCount();
        if (!PlatformUtilities.isMacintosh()) {
            this.miPreferences_ = this.makeCheckBoxItemFromProperties("show-preferences-2", null);
            this.miPreferences_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPreferencesFrame.findFrame(true).reveal();
                    PanWindowMenu.this.miPreferences_.setSelected(true);
                }
            });
            this.add(this.miPreferences_).setEnabled(true);
            this.miAbout_ = this.makeCheckBoxItemFromProperties("show-about", null);
            this.miAbout_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanAboutFrame.findFrame(true).reveal();
                    PanWindowMenu.this.miAbout_.setSelected(true);
                }
            });
            this.add(this.miAbout_).setEnabled(true);
        }
    }

    @Override
    public void refresh() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return;
        }
        int msize = this.getItemCount();
        for (int i = this.coreItemsCount_; i < msize; ++i) {
            this.remove(this.coreItemsCount_);
        }
        this.miShowDatasets_.setSelected(window instanceof PanSourcesFrame);
        this.miShowColorTables_.setSelected(window instanceof PanColorTableBrowser);
        this.miShowOverlays_.setSelected(window instanceof PanOverlayBrowser);
        PanPlotFrame[] plotFrames = PanPlotFrame.getListOfFrames();
        if (plotFrames.length > 0) {
            this.addSeparator();
            PanPlotFrame[] arr$ = plotFrames;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PanPlotFrame pf;
                final PanPlotFrame ff = pf = arr$[i$];
                final GissCheckBoxMenuItem mi = this.makeCheckBoxItem(ff.getTitle(), null);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ff.reveal();
                        mi.setSelected(true);
                    }
                });
                this.add(mi).setEnabled(true);
                mi.setSelected(ff == window);
            }
        }
        if (!PlatformUtilities.isMacintosh()) {
            this.addSeparator();
            this.add(this.miPreferences_).setEnabled(true);
            this.add(this.miAbout_).setEnabled(true);
            this.miPreferences_.setSelected(window instanceof PanPreferencesFrame);
            this.miAbout_.setSelected(window instanceof PanAboutFrame);
        }
        super.refresh();
    }
}

