/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import com.explodingpixels.macwidgets.plaf.HudButtonUI;
import com.explodingpixels.macwidgets.plaf.HudCheckBoxUI;
import com.explodingpixels.macwidgets.plaf.HudLabelUI;
import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import com.explodingpixels.macwidgets.plaf.HudRadioButtonUI;
import com.explodingpixels.macwidgets.plaf.HudTextFieldUI;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.label.VerticalLabel;
import gov.nasa.giss.gui.plaf.GissComboBoxUI;
import gov.nasa.giss.gui.plaf.GissHudComboBoxUI;
import gov.nasa.giss.gui.plaf.GissHudSpinnerUI;
import gov.nasa.giss.gui.spinner.IntSpinner;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanColorTableMenu;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanFontMenu;
import gov.nasa.giss.panoply.PanGridSpacingMenu;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanNumberFormatMenu;
import gov.nasa.giss.panoply.PanOverlayMenu;
import gov.nasa.giss.panoply.PanProjectionMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.Document;

public class PanWidgetUtils {
    private PanWidgetUtils() {
    }

    public static JLabel getLabel(Size size, String text) {
        JLabel jl = new JLabel(text);
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jl);
        }
        return jl;
    }

    public static JLabel getLabel(Size size, String text, int hAlignment) {
        JLabel jl = new JLabel(text, hAlignment);
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jl);
        }
        return jl;
    }

    public static VerticalLabel getVerticalLabel(Size size, String text) {
        VerticalLabel jl = new VerticalLabel(text);
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jl);
        }
        return jl;
    }

    public static VerticalLabel getVerticalLabel(Size size, String text, int direction) {
        VerticalLabel jl = new VerticalLabel(text, direction);
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jl);
        }
        return jl;
    }

    public static JComboBox getComboBox(Size size, String name) {
        JComboBox m = new JComboBox();
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static JComboBox getComboBox(Size size, String name, Object[] objects) {
        JComboBox<Object> m = new JComboBox<Object>(objects);
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static JComboBox getEditableComboBox(Size size, String name, Object[] objects) {
        JComboBox<Object> m = new JComboBox<Object>(objects);
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setEditable(true);
        return m;
    }

    public static PanEnumMenu getEnumMenu(Size size, String name, Class eclass) {
        if (!eclass.isEnum()) {
            throw new IllegalArgumentException("Not an enum");
        }
        T[] vals = eclass.getEnumConstants();
        if (vals.length > 0 && !(vals[0] instanceof PanMenuItemEnum)) {
            throw new IllegalArgumentException(eclass + " not instanceof PanMenuItemEnum");
        }
        PanEnumMenu m = new PanEnumMenu(eclass);
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static ColorMenu getColorMenu(Size size, String name, PaletteType ptype) {
        ColorMenu m = new ColorMenu(ptype);
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        return m;
    }

    public static PanFontMenu getFontMenu(Size size, String name) {
        PanFontMenu m = new PanFontMenu();
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static PanColorTableMenu getColorTableMenu(Size size, String name, boolean showSample) {
        PanColorTableMenu m = new PanColorTableMenu(showSample);
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static PanGridSpacingMenu getGridSpacingMenu(Size size, String name) {
        PanGridSpacingMenu m = new PanGridSpacingMenu();
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static PanNumberFormatMenu getNumberFormatMenu(Size size, String name) {
        PanNumberFormatMenu m = new PanNumberFormatMenu();
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static PanOverlayMenu getOverlayMenu(Size size, boolean includeNull) {
        PanOverlayMenu m = new PanOverlayMenu(includeNull);
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static PanProjectionMenu getProjectionMenu(Size size, String name, boolean visiblesOnly, boolean includeRegional) {
        PanProjectionMenu m = new PanProjectionMenu(visiblesOnly, includeRegional);
        if (name != null) {
            m.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(m);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(m);
        }
        m.setUI(new GissComboBoxUI());
        return m;
    }

    public static JButton getButton(Size size, String name, Action action) {
        JButton b = new JButton(action);
        if (name != null) {
            b.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(b);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(b);
        }
        return b;
    }

    public static JButton getButton(Size size, String name, String text) {
        JButton b = new JButton(text);
        if (name != null) {
            b.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(b);
        } else if (size == Size.NORMAL) {
            PanWidgetUtils.applyNormalUI(b);
        }
        return b;
    }

    public static JCheckBox getCheckBox(Size size, String name, Action action) {
        JCheckBox jcb = new JCheckBox(action);
        if (name != null) {
            jcb.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jcb);
        }
        return jcb;
    }

    public static JCheckBox getCheckBox(Size size, String name, String text) {
        return PanWidgetUtils.getCheckBox(size, name, text, false);
    }

    public static JCheckBox getCheckBox(Size size, String name, String text, boolean toggled) {
        JCheckBox jcb = new JCheckBox(text, toggled);
        if (name != null) {
            jcb.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jcb);
        }
        return jcb;
    }

    public static JRadioButton getRadioButton(Size size, String name, String text, boolean toggled) {
        JRadioButton jrb = new JRadioButton(text, toggled);
        if (name != null) {
            jrb.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jrb);
        }
        return jrb;
    }

    public static JSpinner getSpinner(Size size, String name, SpinnerNumberModel model) {
        JSpinner js = new JSpinner(model);
        if (name != null) {
            js.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(js);
        }
        return js;
    }

    public static IntSpinner getIntSpinner(Size size, String name, int value, int min, int max, int step) {
        IntSpinner js = new IntSpinner(value, min, max, step);
        if (name != null) {
            js.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(js);
        }
        return js;
    }

    public static PercentSpinner getPercentSpinner(Size size, String name) {
        return PanWidgetUtils.getPercentSpinner(size, name, 0);
    }

    public static PercentSpinner getPercentSpinner(Size size, String name, int startValue) {
        PercentSpinner js = new PercentSpinner(startValue);
        if (name != null) {
            js.setName(name);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(js);
        }
        return js;
    }

    public static JTextField getTextField(Size size, String name, String text) {
        return PanWidgetUtils.getTextField(size, name, null, text, 0);
    }

    public static JTextField getTextField(Size size, String name, Document doc, String text, int cols) {
        JTextField jtf = new JTextField();
        if (name != null) {
            jtf.setName(name);
        }
        if (doc != null) {
            jtf.setDocument(doc);
        }
        if (text != null) {
            jtf.setText(text);
        }
        if (cols > 0) {
            jtf.setColumns(cols);
        }
        if (size == Size.SMALL) {
            PanWidgetUtils.applySmallUI(jtf);
        }
        return jtf;
    }

    public static void applySmallUI(JComponent jc) {
        jc.setOpaque(false);
        if (jc instanceof JCheckBox || jc instanceof JComboBox || jc instanceof JLabel || jc instanceof VerticalLabel || jc instanceof JRadioButton || jc instanceof JSpinner || jc instanceof JTextField || jc instanceof JButton || jc instanceof JToggleButton || jc instanceof Box || jc instanceof JPanel) {
            GuiUtilities.setSizeSmall(jc);
        }
        if (jc instanceof Container) {
            for (Component c : jc.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                PanWidgetUtils.applySmallUI((JComponent)c);
            }
        }
        PanWidgetUtils.restrictWidgetSize(jc);
    }

    public static void applyNormalUI(JComponent jc) {
        jc.setOpaque(false);
        if (jc instanceof Container) {
            for (Component c : jc.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                PanWidgetUtils.applyNormalUI((JComponent)c);
            }
        }
    }

    public static void applyHudUI(JComponent jc) {
        if (jc instanceof JCheckBox) {
            ((JCheckBox)jc).setUI(new HudCheckBoxUI());
        } else if (jc instanceof JComboBox) {
            ((JComboBox)jc).setUI(new GissHudComboBoxUI());
        } else if (jc instanceof JLabel) {
            ((JLabel)jc).setUI(new HudLabelUI());
        } else if (jc instanceof JLabel) {
            jc.setFont(HudPaintingUtils.getHudFont());
            jc.setForeground(HudPaintingUtils.FONT_COLOR);
            jc.setOpaque(false);
        } else if (jc instanceof JRadioButton) {
            ((JRadioButton)jc).setUI(new HudRadioButtonUI());
        } else if (jc instanceof JSpinner) {
            ((JSpinner)jc).setUI(new GissHudSpinnerUI());
        } else if (jc instanceof JTextField) {
            ((JTextField)jc).setUI(new HudTextFieldUI());
        } else if (jc instanceof Box || jc instanceof JPanel) {
            Component[] children;
            for (Component c : children = jc.getComponents()) {
                PanWidgetUtils.applyHudUI((JComponent)c);
            }
        } else if (jc instanceof JButton) {
            ((JButton)jc).setUI(new HudButtonUI());
        }
        GuiUtilities.restrictSize(jc);
        PanWidgetUtils.restrictWidgetSize(jc);
    }

    public static void restrictWidgetSize(JComponent jc) {
        if (jc instanceof JCheckBox || jc instanceof JRadioButton) {
            jc.setPreferredSize(null);
            Dimension d = jc.getPreferredSize();
            d.width += 10;
            jc.setMinimumSize(d);
            jc.setPreferredSize(d);
        }
    }

    public static enum Size {
        SMALL,
        NORMAL;

    }
}

