/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.menu.GissRadioButtonMenuItem;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanMenu;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotSizeMenu;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;

public class PanViewMenu
extends PanMenu {
    private JMenuItem toogleToolbarLabelsItem_;
    private JMenuItem toogleVariablesItem_;

    public PanViewMenu(PanFrame parent) {
        super(parent, "view-menu");
        boolean parentIsSources = parent instanceof PanSourcesFrame;
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanViewMenu.toogleToolbarLabels();
            }
        };
        this.toogleToolbarLabelsItem_ = this.makeItemFromProperties("show-toolbar-labels", a);
        this.add(this.toogleToolbarLabelsItem_).setEnabled(true);
        this.addSeparator();
        AbstractAction a1 = null;
        AbstractAction a2 = null;
        AbstractAction a3 = null;
        if (parentIsSources) {
            a1 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((PanSourcesFrame)PanViewMenu.this.pframe_).showSubpanel(PanSourcesFrame.Subpanel.DATASETS);
                }
            };
            a2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((PanSourcesFrame)PanViewMenu.this.pframe_).showSubpanel(PanSourcesFrame.Subpanel.CATALOGS);
                }
            };
            a3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((PanSourcesFrame)PanViewMenu.this.pframe_).showSubpanel(PanSourcesFrame.Subpanel.BOOKMARKS);
                }
            };
        }
        GissRadioButtonMenuItem mi1 = this.makeRadioButtonItemFromProperties("show-datasets", a1);
        GissRadioButtonMenuItem mi2 = this.makeRadioButtonItemFromProperties("show-catalogs", a2);
        GissRadioButtonMenuItem mi3 = this.makeRadioButtonItemFromProperties("show-bookmarks", a3);
        this.add(mi1).setEnabled(parentIsSources);
        this.add(mi2).setEnabled(parentIsSources);
        this.add(mi3).setEnabled(parentIsSources);
        ButtonGroup bg = new ButtonGroup();
        bg.add(mi1);
        bg.add(mi2);
        bg.add(mi3);
        this.addSeparator();
        this.add(this.makeItemFromProperties("show-larger", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("show-smaller", null)).setEnabled(false);
        this.add(new PanPlotSizeMenu(parent));
        this.addSeparator();
        this.toogleVariablesItem_ = this.makeItemFromProperties("toggle-plottables", null);
        this.add(this.toogleVariablesItem_).setEnabled(false);
        this.addSeparator();
        GissRadioButtonMenuItem mi12 = this.makeRadioButtonItemFromProperties("show-plot", null);
        GissRadioButtonMenuItem mi22 = this.makeRadioButtonItemFromProperties("show-array-1", null);
        GissRadioButtonMenuItem mi32 = this.makeRadioButtonItemFromProperties("show-array-2", null);
        this.add(mi12).setEnabled(parentIsPlot);
        this.add(mi22).setEnabled(parentIsPlot);
        this.add(mi32).setEnabled(false);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(mi12);
        bg2.add(mi22);
        bg2.add(mi32);
        this.addSeparator();
        mi12 = this.makeRadioButtonItemFromProperties("show-array-controls", null);
        mi22 = this.makeRadioButtonItemFromProperties("show-scale-controls", null);
        mi32 = this.makeRadioButtonItemFromProperties("show-contour-controls", null);
        GissRadioButtonMenuItem mi4 = this.makeRadioButtonItemFromProperties("show-grid-controls", null);
        GissRadioButtonMenuItem mi5 = this.makeRadioButtonItemFromProperties("show-label-controls", null);
        this.add(mi12).setEnabled(parentIsPlot);
        this.add(mi22).setEnabled(parentIsPlot);
        this.add(mi32).setEnabled(parentIsPlot);
        this.add(mi4).setEnabled(parentIsPlot);
        this.add(mi5).setEnabled(parentIsPlot);
        ButtonGroup bg3 = new ButtonGroup();
        bg3.add(mi12);
        bg3.add(mi22);
        bg3.add(mi32);
        bg3.add(mi4);
        bg3.add(mi5);
        this.refresh();
    }

    private static void toogleToolbarLabels() {
        boolean showLabels = PREFS.getBoolean("sources:toolbar.labels");
        PREFS.setBoolean("sources:toolbar.labels", !showLabels);
        PanSourcesFrame df = PanSourcesFrame.findFrame(false);
        if (df != null) {
            df.refresh();
        }
        GuiUtilities.refreshFrontFrameMenuBar();
    }

    private static void toogleVariables() {
        boolean newVal = !PREFS.getBoolean("sources:nodes.plottables");
        PREFS.setBoolean("sources:nodes.plottables", newVal);
        PanSourcesFrame.findFrame(true).getDatasetsSubpanel().setShowOnlyPlottables(newVal);
        GuiUtilities.refreshFrontFrameMenuBar();
    }

    @Override
    public void refresh() {
        boolean showLabels = PREFS.getBoolean("sources:toolbar.labels");
        boolean showOnly = PREFS.getBoolean("sources:nodes.plottables");
        if (showLabels) {
            this.toogleToolbarLabelsItem_.setText(PanProperties.MENUS.getString("hide-toolbar-labels"));
        } else {
            this.toogleToolbarLabelsItem_.setText(PanProperties.MENUS.getString("show-toolbar-labels"));
        }
        if (showOnly && this.pframe_ instanceof PanSourcesFrame) {
            this.toogleVariablesItem_.setText(PanProperties.MENUS.getString("show-all-variables"));
        } else {
            this.toogleVariablesItem_.setText(PanProperties.MENUS.getString("toggle-plottables"));
        }
        super.refresh();
    }
}

