/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.IntSpinner;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanVectorStyle;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanVectorPrefsPanel
extends PanAbstractPrefsPanel {
    private PanEnumMenu styleMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.NORMAL, null, PanVectorStyle.class);
    private ColorMenu colorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.RAINBOW);
    private PercentSpinner opacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null);
    private IntSpinner spacingSpinner_ = PanWidgetUtils.getIntSpinner(PanWidgetUtils.Size.NORMAL, null, 100, 25, 250, 1);

    public PanVectorPrefsPanel() {
        FlexingGridLayout fgl = new FlexingGridLayout(4, 3, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtilities.createPaddedTitleBorder("Vector Defaults"));
        this.add((Component)new JLabel("Style: "), new FGConstraint(0, 0, 1.0, 0.5));
        this.add((Component)this.styleMenu_, new FGConstraint(1, 0, 0.0, 0.5));
        this.add((Component)new JLabel("Color: "), new FGConstraint(0, 1, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.colorMenu_, new JLabel(", Opacity: "), this.opacitySpinner_), new FGConstraint(1, 1, 0.0, 0.5));
        this.add((Component)new JLabel("Spacing: "), new FGConstraint(0, 2, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.spacingSpinner_, new JLabel("%")), new FGConstraint(1, 2, 0.0, 0.5));
        this.refresh();
        this.addListeners();
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.styleMenu_.setSelectedItem(PREFS.getString("plot:vector.style"));
        this.colorMenu_.setSelectedColor(PREFS.getColor("plot:vector.color"));
        this.opacitySpinner_.setValue(PREFS.getInt("plot:vector.weight"));
        this.spacingSpinner_.setValue(PREFS.getInt("plot:vector.spacing"));
        this.refreshing_ = false;
    }

    private void addListeners() {
        this.styleMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanVectorPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:vector.style", ((PanMenuItemEnum)PanVectorPrefsPanel.this.styleMenu_.getSelectedItem()).getValue());
            }
        });
        this.colorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanVectorPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:vector.color", PanVectorPrefsPanel.this.colorMenu_.getSelectedColor());
            }
        });
        this.opacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanVectorPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:vector.weight", PanVectorPrefsPanel.this.opacitySpinner_.getIntValue());
            }
        });
        this.spacingSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanVectorPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:vector.spacing", PanVectorPrefsPanel.this.spacingSpinner_.getIntValue());
            }
        });
    }
}

