/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.label.MultiLineLabel;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanTimeLatPrefsPanel
extends PanAbstractPrefsPanel {
    private ColorMenu gColorMenu_;
    private PercentSpinner gOpacitySpinner_;
    private JTextField maxLatTF_;
    private JTextField minLatTF_;

    public PanTimeLatPrefsPanel() {
        MultiLineLabel topText = new MultiLineLabel("When creating a new time-lat plot, set\u2026");
        topText.setAlignmentX(0.5f);
        this.gColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.RAINBOW);
        this.gColorMenu_.setSelectedColor(PREFS.getColor("plot:timelat.grid.color"));
        this.gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null, PREFS.getInt("plot:timelat.grid.weight"));
        JLabel latLabel1 = new JLabel("Lat Axis: ");
        JLabel latLabel2 = new JLabel("Min ");
        JLabel latLabel3 = new JLabel("\u00b0N, Max ");
        JLabel latLabel4 = new JLabel("\u00b0N");
        this.minLatTF_ = new JTextField(new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(-90.0), 5);
        this.maxLatTF_ = new JTextField(new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(90.0), 5);
        this.minLatTF_.setHorizontalAlignment(4);
        this.maxLatTF_.setHorizontalAlignment(4);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 5, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, 1, 0.0, 0.5));
        this.add((Component)new JLabel("Grid Color: "), new FGConstraint(0, 2, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.gColorMenu_, new JLabel(", Opacity: "), this.gOpacitySpinner_, new JLabel("%")), new FGConstraint(1, 2, 0.0, 0.5));
        this.add((Component)latLabel1, new FGConstraint(0, 3, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(latLabel2, this.minLatTF_, latLabel3, this.maxLatTF_, latLabel4), new FGConstraint(1, 3, 0.0, 0.5));
        this.refresh();
        this.gOpacitySpinner_.setMaximumSize(this.gOpacitySpinner_.getPreferredSize());
        this.gColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanTimeLatPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:timelat.grid.color", PanTimeLatPrefsPanel.this.gColorMenu_.getSelectedColor());
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanTimeLatPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:timelat.grid.weight", PanTimeLatPrefsPanel.this.gOpacitySpinner_.getIntValue());
            }
        });
        FocusListener latFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanTimeLatPrefsPanel.this.handleLatExtrema(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener latAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanTimeLatPrefsPanel.this.handleLatExtrema(e);
            }
        };
        this.maxLatTF_.addFocusListener(latFL);
        this.minLatTF_.addFocusListener(latFL);
        this.maxLatTF_.addActionListener(latAL);
        this.minLatTF_.addActionListener(latAL);
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.gColorMenu_.setSelectedColor(PREFS.getColor("plot:timelat.grid.color"));
        this.gOpacitySpinner_.setValue(PREFS.getInt("plot:timelat.grid.weight"));
        this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(PREFS.getDouble("plot:timelat.lataxis.max")));
        this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(PREFS.getDouble("plot:timelat.lataxis.min")));
        this.refreshing_ = false;
    }

    private void handleLatExtrema(EventObject e) {
        double max = 90.0;
        double min = 90.0;
        double oldmax = PREFS.getDouble("plot:timelat.lataxis.max");
        double oldmin = PREFS.getDouble("plot:timelat.lataxis.min");
        try {
            max = TextUtilities.parseDouble(this.maxLatTF_.getText());
        }
        catch (Exception exc) {
            this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            return;
        }
        try {
            min = TextUtilities.parseDouble(this.minLatTF_.getText());
        }
        catch (Exception exc) {
            this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            return;
        }
        if (max > 90.0) {
            max = 90.0;
            this.maxLatTF_.setText("90.");
        }
        if (min < -90.0) {
            min = -90.0;
            this.minLatTF_.setText("-90.");
        }
        if (e.getSource() == this.maxLatTF_) {
            if (max <= min) {
                this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            } else {
                PREFS.setDouble("plot:timelat.lataxis.max", max);
            }
        } else if (e.getSource() == this.minLatTF_) {
            if (min >= max) {
                this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            } else {
                PREFS.setDouble("plot:timelat.lataxis.min", min);
            }
        }
    }
}

