/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.netcdf.NcTimeAxis;
import gov.nasa.giss.netcdf.time.NcDataTime;
import gov.nasa.giss.netcdf.time.NcJulianTime;
import gov.nasa.giss.netcdf.time.NcRelativeTime;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanTimeLatGridControls
extends PanAbstractControlsPanel {
    private static final String NONE = "None";
    private JSpinner xMajorDivSpinner_;
    private JSpinner xMinorDivSpinner_;
    private JTextField maxLatTF_;
    private JTextField minLatTF_;
    private JComboBox timeMenu_;
    private JRadioButton dfltXAxisCapButton_;
    private JRadioButton userXAxisCapButton_;
    private JTextField xAxisCapTF_;
    private ColorMenu gColorMenu_;
    private PercentSpinner gOpacitySpinner_;

    public PanTimeLatGridControls(PanPlotMeta pmeta) {
        super("timelat-grid-controls", pmeta);
        NcDataTime formatter;
        JLabel timeLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Time Axis: ");
        JLabel tdivLabel1 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Divisions: Major: ");
        JLabel tdivLabel2 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Minor: ");
        this.xMajorDivSpinner_ = PanWidgetUtils.getSpinner(PanWidgetUtils.Size.SMALL, "plot:xaxis.majordiv", new SpinnerNumberModel(this.pmeta_.getInt("plot:xaxis.majordiv"), 1, 20, 1));
        this.xMinorDivSpinner_ = PanWidgetUtils.getSpinner(PanWidgetUtils.Size.SMALL, "plot:xaxis.minordiv", new SpinnerNumberModel(this.pmeta_.getInt("plot:xaxis.minordiv"), 1, 20, 1));
        QuickBox divisionsBox = QuickBox.createLeftBox(tdivLabel1, this.xMajorDivSpinner_, tdivLabel2, this.xMinorDivSpinner_);
        QuickBox formatBox = null;
        PanAbstractData2D data = (PanAbstractData2D)this.getData();
        if (((NcTimeAxis)data.getXAxis()).isFormattedTime() && ((formatter = ((NcTimeAxis)data.getXAxis()).getFormatter()) instanceof NcRelativeTime || formatter instanceof NcJulianTime)) {
            JLabel formatLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Format: ");
            Object[] patterns = formatter instanceof NcRelativeTime ? NcRelativeTime.PATTERNS : NcJulianTime.PATTERNS;
            this.timeMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:xaxis.pattern", patterns);
            this.timeMenu_.insertItemAt(NONE, 0);
            this.timeMenu_.setSelectedItem(this.pmeta_.getString("plot:xaxis.pattern"));
            this.timeMenu_.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    String pattern = PanTimeLatGridControls.this.timeMenu_.getSelectedItem().toString();
                    if (pattern == PanTimeLatGridControls.NONE) {
                        pattern = "";
                    }
                    PanTimeLatGridControls.this.pmeta_.setString("plot:xaxis.pattern", pattern);
                }
            });
            formatBox = QuickBox.createLeftBox(formatLabel, this.timeMenu_);
        }
        JLabel captionLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Caption: ");
        this.dfltXAxisCapButton_ = PanWidgetUtils.getRadioButton(PanWidgetUtils.Size.SMALL, "plot:xaxis.label.default", "Default", this.pmeta_.getBoolean("plot:xaxis.label.default"));
        this.userXAxisCapButton_ = PanWidgetUtils.getRadioButton(PanWidgetUtils.Size.SMALL, null, "Other: ", !this.pmeta_.getBoolean("plot:xaxis.label.default"));
        ButtonGroup axisChoices = new ButtonGroup();
        axisChoices.add(this.dfltXAxisCapButton_);
        axisChoices.add(this.userXAxisCapButton_);
        this.xAxisCapTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:xaxis.label.usertext", this.pmeta_.getString("plot:xaxis.label.usertext"));
        QuickBox axisCapBox = QuickBox.createHorizontalBox(captionLabel, this.dfltXAxisCapButton_, this.userXAxisCapButton_, this.xAxisCapTF_);
        JLabel latLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Lat Axis: ");
        JLabel latLabel1 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Min ");
        JLabel latLabel2 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0N, Max ");
        JLabel latLabel3 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0N");
        this.maxLatTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:yaxis.max", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:yaxis.max")), 5);
        this.minLatTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:yaxis.min", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:yaxis.min")), 5);
        this.maxLatTF_.setHorizontalAlignment(4);
        this.minLatTF_.setHorizontalAlignment(4);
        QuickBox latRangeBox = QuickBox.createLeftBox(latLabel1, this.minLatTF_, latLabel2, this.maxLatTF_, latLabel3);
        JLabel gColorLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Grid Color: ");
        this.gColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:grid.color", PaletteType.RAINBOW);
        this.gColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:grid.color"));
        JLabel gOpacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Opacity: ");
        this.gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:grid.weight", this.pmeta_.getInt("plot:grid.weight"));
        JLabel gPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        QuickBox gColorBox = QuickBox.createLeftBox(this.gColorMenu_, gOpacityLabel, this.gOpacitySpinner_, gPctLabel);
        FlexingGridLayout fgl = new FlexingGridLayout(6, 6, 0, 2);
        fgl.setColumnWeight(1, 9999.0f);
        fgl.setColumnWeight(5, 9999.0f);
        fgl.setRowWeight(5, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)timeLabel, new FGConstraint(0, 0, 0.0, 0.5));
        this.add((Component)divisionsBox, new FGConstraint(1, 0, 0.0, 0.5));
        if (formatBox != null) {
            this.add((Component)formatBox, new FGConstraint(1, 1, 0.0, 0.5));
            this.add((Component)axisCapBox, new FGConstraint(1, 2, 0.0, 0.5));
        } else {
            this.add((Component)axisCapBox, new FGConstraint(1, 1, 0.0, 0.5));
        }
        this.add(Box.createHorizontalStrut(8), new FGConstraint(2, 0));
        this.add((Component)latLabel, new FGConstraint(3, 0, 0.0, 0.5));
        this.add((Component)latRangeBox, new FGConstraint(4, 0, 0.0, 0.5));
        this.add((Component)gColorLabel, new FGConstraint(3, 1, 0.0, 0.5));
        this.add((Component)gColorBox, new FGConstraint(4, 1, 0.0, 0.5));
        int tfh = this.xAxisCapTF_.getPreferredSize().height;
        this.xAxisCapTF_.setMinimumSize(new Dimension(175, tfh));
        this.xAxisCapTF_.setPreferredSize(new Dimension(300, tfh));
        this.xAxisCapTF_.setMaximumSize(new Dimension(1000, tfh));
        this.attachListeners();
    }

    private void attachListeners() {
        this.gColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = PanTimeLatGridControls.this.gColorMenu_.getSelectedColor();
                if (!cnew.equals(cold = PanTimeLatGridControls.this.pmeta_.getColor("plot:grid.color"))) {
                    PanTimeLatGridControls.this.pmeta_.setColor("plot:grid.color", cnew);
                }
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanTimeLatGridControls.this.pmeta_.setInt("plot:grid.weight", ((PercentSpinner)e.getSource()).getIntValue());
            }
        });
        this.xMajorDivSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                PanTimeLatGridControls.this.pmeta_.setInt("plot:xaxis.majordiv", ((SpinnerNumberModel)spinner.getModel()).getNumber().intValue());
                spinner.repaint();
            }
        });
        this.xMinorDivSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                PanTimeLatGridControls.this.pmeta_.setInt("plot:xaxis.minordiv", ((SpinnerNumberModel)spinner.getModel()).getNumber().intValue());
                spinner.repaint();
            }
        });
        this.dfltXAxisCapButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanTimeLatGridControls.this.pmeta_.setBoolean("plot:xaxis.label.default", PanTimeLatGridControls.this.dfltXAxisCapButton_.isSelected());
            }
        });
        this.userXAxisCapButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanTimeLatGridControls.this.pmeta_.setBoolean("plot:xaxis.label.default", !PanTimeLatGridControls.this.userXAxisCapButton_.isSelected());
            }
        });
        this.xAxisCapTF_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanTimeLatGridControls.this.pmeta_.setString("plot:xaxis.label.usertext", PanTimeLatGridControls.this.xAxisCapTF_.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.xAxisCapTF_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanTimeLatGridControls.this.pmeta_.setString("plot:xaxis.label.usertext", PanTimeLatGridControls.this.xAxisCapTF_.getText());
            }
        });
        FocusListener latFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanTimeLatGridControls.this.handleLatExtrema(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener latAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanTimeLatGridControls.this.handleLatExtrema(e);
            }
        };
        this.maxLatTF_.addFocusListener(latFL);
        this.minLatTF_.addFocusListener(latFL);
        this.maxLatTF_.addActionListener(latAL);
        this.minLatTF_.addActionListener(latAL);
    }

    private void handleLatExtrema(EventObject e) {
        double max = 90.0;
        double min = 90.0;
        double oldmax = this.pmeta_.getDouble("plot:yaxis.max");
        double oldmin = this.pmeta_.getDouble("plot:yaxis.min");
        try {
            max = TextUtilities.parseDouble(this.maxLatTF_.getText());
        }
        catch (Exception exc) {
            this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            return;
        }
        try {
            min = TextUtilities.parseDouble(this.minLatTF_.getText());
        }
        catch (Exception exc) {
            this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            return;
        }
        if (max > 90.0) {
            max = 90.0;
            this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(90.0));
        }
        if (min < -90.0) {
            min = -90.0;
            this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(-90.0));
        }
        if (e.getSource() == this.maxLatTF_) {
            if (max <= min) {
                this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            } else {
                this.pmeta_.setDouble("plot:yaxis.max", max);
            }
        } else if (e.getSource() == this.minLatTF_) {
            if (min >= max) {
                this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            } else {
                this.pmeta_.setDouble("plot:yaxis.min", min);
            }
        }
    }
}

