/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcTimeAxis;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.time.NcDataTime;
import gov.nasa.giss.netcdf.time.NcJulianTime;
import gov.nasa.giss.netcdf.time.NcRelativeTime;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanTimeLatData
extends PanAbstractData2D {
    private static Logger logger_ = LoggerFactory.getLogger(PanTimeLatData.class);
    private static final PrintfFormat timeFormatter_ = new PrintfFormat("%G");

    public PanTimeLatData(NcArray2D nca2D, Dimension size) {
        this(nca2D, size.width, size.height);
    }

    public PanTimeLatData(NcArray2D nca2D, int gridWidth, int gridHeight) {
        super(nca2D, gridWidth, gridHeight);
        this.setLatRange(-90.0, 90.0);
    }

    @Override
    public String getXAxisName() {
        return "XXX";
    }

    @Override
    public String getXAxisUnits() {
        return null;
    }

    @Override
    public String getYAxisName() {
        return "Latitude";
    }

    @Override
    public String getYAxisUnits() {
        return "degree_north";
    }

    @Override
    public synchronized void addVariable(int vindex, NcArray nca) {
        if (this.ncArrays_[0] != null) {
            NcArray2D nca2D = (NcArray2D)nca;
            NcTimeAxis tAxis1 = (NcTimeAxis)((NcArray2D)this.ncArrays_[0]).getXAxis();
            NcTimeAxis tAxis2 = (NcTimeAxis)((NcArray2D)nca).getXAxis();
            if (tAxis1.isFormattedTime() && tAxis2.isFormattedTime()) {
                NcDataTime formatter1 = tAxis1.getFormatter();
                NcDataTime formatter2 = tAxis2.getFormatter();
                if (formatter1 instanceof NcRelativeTime && formatter2 instanceof NcRelativeTime) {
                    String pattern = ((NcRelativeTime)tAxis1.getFormatter()).getPattern();
                    ((NcRelativeTime)tAxis2.getFormatter()).applyPattern(pattern);
                } else if (formatter1 instanceof NcJulianTime && formatter2 instanceof NcJulianTime) {
                    String pattern = ((NcJulianTime)tAxis1.getFormatter()).getPattern();
                    ((NcJulianTime)tAxis2.getFormatter()).applyPattern(pattern);
                }
            }
        }
        super.addVariable(vindex, nca);
    }

    public void setTimePattern(String pattern) {
        for (NcArray nca : this.ncArrays_) {
            NcTimeAxis tAxis;
            if (nca == null || !(tAxis = (NcTimeAxis)((NcArray2D)nca).getXAxis()).isFormattedTime()) continue;
            NcDataTime formatter = tAxis.getFormatter();
            if (formatter instanceof NcRelativeTime) {
                ((NcRelativeTime)formatter).applyPattern(pattern);
                continue;
            }
            if (!(formatter instanceof NcJulianTime)) continue;
            ((NcJulianTime)formatter).applyPattern(pattern);
        }
    }

    public boolean setLatRange(double south, double north) {
        this.tBound_ = Math.min(90.0, north);
        this.bBound_ = Math.max(-90.0, south);
        this.setBoundsChanged();
        return true;
    }

    @Override
    protected void updateGrid() {
        NcAxis xAxis = this.getXAxis();
        this.lBound_ = -0.5;
        this.rBound_ = (double)xAxis.getSize() - 1.0 + 0.5;
    }

    @Override
    protected void regridNoInterpolate(NcArray nca, double[] target) {
        this.useGridder(nca, target, false);
    }

    @Override
    protected void regridInterpolate(NcArray nca, double[] target) {
        this.useGridder(nca, target, true);
    }

    private void useGridder(NcArray nca, double[] target, boolean interpolated) {
        NcGridder gridder = nca.getGridder();
        gridder.setSize(this.gridWidth_, this.gridHeight_);
        gridder.setBounds(this.lBound_, this.tBound_, this.rBound_, this.bBound_);
        if (interpolated) {
            gridder.regridInterpolate(nca, target);
        } else {
            gridder.regridNoInterpolate(nca, target);
        }
    }

    public Point2D.Double transformXY2GridCoords(double x, double y) {
        NcAxis xAxis = this.getXAxis();
        double lBoundVal2 = xAxis.boundsAt(0)[0];
        double rBoundVal2 = xAxis.boundsAt(xAxis.getSize() - 1)[1];
        double xper = (double)this.gridWidth_ / (rBoundVal2 - lBoundVal2);
        double yper = (double)this.gridHeight_ / (this.bBound_ - this.tBound_);
        double time = lBoundVal2 + x / xper;
        double lat = this.tBound_ + y / yper;
        return new Point2D.Double(time, lat);
    }

    public void describeData(StringBuilder sb, int x, int y) {
        NcAxis xAxis = this.getXAxis();
        double lBoundVal2 = xAxis.boundsAt(0)[0];
        double rBoundVal2 = xAxis.boundsAt(xAxis.getSize() - 1)[1];
        double xper = (double)this.gridWidth_ / (rBoundVal2 - lBoundVal2);
        double yper = (double)this.gridHeight_ / (this.bBound_ - this.tBound_);
        double lat = this.tBound_ + (double)y / yper;
        double time = lBoundVal2 + (double)x / xper;
        String timeUnits = this.getXAxis().getUnits();
        sb.append("Point: ");
        sb.append(timeFormatter_.sprintf(time));
        sb.append(", ");
        this.appendLat(sb, lat);
        sb.append("\n");
        for (int i = 0; i < 2; ++i) {
            if (this.ncArrays_[i] == null || i == 0 && this.combination_ == PanCombinationType.A2_ONLY || i == 1 && this.combination_ == PanCombinationType.A1_ONLY) continue;
            NcArray2D nca2D = (NcArray2D)this.ncArrays_[i];
            int row = nca2D.getYAxis().findNearestIndex(lat);
            int col = nca2D.getXAxis().findNearestIndex(time);
            sb.append("Array ").append(i + 1).append(": ");
            if (row < 0 || col < 0) {
                sb.append("Outside Array Bounds");
                continue;
            }
            sb.append("Cell [").append(col + 1).append(", ").append(row + 1).append("] at [t=");
            double cellTime = nca2D.getXAxis().valueAt(col);
            sb.append(timeFormatter_.sprintf(cellTime));
            sb.append(", ");
            this.appendLat(sb, nca2D.getYAxis().valueAt(row));
            sb.append("], value = ");
            double value = nca2D.valueAt(col, row);
            sb.append(timeFormatter_.sprintf(value));
            if (this.ncArrays_[i].getUnits() != null && !Double.isNaN(value)) {
                sb.append(" ").append(nca2D.getUnits());
            }
            sb.append("\n");
        }
    }

    private void appendLat(StringBuilder sb, double lat) {
        if (lat < 0.0) {
            sb.append(PanConstants.PFORMAT_D2.sprintf(-lat)).append("S");
        } else {
            sb.append(PanConstants.PFORMAT_D2.sprintf(lat)).append("N");
        }
    }
}

