/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.gui.NcTreeTablePanel;
import gov.nasa.giss.panoply.PanDatasetsPanelDropTargetAdapter;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.Panoply;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSourcesTreeTablePanel
extends NcTreeTablePanel {
    private static Logger logger_ = LoggerFactory.getLogger(PanSourcesTreeTablePanel.class);

    public PanSourcesTreeTablePanel() {
        PanPreferences prefs = PanPreferences.getPrefs();
        this.setBorder(PanGuiConstants.NO_BORDER);
        this.setOpaque(true);
        this.setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        this.setShowOnlyPlottables(prefs.getBoolean("sources:nodes.plottables"));
        try {
            this.getTreeTable().setLeafIcon(new ImageIcon(Panoply.class.getResource("resources/ttleaf.png")));
            this.getTreeTable().setClosedIcon(new ImageIcon(Panoply.class.getResource("resources/ttfolder.png")));
            this.getTreeTable().setOpenIcon(new ImageIcon(Panoply.class.getResource("resources/ttfolder.png")));
        }
        catch (Exception exc) {
            logger_.warn("Could not load tree table icon(s)");
        }
        PanDatasetsPanelDropTargetAdapter dta = new PanDatasetsPanelDropTargetAdapter(this);
        DropTarget dt = new DropTarget(this, dta);
        DropTarget dtt = new DropTarget(this.getTreeTable(), dta);
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            new DropTarget(c[i], dta);
        }
    }
}

