/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.BrushMetalToolBar;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.ToolbarButton;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotSize;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.actions.PanCombinePlotAction;
import gov.nasa.giss.panoply.actions.PanCreatePlotAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSourcesToolBar
extends BrushMetalToolBar {
    private static Logger logger_ = LoggerFactory.getLogger(PanSourcesToolBar.class);
    private ImageIcon createPlotIcon_;
    private ImageIcon combinePlotIcon_;
    private ImageIcon openDatasetIcon_;
    private ImageIcon removeOneIcon_;
    private ImageIcon removeAllIcon_;
    private ImageIcon hideInfoIcon_;
    private ImageIcon showInfoIcon_;
    private ToolbarButton createPlotButton_;
    private ToolbarButton combinePlotButton_;
    private ToolbarButton openDatasetButton_;
    private ToolbarButton removeOneButton_;
    private ToolbarButton removeAllButton_;
    private ToolbarButton toggleInfoButton_;
    private PanSourcesFrame parent_;

    public PanSourcesToolBar(PanSourcesFrame parent) {
        this.parent_ = parent;
        this.createPlotIcon_ = new ImageIcon(Panoply.class.getResource("resources/toolbar/createplot.png"));
        this.createPlotButton_ = new ToolbarButton(this.createPlotIcon_, PanProperties.SOURCES.getString("create-plot"), this.parent_.getAction("create-plot"), PanProperties.SOURCES.getString("create-plot-tip"));
        this.combinePlotIcon_ = new ImageIcon(Panoply.class.getResource("resources/toolbar/combineplot.png"));
        this.combinePlotButton_ = new ToolbarButton(this.combinePlotIcon_, PanProperties.SOURCES.getString("combine-plot"), this.parent_.getAction("combine-plot"), PanProperties.SOURCES.getString("combine-plot-tip"));
        this.openDatasetIcon_ = new ImageIcon(Panoply.class.getResource("resources/toolbar/opendataset.png"));
        this.openDatasetButton_ = new ToolbarButton(this.openDatasetIcon_, PanProperties.SOURCES.getString("open-catalog-dataset"), parent.getAction("open-catalog-dataset"), PanProperties.SOURCES.getString("open-dataset-tip"));
        this.removeOneIcon_ = new ImageIcon(Panoply.class.getResource("resources/toolbar/clear.png"));
        this.removeOneButton_ = new ToolbarButton(this.removeOneIcon_, PanProperties.SOURCES.getString("remove-one"), parent.getAction("remove-one"), PanProperties.SOURCES.getString("remove-one-tip"));
        this.removeAllIcon_ = new ImageIcon(Panoply.class.getResource("resources/toolbar/clearall.png"));
        this.removeAllButton_ = new ToolbarButton(this.removeAllIcon_, PanProperties.SOURCES.getString("remove-all"), parent.getAction("remove-all"), PanProperties.SOURCES.getString("remove-all-tip"));
        this.hideInfoIcon_ = new ImageIcon(Panoply.class.getResource("resources/toolbar/hideinfo.png"));
        this.showInfoIcon_ = new ImageIcon(Panoply.class.getResource("resources/toolbar/showinfo.png"));
        this.toggleInfoButton_ = new ToolbarButton(this.hideInfoIcon_, PanProperties.SOURCES.getString("toggle-info"), parent.getAction("toggle-info"), PanProperties.SOURCES.getString("toggle-info-tip"));
        Component gap1 = Box.createHorizontalStrut(20);
        Component gap2 = Box.createHorizontalStrut(20);
        Component gap3 = Box.createHorizontalGlue();
        this.add(this.createPlotButton_);
        this.add(gap1);
        this.add(this.combinePlotButton_);
        this.add(gap2);
        this.add(this.openDatasetButton_);
        this.add(gap3);
        this.add(this.removeOneButton_);
        this.add(this.removeAllButton_);
        this.add(this.toggleInfoButton_);
        this.refresh();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 2000;
        return d;
    }

    public void refresh() {
        if (GuiUtilities.getParentFrame(this) == null) {
            return;
        }
        PanPreferences prefs = PanPreferences.getPrefs();
        if (prefs.getBoolean("sources:toolbar.labels")) {
            this.createPlotButton_.setText(PanProperties.SOURCES.getString("create-plot"));
            this.combinePlotButton_.setText(PanProperties.SOURCES.getString("combine-plot"));
            this.openDatasetButton_.setText(PanProperties.SOURCES.getString("open-catalog-dataset"));
            this.removeOneButton_.setText(PanProperties.SOURCES.getString("remove-one"));
            this.removeAllButton_.setText(PanProperties.SOURCES.getString("remove-all"));
            if (this.toggleInfoButton_ != null) {
                if (prefs.getBoolean("sources:info.visible")) {
                    this.toggleInfoButton_.setText(PanProperties.SOURCES.getString("hide-info"));
                } else {
                    this.toggleInfoButton_.setText(PanProperties.SOURCES.getString("show-info"));
                }
            }
        } else {
            this.openDatasetButton_.setText(null);
            this.createPlotButton_.setText(null);
            this.combinePlotButton_.setText(null);
            this.removeOneButton_.setText(null);
            this.removeAllButton_.setText(null);
            if (this.toggleInfoButton_ != null) {
                this.toggleInfoButton_.setText(null);
            }
        }
        if (this.toggleInfoButton_ != null) {
            if (prefs.getBoolean("sources:info.visible")) {
                this.toggleInfoButton_.setIcon(this.hideInfoIcon_);
            } else {
                this.toggleInfoButton_.setIcon(this.showInfoIcon_);
            }
        }
        this.refreshCreatePlotButton();
        this.refreshCombinePlotButton();
    }

    private void refreshCreatePlotButton() {
        final PanCreatePlotAction a = (PanCreatePlotAction)this.parent_.getAction("create-plot");
        this.createPlotButton_.setEnabled(a.isEnabled());
        if (!this.createPlotButton_.isEnabled()) {
            return;
        }
        JPopupMenu popup = this.createPlotButton_.getComponentPopupMenu();
        if (popup != null) {
            return;
        }
        popup = new JPopupMenu("Create Plot");
        this.createPlotButton_.setComponentPopupMenu(popup);
        popup.add(a);
        popup.addSeparator();
        AbstractAction xsmallAction = new AbstractAction(PanProperties.SOURCES.getString("popup-xsmall-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.XSMALL);
            }
        };
        popup.add(xsmallAction);
        AbstractAction smallAction = new AbstractAction(PanProperties.SOURCES.getString("popup-small-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SMALL);
            }
        };
        popup.add(smallAction);
        AbstractAction standardAction = new AbstractAction(PanProperties.SOURCES.getString("popup-standard-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.STANDARD);
            }
        };
        popup.add(standardAction);
        AbstractAction largeAction = new AbstractAction(PanProperties.SOURCES.getString("popup-large-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.LARGE);
            }
        };
        popup.add(largeAction);
        AbstractAction xlargeAction = new AbstractAction(PanProperties.SOURCES.getString("popup-xlarge-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.XLARGE);
            }
        };
        popup.add(xlargeAction);
        AbstractAction jumboAction = new AbstractAction(PanProperties.SOURCES.getString("popup-jumbo-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.JUMBO);
            }
        };
        popup.add(jumboAction);
        AbstractAction xjumboAction = new AbstractAction(PanProperties.SOURCES.getString("popup-xjumbo-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.XJUMBO);
            }
        };
        popup.add(xjumboAction);
        standardAction.setEnabled(PanPlotSize.STANDARD.fitsDisplay());
        largeAction.setEnabled(PanPlotSize.LARGE.fitsDisplay());
        xlargeAction.setEnabled(PanPlotSize.XLARGE.fitsDisplay());
        jumboAction.setEnabled(PanPlotSize.JUMBO.fitsDisplay());
        xjumboAction.setEnabled(PanPlotSize.XJUMBO.fitsDisplay());
    }

    private void refreshCombinePlotButton() {
        final PanCombinePlotAction a = (PanCombinePlotAction)this.parent_.getAction("combine-plot");
        this.combinePlotButton_.setEnabled(a.isEnabled());
        if (!this.combinePlotButton_.isEnabled()) {
            return;
        }
        JPopupMenu popup = this.combinePlotButton_.getComponentPopupMenu();
        if (popup == null) {
            popup = new JPopupMenu("Combine Plot");
            this.combinePlotButton_.setComponentPopupMenu(popup);
        }
        popup.removeAll();
        final PanPlotFrame[] plotFrames = PanPlotFrame.getListOfFrames();
        int isize = plotFrames.length;
        for (int i = 0; i < isize; ++i) {
            final int ii = i;
            AbstractAction action = new AbstractAction("Combine in " + plotFrames[i].getTitle()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    a.addToExistingPlot(plotFrames[ii].getTitle());
                }
            };
            popup.add(action);
        }
    }
}

