/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.event.TreeTableEvent;
import gov.nasa.giss.gui.event.TreeTableListener;
import gov.nasa.giss.gui.plaf.BlackSplitPaneUI;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.gui.treetable.TreeTablePanel;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.PanSourcesSubpanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public abstract class PanSourcesSplitSubpanel
extends JPanel
implements PropertyChangeListener,
PanSourcesSubpanel,
TreeTableListener {
    protected PanSourcesFrame parent_;
    protected TreeTablePanel ttPanel_;
    private JComponent treeBox_;
    private JComponent infoBox_;
    protected JEditorPane infoPane_;
    private JSplitPane splitPane_;
    private static int dividerLocation_;
    private static boolean ignorePCEvent_;

    public PanSourcesSplitSubpanel(PanSourcesFrame parent) {
        this.parent_ = parent;
        this.setLayout(new BorderLayout());
        this.setBorder(PanGuiConstants.NO_BORDER);
        this.setOpaque(false);
        this.splitPane_ = new JSplitPane(1, true);
        this.splitPane_.setUI(new BlackSplitPaneUI());
        this.splitPane_.setDividerLocation(0.67);
        this.splitPane_.setDividerSize(2);
        this.splitPane_.setBorder(PanGuiConstants.NO_BORDER);
        this.splitPane_.setResizeWeight(0.5);
        this.splitPane_.setOpaque(false);
        this.splitPane_.addPropertyChangeListener(this);
        this.setMinimumSize(new Dimension(540, 300));
        this.setPreferredSize(this.getMinimumSize());
        this.treeBox_ = this.makeTreeBox();
        this.infoBox_ = this.makeInfoBox();
        this.treeBox_.setMinimumSize(new Dimension(135, 300));
        this.infoBox_.setMinimumSize(new Dimension(135, 300));
    }

    protected abstract JComponent makeTreeBox();

    private JComponent makeInfoBox() {
        this.infoPane_ = new JEditorPane("text/plain", "");
        this.infoPane_.setFont(new Font("Monospaced", 0, 12));
        this.infoPane_.setEditable(false);
        this.infoPane_.setBorder(PanGuiConstants.NO_BORDER);
        JScrollPane infoSPane = new JScrollPane(this.infoPane_);
        infoSPane.setHorizontalScrollBarPolicy(30);
        infoSPane.setVerticalScrollBarPolicy(22);
        infoSPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        return infoSPane;
    }

    @Override
    public TreeTableNode getSelectedNode() {
        return this.ttPanel_.getTreeTable().getSelectedNode();
    }

    @Override
    public void remakeLayout() {
        if (PanPreferences.getPrefs().getBoolean("sources:info.visible")) {
            if (this.isAncestorOf(this.treeBox_) && this.treeBox_.getParent() == this) {
                this.remove(this.treeBox_);
            }
            if (!this.isAncestorOf(this.splitPane_)) {
                this.splitPane_.setLeftComponent(this.treeBox_);
                this.splitPane_.setRightComponent(this.infoBox_);
                if (dividerLocation_ < 1) {
                    this.splitPane_.setDividerLocation(0.67);
                } else if (dividerLocation_ < this.getWidth() - 20) {
                    this.splitPane_.setDividerLocation(dividerLocation_);
                }
                this.add((Component)this.splitPane_, "Center");
                dividerLocation_ = this.splitPane_.getDividerLocation();
            }
            if (this.splitPane_.getDividerLocation() != dividerLocation_) {
                this.splitPane_.setDividerLocation(dividerLocation_);
            }
        } else {
            if (this.isAncestorOf(this.splitPane_)) {
                dividerLocation_ = this.splitPane_.getDividerLocation();
                ignorePCEvent_ = true;
                this.remove(this.splitPane_);
                ignorePCEvent_ = false;
            }
            if (this.treeBox_.getParent() == this.splitPane_) {
                this.splitPane_.remove(this.treeBox_);
            }
            this.add((Component)this.treeBox_, "Center");
        }
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (ignorePCEvent_) {
            return;
        }
        String pname = e.getPropertyName();
        if (!pname.equals("dividerLocation")) {
            return;
        }
        if (this.isAncestorOf(this.splitPane_) && pname.equals("dividerLocation")) {
            int newLocation = this.splitPane_.getDividerLocation();
            int panelWidth = this.splitPane_.getWidth();
            if (newLocation > 0 && newLocation < panelWidth) {
                dividerLocation_ = newLocation;
            }
        }
    }

    @Override
    public void itemRemoved(TreeTableEvent e) {
        this.refreshActions();
        this.repaint();
    }
}

