/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.StatusBar;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalogNode;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.panoply.PanBookmarksNode;
import gov.nasa.giss.panoply.PanBookmarksTreeTablePanel;
import gov.nasa.giss.panoply.PanCatalogsPanel;
import gov.nasa.giss.panoply.PanDatasetsPanel;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesSubpanel;
import gov.nasa.giss.panoply.PanSourcesTabbedPane;
import gov.nasa.giss.panoply.PanSourcesToolBar;
import gov.nasa.giss.panoply.actions.PanAddBookmarkAction;
import gov.nasa.giss.panoply.actions.PanCombinePlotAction;
import gov.nasa.giss.panoply.actions.PanCreatePlotAction;
import gov.nasa.giss.panoply.actions.PanDnvToggleVariablesAction;
import gov.nasa.giss.panoply.actions.PanExportCdlAction;
import gov.nasa.giss.panoply.actions.PanExportCsvAction;
import gov.nasa.giss.panoply.actions.PanExportTextAction;
import gov.nasa.giss.panoply.actions.PanOpenCatalogDatasetAction;
import gov.nasa.giss.panoply.actions.PanRemoveAllSourcesAction;
import gov.nasa.giss.panoply.actions.PanRemoveOneSourceAction;
import gov.nasa.giss.panoply.actions.PanToggleInfoAction;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSourcesFrame
extends PanFrame {
    private static Logger logger_ = LoggerFactory.getLogger(PanSourcesFrame.class);
    private static PanSourcesFrame frame_;
    private PanMenuBar mbar_;
    private Hashtable<String, Action> actionHash_;
    private JPanel bigBox_;
    private PanSourcesToolBar toolbar_;
    private PanSourcesTabbedPane fTabbedPane_;
    private PanDatasetsPanel datasetsPanel_;
    private PanCatalogsPanel catalogsPanel_;
    private PanBookmarksTreeTablePanel bookmarksPanel_;
    protected int minWidth_;
    protected int minHeight_;

    public static synchronized PanSourcesFrame findFrame(boolean create) {
        if (frame_ == null && create) {
            frame_ = new PanSourcesFrame();
        }
        return frame_;
    }

    private PanSourcesFrame() {
        this.setTitle(PanProperties.SOURCES.getString("frame-title"));
        this.setName(PanProperties.SOURCES.getString("frame-title"));
        this.setResizable(true);
        GuiUtilities.applyBrushMetalLook(this);
        this.mbar_ = new PanMenuBar(this);
        this.setPanMenuBar(this.mbar_);
        this.actionHash_ = new Hashtable(30);
        this.actionHash_.put("open-catalog-dataset", new PanOpenCatalogDatasetAction(this));
        this.actionHash_.put("create-plot", new PanCreatePlotAction(this));
        this.actionHash_.put("combine-plot", new PanCombinePlotAction(this));
        this.actionHash_.put("export-cdl", new PanExportCdlAction(this));
        this.actionHash_.put("export-csv", new PanExportCsvAction(this));
        this.actionHash_.put("export-text", new PanExportTextAction(this));
        this.actionHash_.put("add-bookmark", new PanAddBookmarkAction(this));
        this.actionHash_.put("remove-one", new PanRemoveOneSourceAction(this));
        this.actionHash_.put("remove-all", new PanRemoveAllSourcesAction(this));
        this.actionHash_.put("toggle-info", new PanToggleInfoAction(this));
        this.actionHash_.put("toggle-plottables", new PanDnvToggleVariablesAction(this));
        this.mbar_.getItemByName("export-menu", "export-cdl").setAction(this.actionHash_.get("export-cdl"));
        this.mbar_.getItemByName("export-menu", "export-csv").setAction(this.actionHash_.get("export-csv"));
        this.mbar_.getItemByName("export-menu", "export-text").setAction(this.actionHash_.get("export-text"));
        this.mbar_.getItemByName("edit-menu", "clear").setAction(this.actionHash_.get("remove-one"));
        this.mbar_.getItemByName("edit-menu", "clear").setText(PanProperties.SOURCES.getString("remove-one"));
        this.mbar_.getItemByName("view-menu", "toggle-plottables").setAction(this.actionHash_.get("toggle-plottables"));
        this.mbar_.getItemByName("bookmarks-menu", "add-bookmark").setAction(this.actionHash_.get("add-bookmark"));
        this.mbar_.getItemByName("plot-menu", "create-plot").setAction(this.actionHash_.get("create-plot"));
        this.toolbar_ = new PanSourcesToolBar(this);
        this.toolbar_.setShowBottomEdge(false);
        this.datasetsPanel_ = new PanDatasetsPanel(this);
        this.catalogsPanel_ = new PanCatalogsPanel(this);
        this.bookmarksPanel_ = new PanBookmarksTreeTablePanel(this);
        this.fTabbedPane_ = new PanSourcesTabbedPane();
        this.fTabbedPane_.addTab(PanProperties.SOURCES.getString("datasets-tab-label"), this.datasetsPanel_);
        this.fTabbedPane_.addTab(PanProperties.SOURCES.getString("catalogs-tab-label"), this.catalogsPanel_);
        this.fTabbedPane_.addTab(PanProperties.SOURCES.getString("bookmarks-tab-label"), this.bookmarksPanel_);
        StatusBar statusBar = this.createStatusBar();
        this.bigBox_ = new JPanel();
        this.bigBox_.setLayout(new BoxLayout(this.bigBox_, 1));
        this.bigBox_.setBorder(PanGuiConstants.NO_BORDER);
        this.bigBox_.add(this.toolbar_);
        this.bigBox_.add(this.fTabbedPane_);
        this.bigBox_.add(statusBar);
        Dimension d1 = this.toolbar_.getMinimumSize();
        Dimension d2 = this.fTabbedPane_.getMinimumSize();
        Dimension d3 = ((JComponent)statusBar).getMinimumSize();
        int minw = Math.max(d1.width, d2.width);
        int minh = d1.height + d2.height + d3.height;
        PanPreferences prefs = PanPreferences.getPrefs();
        int startw = Math.max(minw, prefs.getInt("sources:bounds.width"));
        int starth = Math.max(minh, prefs.getInt("sources:bounds.height"));
        this.bigBox_.setMinimumSize(new Dimension(minw, minh));
        this.bigBox_.setPreferredSize(new Dimension(startw, starth));
        this.bigBox_.setMaximumSize(new Dimension(9999, 9999));
        this.getContentPane().add(this.bigBox_);
        this.pack();
        this.minWidth_ = Math.max(800, minw + (this.getWidth() - startw));
        this.minHeight_ = Math.max(400, minh + (this.getHeight() - starth));
        this.setMinimumSize(new Dimension(this.minWidth_, this.minHeight_));
        try {
            int whereX = Math.max(0, prefs.getInt("sources:bounds.left"));
            int whereY = Math.max(0, prefs.getInt("sources:bounds.top"));
            this.setLocation(new Point(whereX, whereY));
        }
        catch (Exception exc) {
            this.setLocation(new Point(50, 50));
        }
        this.refresh();
        this.addListeners();
    }

    private void addListeners() {
        final PanPreferences prefs = PanPreferences.getPrefs();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                PanSourcesFrame.this.datasetsPanel_.clearPopup();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                PanSourcesFrame.this.datasetsPanel_.clearPopup();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (!PanSourcesFrame.this.isVisible()) {
                    return;
                }
                Point p = PanSourcesFrame.this.getLocationOnScreen();
                prefs.setInt("sources:bounds.left", p.x);
                prefs.setInt("sources:bounds.top", p.y);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                prefs.setInt("sources:bounds.width", PanSourcesFrame.this.bigBox_.getWidth());
                prefs.setInt("sources:bounds.height", PanSourcesFrame.this.bigBox_.getHeight());
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                PanSourcesFrame.this.datasetsPanel_.clearPopup();
            }
        });
    }

    public PanDatasetsPanel getDatasetsSubpanel() {
        return this.datasetsPanel_;
    }

    public PanSourcesSubpanel getSubpanel(Subpanel panelID) {
        switch (panelID) {
            case DATASETS: {
                return this.datasetsPanel_;
            }
            case CATALOGS: {
                return this.catalogsPanel_;
            }
            case BOOKMARKS: {
                return this.bookmarksPanel_;
            }
        }
        return null;
    }

    public void showSubpanel(final Subpanel panelID) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (panelID) {
                    case DATASETS: {
                        PanSourcesFrame.this.fTabbedPane_.setSelectedComponent(PanSourcesFrame.this.datasetsPanel_);
                        break;
                    }
                    case CATALOGS: {
                        PanSourcesFrame.this.fTabbedPane_.setSelectedComponent(PanSourcesFrame.this.catalogsPanel_);
                        break;
                    }
                    case BOOKMARKS: {
                        PanSourcesFrame.this.fTabbedPane_.setSelectedComponent(PanSourcesFrame.this.bookmarksPanel_);
                    }
                }
            }
        });
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        this.showSubpanel(Subpanel.DATASETS);
        return this.datasetsPanel_.addDataset(ncd);
    }

    public synchronized NcCatalogNode addCatalog(URL url) throws IOException, URISyntaxException {
        this.showSubpanel(Subpanel.CATALOGS);
        return this.catalogsPanel_.addCatalog(url);
    }

    public PanBookmarksNode addBookmarksNode(PanBookmarksNode node) {
        if (node == null) {
            return null;
        }
        return this.bookmarksPanel_.addNode(node);
    }

    public void clear() {
        this.fTabbedPane_.getVisibleSubpanel().clear();
    }

    public TreeTableNode getSelectedNode() {
        return this.fTabbedPane_.getVisibleSubpanel().getSelectedNode();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.refresh();
        }
        super.setVisible(visible);
    }

    @Override
    public synchronized void refresh() {
        super.refresh();
        this.fTabbedPane_.getVisibleSubpanel().refreshActions();
        this.toolbar_.refresh();
        int ph = this.toolbar_.getPreferredSize().height;
        this.toolbar_.setMinimumSize(new Dimension(540, ph));
        this.toolbar_.setMaximumSize(new Dimension(9999, ph));
        if (this.getSize() != null) {
            this.toolbar_.setSize(new Dimension(this.getWidth(), ph));
        }
        this.bigBox_.validate();
    }

    public synchronized void remakeLayout() {
        this.fTabbedPane_.getVisibleSubpanel().remakeLayout();
        this.bigBox_.validate();
    }

    public Action getAction(String name) {
        return this.actionHash_.get(name);
    }

    public void disableActions() {
        Collection<Action> actions = this.actionHash_.values();
        for (Action a : actions) {
            a.setEnabled(false);
        }
        this.toolbar_.refresh();
    }

    public void enableAction(String name, boolean enabled) {
        this.actionHash_.get(name).setEnabled(enabled);
        this.toolbar_.refresh();
    }

    public static enum Subpanel {
        DATASETS,
        CATALOGS,
        BOOKMARKS;

    }
}

