/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.panoply.PanPanel;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class PanSlicer
extends PanPanel {
    private EventListenerList listenerList_ = new EventListenerList();
    private NcDimension ncdim_;
    private JComboBox menu_;
    private JSpinner spinner_;
    private JCheckBox averageCB_;
    private SpinnerNumberModel smodel_;

    public PanSlicer(NcDimension ncdim) {
        this(ncdim, false);
    }

    public PanSlicer(NcDimension ncdim, boolean appendAvg) {
        JLabel ulabel;
        if (ncdim == null) {
            throw new IllegalArgumentException("Dimension is null");
        }
        this.ncdim_ = ncdim;
        this.setLayout(new BoxLayout(this, 0));
        String lname = this.getLongName();
        if (lname.indexOf(" (") > -1) {
            lname = lname.substring(0, lname.indexOf(" ("));
        }
        int isize = ncdim.getLength();
        JLabel slabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, lname + ": ");
        this.smodel_ = new SpinnerNumberModel(1, 1, isize, 1);
        this.spinner_ = PanWidgetUtils.getSpinner(PanWidgetUtils.Size.SMALL, null, this.smodel_);
        JLabel clabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, " of " + isize + " = ");
        this.menu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, null, ncdim.hasBounds() ? ncdim.getFormattedBounds() : ncdim.getFormattedValues());
        this.menu_.setMaximumRowCount(24);
        JLabel jLabel = ulabel = this.getUnits() != null ? PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, " " + this.getUnits()) : null;
        if (appendAvg) {
            this.averageCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, null, "Avg");
        }
        this.add(slabel);
        this.add(this.spinner_);
        this.add(clabel);
        this.add(this.menu_);
        if (ulabel != null) {
            this.add(ulabel);
        }
        if (this.averageCB_ != null) {
            this.add(PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "  \u2014  "));
            this.add(this.averageCB_);
        }
        this.add(Box.createHorizontalGlue());
        GuiUtilities.setSizeSmall(this);
        if (slabel.getPreferredSize().width > 50) {
            slabel.setMinimumSize(new Dimension(50, slabel.getPreferredSize().height));
        }
        this.spinner_.setMinimumSize(this.spinner_.getPreferredSize());
        clabel.setMinimumSize(clabel.getPreferredSize());
        if (this.menu_.getPreferredSize().width > 50) {
            this.menu_.setMinimumSize(new Dimension(50, this.menu_.getPreferredSize().height));
        }
        if (ulabel != null && this.menu_.getPreferredSize().width > 20) {
            ulabel.setMinimumSize(new Dimension(20, slabel.getPreferredSize().height));
        }
        this.addListeners();
    }

    private void addListeners() {
        this.spinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int ival = ((SpinnerNumberModel)PanSlicer.this.spinner_.getModel()).getNumber().intValue();
                PanSlicer.this.menu_.setSelectedIndex(ival - 1);
                PanSlicer.this.fireAction();
                PanSlicer.this.spinner_.repaint();
            }
        });
        this.menu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanSlicer.this.spinner_.setValue(new Integer(PanSlicer.this.menu_.getSelectedIndex() + 1));
            }
        });
        if (this.averageCB_ != null) {
            this.averageCB_.setSelected(true);
            this.spinner_.setEnabled(false);
            this.menu_.setEnabled(false);
            this.averageCB_.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean b = e.getStateChange() == 1;
                    PanSlicer.this.spinner_.setEnabled(!b);
                    PanSlicer.this.menu_.setEnabled(!b);
                    PanSlicer.this.fireAction();
                }
            });
        }
    }

    public String getLongName() {
        return this.ncdim_.getLongName();
    }

    public String getUnits() {
        return this.ncdim_.getUnits();
    }

    public int getItemCount() {
        return this.ncdim_.getLength();
    }

    public int getSelectedIndex() {
        if (this.menu_ == null) {
            return 0;
        }
        if (this.averageCB_ != null && this.averageCB_.isSelected()) {
            return -1;
        }
        return this.menu_.getSelectedIndex();
    }

    public Object getSelectedItem() {
        if (this.menu_ == null) {
            return this.ncdim_.getValues()[0];
        }
        if (this.averageCB_ != null && this.averageCB_.isSelected()) {
            return "Average of all indices in dimension";
        }
        return this.menu_.getSelectedItem();
    }

    public synchronized ActionListener[] getActionListeners() {
        ActionListener[] listeners = (ActionListener[])this.listenerList_.getListeners(ActionListener.class);
        return listeners;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList_.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList_.remove(ActionListener.class, l);
    }

    public void fireAction() {
        ActionEvent e = new ActionEvent(this, 0, null);
        ActionListener[] listeners = (ActionListener[])this.listenerList_.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].actionPerformed(e);
        }
    }
}

