/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import java.io.File;
import java.io.FilenameFilter;

public class PanSettingsFilenameFilter
implements FilenameFilter {
    public static final String EXT = "panset";

    @Override
    public boolean accept(File dir, String name) {
        if (PanSettingsFilenameFilter.isSettingsName(name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean isSettingsName(File f) {
        if (f == null) {
            throw new IllegalArgumentException("File is null.");
        }
        return PanSettingsFilenameFilter.isSettingsName(f.getName());
    }

    public static boolean isSettingsName(String fname) {
        if (fname == null) {
            throw new IllegalArgumentException("File name is null.");
        }
        String lcname = fname.toLowerCase();
        return lcname.endsWith(EXT);
    }
}

