/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanProtocol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanServer {
    private static Logger logger_ = LoggerFactory.getLogger(PanServer.class);
    private ServerSocket serverSocket_ = new ServerSocket(2880);
    private boolean listening_ = true;

    public PanServer() throws IOException {
        new Thread("client listener"){

            @Override
            public void run() {
                while (PanServer.this.listening_) {
                    try {
                        1.sleep(400L);
                        PanServer.this.listenForClient();
                    }
                    catch (Exception exc) {
                        if (!PanServer.this.listening_) continue;
                        logger_.error("Client socket error.");
                        exc.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void listenForClient() throws IOException {
        String input;
        Socket client = this.serverSocket_.accept();
        PrintWriter out = new PrintWriter(client.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
        PanProtocol prot = new PanProtocol();
        String output = prot.processInput(null);
        out.println(output);
        while ((input = in.readLine()) != null) {
            output = prot.processInput(input);
            out.println(output);
            if (!input.equalsIgnoreCase("bye.") && !output.equalsIgnoreCase("bye.")) continue;
        }
        out.close();
        in.close();
        client.close();
    }

    public void close() throws IOException {
        this.listening_ = false;
        this.serverSocket_.close();
    }
}

