/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanColorTableBrowser;
import gov.nasa.giss.panoply.PanColorTableMenu;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanNumberFormatMenu;
import gov.nasa.giss.panoply.PanScaleCaptionLocation;
import gov.nasa.giss.panoply.PanScaleOutlier;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanScalePrefsPanel
extends PanAbstractPrefsPanel {
    private JCheckBox autoFitCB_;
    private PanColorTableMenu ctableMenu_;
    private JCheckBox invertedCB_;
    private JCheckBox log10CB_;
    private JCheckBox minmaxCB_;
    private ColorMenu invalidsMenu_;
    private PanEnumMenu outlierMenu_;
    private PanNumberFormatMenu tickFormatMenu_;
    private JSpinner majorDivSpinner_;
    private JSpinner minorDivSpinner_;
    private JComboBox tickSizeMenu_;
    private PanEnumMenu scaleCapPlaceMenu_;

    public PanScalePrefsPanel() {
        JLabel topText = new JLabel("When creating a new plot, set\u2026", 0);
        topText.setAlignmentX(0.5f);
        this.autoFitCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Always fit to data range");
        this.minmaxCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Show min-max footnote");
        this.log10CB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Logarithmic scale");
        this.ctableMenu_ = PanWidgetUtils.getColorTableMenu(PanWidgetUtils.Size.NORMAL, null, true);
        this.ctableMenu_.setToolTipText("Select a default color table to apply to new plot");
        this.invertedCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Invert color table");
        this.invalidsMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.GRAYSCALE);
        this.outlierMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.NORMAL, null, PanScaleOutlier.class);
        this.tickFormatMenu_ = PanWidgetUtils.getNumberFormatMenu(PanWidgetUtils.Size.NORMAL, null);
        this.majorDivSpinner_ = new JSpinner(new SpinnerNumberModel(2, 2, 20, 1));
        this.minorDivSpinner_ = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.tickSizeMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.NORMAL, null, new Object[]{new Integer("9"), new Integer("10"), new Integer("11"), new Integer("12"), new Integer("13"), new Integer("14")});
        this.scaleCapPlaceMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.NORMAL, null, PanScaleCaptionLocation.class);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 13, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRowWeight(11, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)new JLabel("Min/Max: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)this.autoFitCB_, new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)this.minmaxCB_, new FGConstraint(1, ++row, 0.0, 0.5));
        this.add((Component)this.log10CB_, new FGConstraint(1, ++row, 0.0, 0.5));
        this.add((Component)new JLabel("Color Table: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)this.ctableMenu_, new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)this.invertedCB_, new FGConstraint(1, ++row, 0.0, 0.5));
        this.add((Component)new JLabel("Fill Color: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.invalidsMenu_), new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)new JLabel("Outlier Shape: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)this.outlierMenu_, new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)new JLabel("Divisions: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Major: "), this.majorDivSpinner_, new JLabel(", Minor: "), this.minorDivSpinner_), new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)new JLabel("Tick Label: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Format: "), this.tickFormatMenu_, new JLabel(", Size: "), this.tickSizeMenu_), new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)new JLabel("Caption Location: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)this.scaleCapPlaceMenu_, new FGConstraint(1, row, 0.0, 0.5));
        this.add(Box.createVerticalGlue(), new Point(0, ++row));
        this.refresh();
        this.outlierMenu_.setMaximumSize(this.outlierMenu_.getPreferredSize());
        this.tickFormatMenu_.setMaximumSize(this.tickFormatMenu_.getPreferredSize());
        this.majorDivSpinner_.setMaximumSize(this.majorDivSpinner_.getPreferredSize());
        this.minorDivSpinner_.setMaximumSize(this.minorDivSpinner_.getPreferredSize());
        this.ctableMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:colorbar.name", (AbstractColorTable)PanScalePrefsPanel.this.ctableMenu_.getSelectedItem());
            }
        });
        this.invertedCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:colorbar.invert", PanScalePrefsPanel.this.invertedCB_.isSelected());
            }
        });
        this.log10CB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:scale.log10", PanScalePrefsPanel.this.log10CB_.isSelected());
            }
        });
        this.invalidsMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:colors.invalids", PanScalePrefsPanel.this.invalidsMenu_.getSelectedColor());
            }
        });
        this.outlierMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanColorTableBrowser ctb;
                if (e.getStateChange() != 1) {
                    return;
                }
                if (!PanScalePrefsPanel.this.refreshing_) {
                    PanAbstractPrefsPanel.PREFS.set("plot:scale.outlier", ((PanMenuItemEnum)PanScalePrefsPanel.this.outlierMenu_.getSelectedItem()).getValue());
                }
                if ((ctb = PanColorTableBrowser.findFrame(false)) != null) {
                    ctb.refresh();
                }
            }
        });
        this.autoFitCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:scale.autofit", PanScalePrefsPanel.this.autoFitCB_.isSelected());
            }
        });
        this.minmaxCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:scale.minmaxnote", PanScalePrefsPanel.this.minmaxCB_.isSelected());
            }
        });
        this.majorDivSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!PanScalePrefsPanel.this.refreshing_) {
                    PanAbstractPrefsPanel.PREFS.setInt("plot:scale.majordiv", (Integer)PanScalePrefsPanel.this.majorDivSpinner_.getValue());
                }
                PanScalePrefsPanel.this.majorDivSpinner_.repaint();
            }
        });
        this.minorDivSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!PanScalePrefsPanel.this.refreshing_) {
                    PanAbstractPrefsPanel.PREFS.setInt("plot:scale.minordiv", (Integer)PanScalePrefsPanel.this.minorDivSpinner_.getValue());
                }
                PanScalePrefsPanel.this.minorDivSpinner_.repaint();
            }
        });
        this.tickFormatMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:scale.tick.format", PanScalePrefsPanel.this.tickFormatMenu_.getSelectedItem().toString());
            }
        });
        this.tickSizeMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                int value = (Integer)PanScalePrefsPanel.this.tickSizeMenu_.getSelectedItem();
                PanAbstractPrefsPanel.PREFS.setInt("plot:scale.tick.size", value);
            }
        });
        this.scaleCapPlaceMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanScalePrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:scale.caption.location", ((PanMenuItemEnum)PanScalePrefsPanel.this.scaleCapPlaceMenu_.getSelectedItem()).getValue());
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.autoFitCB_.setSelected(PREFS.getBoolean("plot:scale.autofit"));
        this.minmaxCB_.setSelected(PREFS.getBoolean("plot:scale.minmaxnote"));
        this.ctableMenu_.setSelectedItem(PREFS.get("plot:colorbar.name"));
        this.invertedCB_.setSelected(PREFS.getBoolean("plot:colorbar.invert"));
        this.log10CB_.setSelected(PREFS.getBoolean("plot:scale.log10"));
        this.outlierMenu_.setSelectedItem(PREFS.getString("plot:scale.outlier"));
        this.invalidsMenu_.setSelectedColor(PREFS.getColor("plot:colors.invalids"));
        this.tickFormatMenu_.setSelectedItem(PREFS.getString("plot:scale.tick.format"));
        this.tickSizeMenu_.setSelectedItem(PREFS.getInt("plot:scale.tick.size"));
        this.scaleCapPlaceMenu_.setSelectedItem(PREFS.getString("plot:scale.caption.location"));
        this.majorDivSpinner_.setValue(new Integer(PREFS.getInt("plot:scale.majordiv")));
        this.minorDivSpinner_.setValue(new Integer(PREFS.getInt("plot:scale.minordiv")));
        this.refreshing_ = false;
    }
}

