/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.data.DataEvent;
import gov.nasa.giss.data.DataListener;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.menu.GissMenu;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanColorTableMenu;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanNumberFormatMenu;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanScaleCaptionLocation;
import gov.nasa.giss.panoply.PanScaleOutlier;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.plot.PlotPropertyEvent;
import gov.nasa.giss.plot.PlotPropertyListener;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanScaleControls
extends PanAbstractControlsPanel
implements DataListener,
PlotPropertyListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanScaleControls.class);
    private static final Object[] TICK_SIZE_CHOICES = new Object[]{new Integer("9"), new Integer("10"), new Integer("11"), new Integer("12"), new Integer("13"), new Integer("14")};
    private JTextField minimumTF_;
    private JTextField maximumTF_;
    private PanColorTableMenu ctableMenu_;
    private JCheckBox invertedCB_;
    private JCheckBox autoFitCB_;
    private JCheckBox log10CB_;
    private JButton fitToDataButton_;
    private JButton zeroScaleButton_;
    private ColorMenu iColorMenu_;
    private PanEnumMenu outlierMenu_;
    private JRadioButton dfltScaleCapButton_;
    private JRadioButton userScaleCapButton_;
    private JTextField scaleCapTF_;
    private PanEnumMenu scaleCapPlaceMenu_;
    private JSpinner scalingSpinner_;
    private JComboBox unitsMenu_;
    private JSpinner majorDivSpinner_;
    private JSpinner minorDivSpinner_;
    private PanNumberFormatMenu tickFormatMenu_;
    private JComboBox tickSizeMenu_;
    private Action autoFitScaleAction_;
    private Action fitScaleAction_;
    private Action zeroScaleAction_;
    private Action invertScaleAction_;
    private Action logarithmicAction_;

    public PanScaleControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("scale-controls", pmeta);
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        this.autoFitScaleAction_ = new AutoscaleAction();
        this.fitScaleAction_ = new FitScaleAction();
        this.zeroScaleAction_ = new ZeroScaleAction();
        this.invertScaleAction_ = new InvertScaleAction();
        this.logarithmicAction_ = new LogarithmicAction();
        plotMenu.getItemByName("autoscale").setAction(this.autoFitScaleAction_);
        plotMenu.getItemByName("fit-scale").setAction(this.fitScaleAction_);
        plotMenu.getItemByName("zero-scale").setAction(this.zeroScaleAction_);
        plotMenu.getItemByName("invert-scale").setAction(this.invertScaleAction_);
        plotMenu.getItemByName("logarithmic").setAction(this.logarithmicAction_);
        plotMenu.getItemByName("autoscale").setSelected(this.pmeta_.getBoolean("plot:scale.autofit"));
        JLabel rangeLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Scale Range: ");
        JLabel minLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Min.: ");
        JLabel maxLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Max.: ");
        JLabel gapLabel11 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, " ");
        JLabel gapLabel12 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, " ");
        double min = this.pmeta_.getDouble("plot:scale.minimum");
        double max = this.pmeta_.getDouble("plot:scale.maximum");
        if (Double.isNaN(min)) {
            min = -0.1;
            max = 0.1;
        }
        this.minimumTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:scale.minimum", null, this.numFormat(min), 6);
        this.minimumTF_.setHorizontalAlignment(4);
        this.maximumTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:scale.maximum", null, this.numFormat(max), 6);
        this.maximumTF_.setHorizontalAlignment(4);
        this.zeroScaleButton_ = PanWidgetUtils.getButton(PanWidgetUtils.Size.SMALL, null, this.zeroScaleAction_);
        this.zeroScaleButton_.setText("Center on 0");
        this.fitToDataButton_ = PanWidgetUtils.getButton(PanWidgetUtils.Size.SMALL, null, this.fitScaleAction_);
        this.fitToDataButton_.setText("Fit to Data");
        QuickBox rangeBox = QuickBox.createLeftBox(rangeLabel, minLabel, this.minimumTF_, maxLabel, this.maximumTF_, gapLabel11, this.zeroScaleButton_, gapLabel12, this.fitToDataButton_);
        JLabel gapLabel21 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, " ");
        this.autoFitCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:scale.autofit", "Always fit to data", this.pmeta_.getBoolean("plot:scale.autofit"));
        this.autoFitCB_.setAction(this.autoFitScaleAction_);
        this.autoFitCB_.setText("Always fit to data");
        this.autoFitCB_.setToolTipText("Toggle whether the plot scale is automatically fitted to the data min and max.");
        this.autoFitCB_.setAlignmentX(0.0f);
        PanWidgetUtils.restrictWidgetSize(this.autoFitCB_);
        JLabel gapLabel22 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "    ");
        this.log10CB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:scale.log10", "Logarithmic", this.pmeta_.getBoolean("plot:scale.log10"));
        this.log10CB_.setAction(this.logarithmicAction_);
        this.log10CB_.setAlignmentX(0.0f);
        this.log10CB_.setToolTipText("Toggle whether the plot scale is logarithmic.");
        this.log10CB_.setText("Scale is logarithmic  ");
        PanWidgetUtils.restrictWidgetSize(this.log10CB_);
        QuickBox tweakBox = QuickBox.createLeftBox(gapLabel21, this.autoFitCB_, gapLabel22, this.log10CB_);
        JLabel colortableLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Color Table: ");
        this.ctableMenu_ = PanWidgetUtils.getColorTableMenu(PanWidgetUtils.Size.SMALL, "plot:colorbar.name", true);
        this.ctableMenu_.setSelectedItem(this.pmeta_.get("plot:colorbar.name"));
        JLabel comma1Label = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", ");
        boolean inow = this.pmeta_.getBoolean("plot:colorbar.invert");
        this.invertedCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:colorbar.invert", this.invertScaleAction_);
        this.invertedCB_.setSelected(inow);
        this.invertedCB_.setText("Invert colors");
        PanWidgetUtils.restrictWidgetSize(this.invertedCB_);
        ((JCheckBoxMenuItem)plotMenu.getItemByName("invert-scale")).setSelected(inow);
        QuickBox colortableBox = QuickBox.createLeftBox(colortableLabel, this.ctableMenu_, comma1Label, this.invertedCB_);
        JLabel invalidsLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Fill Color: ");
        this.iColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:colors.invalids", PaletteType.GRAYSCALE);
        this.iColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:colors.invalids"));
        JLabel outlierLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ",  Outlier Shape: ");
        this.outlierMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.SMALL, "plot:scale.outlier", PanScaleOutlier.class);
        this.outlierMenu_.setSelectedItem(this.pmeta_.getString("plot:scale.outlier"));
        QuickBox invalidColorBox = QuickBox.createLeftBox(invalidsLabel, this.iColorMenu_, outlierLabel, this.outlierMenu_);
        JLabel captionLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Scale Caption: ");
        this.dfltScaleCapButton_ = PanWidgetUtils.getRadioButton(PanWidgetUtils.Size.SMALL, "plot:scale.caption.default", "Default", this.pmeta_.getBoolean("plot:scale.caption.default"));
        this.userScaleCapButton_ = PanWidgetUtils.getRadioButton(PanWidgetUtils.Size.SMALL, null, "Other: ", !this.pmeta_.getBoolean("plot:scale.caption.default"));
        this.scaleCapTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:scale.caption.usertext", this.pmeta_.getString("plot:scale.caption.usertext"));
        ButtonGroup scaleChoices = new ButtonGroup();
        scaleChoices.add(this.dfltScaleCapButton_);
        scaleChoices.add(this.userScaleCapButton_);
        QuickBox scaleCapBox = QuickBox.createHorizontalBox(captionLabel, this.dfltScaleCapButton_, this.userScaleCapButton_, this.scaleCapTF_);
        JLabel unitsLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Units: ");
        this.unitsMenu_ = PanWidgetUtils.getEditableComboBox(PanWidgetUtils.Size.SMALL, null, this.getData().getUnitsChoices());
        this.unitsMenu_.setSelectedIndex(0);
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel, this.unitsMenu_);
        JLabel scalingLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Scaling Factor: 10^");
        this.scalingSpinner_ = PanWidgetUtils.getSpinner(PanWidgetUtils.Size.SMALL, "plot:scale.scaling.exponent", new SpinnerNumberModel(0, -50, 50, 1));
        QuickBox scalingBox = QuickBox.createLeftBox(scalingLabel, this.scalingSpinner_);
        JLabel majorDivLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Divisions, Major: ");
        this.majorDivSpinner_ = PanWidgetUtils.getSpinner(PanWidgetUtils.Size.SMALL, "plot:scale.majordiv", new SpinnerNumberModel(this.pmeta_.getInt("plot:scale.majordiv"), 1, 20, 1));
        this.majorDivSpinner_.setName("plot:scale.majordiv");
        JLabel minorDivLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Minor: ");
        this.minorDivSpinner_ = PanWidgetUtils.getSpinner(PanWidgetUtils.Size.SMALL, "plot:scale.minordiv", new SpinnerNumberModel(this.pmeta_.getInt("plot:scale.minordiv"), 1, 20, 1));
        this.minorDivSpinner_.setName("plot:scale.minordiv");
        QuickBox divisionsBox = QuickBox.createLeftBox(majorDivLabel, this.majorDivSpinner_, minorDivLabel, this.minorDivSpinner_);
        JLabel tickFormatLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Tick Label Format: ");
        this.tickFormatMenu_ = PanWidgetUtils.getNumberFormatMenu(PanWidgetUtils.Size.SMALL, "plot:scale.tick.format");
        this.tickFormatMenu_.setSelectedItem(this.pmeta_.getString("plot:scale.tick.format"));
        this.tickFormatMenu_.setMaximumRowCount(24);
        JLabel tickSizeLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Size: ");
        this.tickSizeMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:scale.tick.size", TICK_SIZE_CHOICES);
        this.tickSizeMenu_.setSelectedItem(this.pmeta_.getInt("plot:scale.tick.size"));
        QuickBox tickFormatBox = QuickBox.createLeftBox(tickFormatLabel, this.tickFormatMenu_, tickSizeLabel, this.tickSizeMenu_);
        JLabel captionPlaceLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Caption Location: ");
        this.scaleCapPlaceMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.SMALL, "plot:scale.caption.location", PanScaleCaptionLocation.class);
        this.scaleCapPlaceMenu_.setSelectedItem(this.pmeta_.getString("plot:scale.caption.location"));
        QuickBox captionPlaceBox = QuickBox.createLeftBox(captionPlaceLabel, this.scaleCapPlaceMenu_);
        FlexingGridLayout fgl = new FlexingGridLayout(5, 5, 0, 2);
        fgl.setColumnWeight(1, 9999.0f);
        fgl.setColumnWeight(4, 9999.0f);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)rangeBox, new FGConstraint(0, 0, 0.0, 0.5));
        this.add((Component)tweakBox, new FGConstraint(0, 1, 0.0, 0.5));
        this.add((Component)colortableBox, new FGConstraint(0, 2, 0.0, 0.5));
        this.add((Component)invalidColorBox, new FGConstraint(0, 3, 0.0, 0.5));
        this.add((Component)scaleCapBox, new FGConstraint(0, 4, 0.0, 0.5));
        this.add(Box.createHorizontalStrut(8), new FGConstraint(2, 0));
        this.add((Component)unitsBox, new FGConstraint(3, 0, 0.0, 0.5));
        this.add((Component)scalingBox, new FGConstraint(3, 1, 0.0, 0.5));
        this.add((Component)divisionsBox, new FGConstraint(3, 2, 0.0, 0.5));
        this.add((Component)tickFormatBox, new FGConstraint(3, 3, 0.0, 0.5));
        this.add((Component)captionPlaceBox, new FGConstraint(3, 4, 0.0, 0.5));
        this.minimumTF_.setMaximumSize(this.minimumTF_.getPreferredSize());
        this.maximumTF_.setMaximumSize(this.maximumTF_.getPreferredSize());
        Dimension d = this.unitsMenu_.getPreferredSize();
        d.width += 50;
        this.unitsMenu_.setMinimumSize(d);
        this.unitsMenu_.setPreferredSize(d);
        this.unitsMenu_.setMaximumSize(d);
        int lwidth = Math.max(rangeLabel.getPreferredSize().width, colortableLabel.getPreferredSize().width);
        lwidth = Math.max(lwidth, invalidsLabel.getPreferredSize().width);
        lwidth = Math.max(lwidth, captionLabel.getPreferredSize().width);
        Dimension lsize = new Dimension(lwidth, rangeLabel.getPreferredSize().height);
        rangeLabel.setPreferredSize(lsize);
        rangeLabel.setMinimumSize(lsize);
        gapLabel21.setPreferredSize(lsize);
        gapLabel21.setMinimumSize(lsize);
        colortableLabel.setPreferredSize(lsize);
        colortableLabel.setMinimumSize(lsize);
        invalidsLabel.setPreferredSize(lsize);
        invalidsLabel.setMinimumSize(lsize);
        captionLabel.setPreferredSize(lsize);
        captionLabel.setMinimumSize(lsize);
        int tfh = this.scaleCapTF_.getPreferredSize().height;
        this.scaleCapTF_.setMinimumSize(new Dimension(175, tfh));
        this.scaleCapTF_.setPreferredSize(new Dimension(300, tfh));
        this.scaleCapTF_.setMaximumSize(new Dimension(1000, tfh));
        this.refresh();
        this.addListeners();
    }

    public void setColorTable(AbstractColorTable cb) {
        if (cb != this.ctableMenu_.getSelectedItem()) {
            this.ctableMenu_.setSelectedItem(cb);
        }
        this.pmeta_.put("plot:colorbar.name", (Object)cb);
    }

    @Override
    public void refresh() {
        super.refresh();
        boolean enabled = true;
        PanPlotType plotType = (PanPlotType)((Object)this.pmeta_.get("plot:type"));
        if (plotType.equals((Object)PanPlotType.LON_LAT)) {
            enabled = !this.pmeta_.getString("plot:lonlat.type").contains("Zon");
        }
        this.ctableMenu_.setEnabled(enabled);
        this.invertedCB_.setEnabled(enabled);
        this.iColorMenu_.setEnabled(enabled);
        this.outlierMenu_.setEnabled(enabled);
        boolean autofitIsOn = this.autoFitCB_.isSelected();
        boolean log10IsOn = this.log10CB_.isSelected();
        this.minimumTF_.setEnabled(!autofitIsOn);
        this.maximumTF_.setEnabled(!autofitIsOn);
        this.fitScaleAction_.setEnabled(!autofitIsOn);
        this.zeroScaleAction_.setEnabled(!autofitIsOn && !log10IsOn);
        this.majorDivSpinner_.setEnabled(!this.log10CB_.isSelected());
        this.minorDivSpinner_.setEnabled(!this.log10CB_.isSelected());
    }

    private void addListeners() {
        this.ctableMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                Object item = PanScaleControls.this.ctableMenu_.getSelectedItem();
                PanScaleControls.this.pmeta_.put("plot:colorbar.name", item);
            }
        });
        FocusListener rangeFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanScaleControls.this.handleRange(e.getSource());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener rangeAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanScaleControls.this.handleRange(e.getSource());
            }
        };
        this.minimumTF_.addFocusListener(rangeFL);
        this.minimumTF_.addActionListener(rangeAL);
        this.maximumTF_.addFocusListener(rangeFL);
        this.maximumTF_.addActionListener(rangeAL);
        this.unitsMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String units = PanScaleControls.this.unitsMenu_.getSelectedItem().toString();
                PanScaleControls.this.pmeta_.setDataUnits(units, null);
            }
        });
        this.iColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = PanScaleControls.this.iColorMenu_.getSelectedColor();
                if (!cnew.equals(cold = PanScaleControls.this.pmeta_.getColor("plot:colors.invalids"))) {
                    PanScaleControls.this.pmeta_.setColor("plot:colors.invalids", cnew);
                }
            }
        });
        this.outlierMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanScaleControls.this.pmeta_.setString("plot:scale.outlier", ((PanMenuItemEnum)PanScaleControls.this.outlierMenu_.getSelectedItem()).getValue());
            }
        });
        this.dfltScaleCapButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanScaleControls.this.pmeta_.setBoolean("plot:scale.caption.default", PanScaleControls.this.dfltScaleCapButton_.isSelected());
            }
        });
        this.userScaleCapButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanScaleControls.this.pmeta_.setBoolean("plot:scale.caption.default", !PanScaleControls.this.userScaleCapButton_.isSelected());
            }
        });
        this.scaleCapTF_.getDocument().addDocumentListener(new CaptionDocumentListener());
        this.scalingSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                int value = ((SpinnerNumberModel)spinner.getModel()).getNumber().intValue();
                PanScaleControls.this.pmeta_.setDataExponent(value, null);
                PanScaleControls.this.handleRange(null);
                spinner.repaint();
            }
        });
        this.majorDivSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanScaleControls.this.pmeta_.setInt("plot:scale.majordiv", ((SpinnerNumberModel)PanScaleControls.this.majorDivSpinner_.getModel()).getNumber().intValue());
                PanScaleControls.this.majorDivSpinner_.repaint();
            }
        });
        this.minorDivSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanScaleControls.this.pmeta_.setInt("plot:scale.minordiv", ((SpinnerNumberModel)PanScaleControls.this.minorDivSpinner_.getModel()).getNumber().intValue());
                PanScaleControls.this.minorDivSpinner_.repaint();
            }
        });
        this.tickFormatMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String format = PanScaleControls.this.tickFormatMenu_.getSelectedItem().toString();
                PanScaleControls.this.pmeta_.setString("plot:scale.tick.format", format);
                PanScaleControls.this.getData().setScaleFormat(format);
            }
        });
        this.tickSizeMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                int value = (Integer)PanScaleControls.this.tickSizeMenu_.getSelectedItem();
                PanScaleControls.this.pmeta_.setInt("plot:scale.tick.size", value);
            }
        });
        this.scaleCapPlaceMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String value = ((PanMenuItemEnum)PanScaleControls.this.scaleCapPlaceMenu_.getSelectedItem()).getValue();
                PanScaleControls.this.pmeta_.setString("plot:scale.caption.location", value);
            }
        });
        this.pmeta_.addPlotPropertyListener(this);
        this.getData().addDataListener(this);
    }

    @Override
    public synchronized void flush() {
        if (this.pmeta_ != null) {
            this.pmeta_.removePlotPropertyListener(this);
            this.pmeta_ = null;
        }
        if (this.ctableMenu_ != null) {
            this.ctableMenu_.flush();
            this.ctableMenu_ = null;
        }
        this.iColorMenu_ = null;
        super.flush();
    }

    @Override
    public void dataChanged(DataEvent e) {
        if (e == null) {
            return;
        }
        String msg = e.getMessage();
        if (msg == null) {
            return;
        }
        if (msg.equals("variable") || msg.equals("combination")) {
            Object oldItem = this.unitsMenu_.getSelectedItem();
            String oldChoice = oldItem == null ? "" : oldItem.toString();
            boolean isReset = false;
            this.unitsMenu_.removeAllItems();
            for (String choice : this.getData().getUnitsChoices()) {
                this.unitsMenu_.addItem(choice);
                if (!choice.equals(oldChoice)) continue;
                this.unitsMenu_.setSelectedItem(choice);
                isReset = true;
            }
            if (!isReset) {
                this.unitsMenu_.setSelectedIndex(0);
                String units = this.unitsMenu_.getSelectedItem().toString();
                this.pmeta_.setDataUnits(units, null);
            }
            GuiUtilities.restrictSize(this.unitsMenu_);
        }
    }

    private void handleRange(Object source) {
        if (this.pmeta_ == null) {
            return;
        }
        if (this.pmeta_.getBoolean("plot:scale.autofit")) {
            return;
        }
        double min = 0.0;
        double max = 0.0;
        try {
            min = TextUtilities.parseDouble(this.minimumTF_.getText());
        }
        catch (Exception exc) {
            min = this.pmeta_.getDouble("plot:scale.minimum");
            if (Double.isNaN(min)) {
                min = -0.1;
            }
            this.minimumTF_.setText(this.numFormat(min));
        }
        try {
            max = TextUtilities.parseDouble(this.maximumTF_.getText());
        }
        catch (Exception exc) {
            max = this.pmeta_.getDouble("plot:scale.maximum");
            if (Double.isNaN(max)) {
                max = -0.1;
            }
            this.maximumTF_.setText(this.numFormat(max));
        }
        if (this.log10CB_.isSelected()) {
            if (min <= 0.0) {
                min = 1.0E-50;
            }
            if (max <= 1.0E-50) {
                max = 1.0E-25;
            }
        }
        if (max <= min) {
            max = min + 1.0E-25;
            this.maximumTF_.setText(this.numFormat(max));
        }
        this.pmeta_.setDouble("plot:scale.minimum", min);
        this.pmeta_.setDouble("plot:scale.maximum", max);
    }

    private String numFormat(double value) {
        String result = PanConstants.PFORMAT_4G.sprintf(value);
        if (result.equals("0") && value != 0.0) {
            result = PanConstants.PFORMAT_2E.sprintf(value);
        }
        return result;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:lonlat.type")) {
            this.refresh();
        }
        this.repaint();
    }

    class CaptionDocumentListener
    implements DocumentListener {
        CaptionDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateCaption();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateCaption();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateCaption();
        }

        private void updateCaption() {
            PanScaleControls.this.pmeta_.setString("plot:scale.caption.usertext", PanScaleControls.this.scaleCapTF_.getText());
        }
    }

    class InvertScaleAction
    extends AbstractAction {
        private boolean busy_;

        InvertScaleAction() {
            super("Invert Scale Colors");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            Object source = e.getSource();
            boolean isSet = ((AbstractButton)source).isSelected();
            if (source instanceof JCheckBox) {
                PanPlotFrame pf = PanScaleControls.this.getParentFrame();
                if (pf != null) {
                    PanMenuBar mbar = pf.getPanMenuBar();
                    ((JCheckBoxMenuItem)mbar.getItemByName("plot-menu", "invert-scale")).setSelected(isSet);
                }
            } else if (source instanceof JCheckBoxMenuItem) {
                PanScaleControls.this.invertedCB_.setSelected(isSet);
            }
            PanScaleControls.this.pmeta_.setBoolean("plot:colorbar.invert", isSet);
            this.busy_ = false;
        }
    }

    class LogarithmicAction
    extends AbstractAction {
        private boolean busy_;

        LogarithmicAction() {
            super(PanProperties.SOURCES.getString("logarithmic"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            Object source = e.getSource();
            boolean log10IsOn = ((AbstractButton)source).isSelected();
            if (source instanceof JMenuItem) {
                PanScaleControls.this.log10CB_.setSelected(log10IsOn);
            } else {
                PanPlotFrame pf = PanScaleControls.this.getParentFrame();
                if (pf != null) {
                    PanMenuBar mbar = pf.getPanMenuBar();
                    ((JCheckBoxMenuItem)mbar.getItemByName("plot-menu", "logarithmic")).setSelected(log10IsOn);
                }
            }
            log10IsOn = ((AbstractButton)source).isSelected();
            PanScaleControls.this.pmeta_.setBoolean("plot:scale.log10", log10IsOn);
            PanScaleControls.this.refresh();
            PanScaleControls.this.handleRange(null);
            this.busy_ = false;
        }
    }

    class AutoscaleAction
    extends AbstractAction {
        private boolean busy_;

        AutoscaleAction() {
            super(PanProperties.SOURCES.getString("autoscale"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            Object source = e.getSource();
            boolean autofitIsOn = ((AbstractButton)source).isSelected();
            if (source instanceof JMenuItem) {
                PanScaleControls.this.autoFitCB_.setSelected(autofitIsOn);
            } else {
                PanPlotFrame pf = PanScaleControls.this.getParentFrame();
                if (pf != null) {
                    PanMenuBar mbar = pf.getPanMenuBar();
                    ((JCheckBoxMenuItem)mbar.getItemByName("plot-menu", "autoscale")).setSelected(autofitIsOn);
                }
            }
            autofitIsOn = ((AbstractButton)source).isSelected();
            PanScaleControls.this.pmeta_.setBoolean("plot:scale.autofit", autofitIsOn);
            PanScaleControls.this.refresh();
            PanScaleControls.this.handleRange(null);
            this.busy_ = false;
        }
    }

    class FitScaleAction
    extends AbstractAction {
        private boolean busy_;

        FitScaleAction() {
            super(PanProperties.SOURCES.getString("fit-scale"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            double min = PanScaleControls.this.getData().getMinimumValue();
            double max = PanScaleControls.this.getData().getMaximumValue();
            if (Double.isNaN(min)) {
                min = -0.1;
                max = 0.1;
            }
            if (PanScaleControls.this.log10CB_.isSelected()) {
                if (min <= 0.0) {
                    min = 1.0E-50;
                }
                if (max <= 1.0E-50) {
                    max = 1.0E-25;
                }
            }
            PanScaleControls.this.minimumTF_.setText(PanScaleControls.this.numFormat(min));
            PanScaleControls.this.maximumTF_.setText(PanScaleControls.this.numFormat(max));
            PanScaleControls.this.handleRange(null);
            this.busy_ = false;
        }
    }

    class ZeroScaleAction
    extends AbstractAction {
        private boolean busy_;

        ZeroScaleAction() {
            super(PanProperties.SOURCES.getString("zero-scale"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            double min = PanScaleControls.this.getData().getMinimumValue();
            double max = PanScaleControls.this.getData().getMaximumValue();
            if (Double.isNaN(min)) {
                min = -0.1;
                max = 0.1;
            }
            double average = 0.5 * (max + min);
            double halfRange = 0.5 * Math.abs(max - min);
            PanScaleControls.this.minimumTF_.setText(PanConstants.PFORMAT_4G.sprintf(-halfRange));
            PanScaleControls.this.maximumTF_.setText(PanConstants.PFORMAT_4G.sprintf(halfRange));
            PanScaleControls.this.handleRange(null);
            this.busy_ = false;
        }
    }
}

