/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.colortable.ColorTableFilenameFilter;
import gov.nasa.giss.netcdf.NcFilenameFilter;
import gov.nasa.giss.panoply.PanFileConstants;
import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class PanReadableFileFilter
extends FileFilter {
    private String description_;
    private String[] extensions_;

    public PanReadableFileFilter(Grouping grouping) {
        Vector<String> extensions = new Vector<String>(24);
        if (grouping == Grouping.READABLE || grouping == Grouping.DATASETS) {
            for (String s : NcFilenameFilter.getExtensions()) {
                extensions.add(s.toLowerCase());
            }
            this.description_ = "All readable datasets";
        }
        if (grouping == Grouping.READABLE || grouping == Grouping.COLORTABLES) {
            for (String s : ColorTableFilenameFilter.EXTENSIONS) {
                extensions.add(s.toLowerCase());
            }
            this.description_ = "All color tables";
        }
        if (grouping == Grouping.READABLE || grouping == Grouping.CONTINENTS) {
            for (String s : PanFileConstants.CNO_FILTER.getExtensions()) {
                extensions.add(s.toLowerCase());
            }
            for (String s : PanFileConstants.IMAGE_FILTER.getExtensions()) {
                extensions.add(s.toLowerCase());
            }
            this.description_ = "All overlay files";
        }
        if (grouping == Grouping.READABLE) {
            for (String s : PanFileConstants.GRIB1TAB_FILTER.getExtensions()) {
                extensions.add(s.toLowerCase());
            }
            this.description_ = "All readable files";
        }
        this.extensions_ = extensions.toArray(new String[0]);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return this.accept(f.getName());
    }

    public boolean accept(String fname) {
        String lcname = fname.toLowerCase();
        for (String extension : this.extensions_) {
            if (!lcname.endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public static enum Grouping {
        READABLE,
        DATASETS,
        COLORTABLES,
        CONTINENTS;

    }
}

