/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcFilenameFilter;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProtocol {
    private static Logger logger_ = LoggerFactory.getLogger(PanProtocol.class);
    private static final int WAITING = 0;
    private static final int PROTOCOL = 1;
    private static final int VERSION = 2;
    private static final int ASKFILE = 3;
    private static final int ERROR = 4;
    private static final int CONTINUE = 5;
    private int state_ = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String processInput(String input) {
        if (input != null && input.equalsIgnoreCase("bye.")) {
            this.state_ = 0;
            return "Bye.";
        }
        String output = null;
        switch (this.state_) {
            case 0: {
                output = "panoply";
                this.state_ = 1;
                return output;
            }
            case 1: {
                output = "version";
                this.state_ = 2;
                return output;
            }
            case 2: {
                if (input.equalsIgnoreCase("1.4")) {
                    output = "filepath";
                    this.state_ = 3;
                    return output;
                }
                output = "Bye.";
                this.state_ = 0;
                return output;
            }
            case 3: {
                PanSourcesFrame sourcesFrame = PanSourcesFrame.findFrame(true);
                if (!NcFilenameFilter.accept(input)) return "Error opening " + input + ". No '.nc' filename extension.";
                try {
                    File f = new File(input);
                    PanFileUtilities.openDataset(null, f);
                }
                catch (Exception exc) {
                    return "Error opening " + input + ". " + exc.toString();
                }
                sourcesFrame.repaint();
                sourcesFrame.setVisible(true);
                sourcesFrame.toFront();
                output = "continue?";
                this.state_ = 5;
                return output;
            }
            case 4: {
                output = "continue?";
                this.state_ = 5;
                return output;
            }
            case 5: {
                if (input.equalsIgnoreCase("y")) {
                    output = "filepath";
                    this.state_ = 3;
                    return output;
                }
                output = "Bye.";
                this.state_ = 0;
            }
        }
        return output;
    }
}

