/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanProjectionPrefs;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionsTableModel
extends DefaultTableModel {
    private static Logger logger_ = LoggerFactory.getLogger(PanProjectionsTableModel.class);
    private String[] pnames_ = PanProjectionPrefs.getAll(false);

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.pnames_ == null) {
            return 0;
        }
        return this.pnames_.length;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Use?";
            }
            case 1: {
                return "Name";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                boolean checked = PanProjectionPrefs.isVisible(this.pnames_[row]);
                return checked;
            }
            case 1: {
                return this.pnames_[row];
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 && this.pnames_[row].toLowerCase().indexOf("equirect") != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0 || this.pnames_[row].toLowerCase().indexOf("equirect") != 0) {
            // empty if block
        }
        PanProjectionPrefs.setVisible(this.pnames_[row], (Boolean)value);
        this.fireTableDataChanged();
    }
}

