/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.table.GissTable;
import java.awt.Component;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionsTable
extends GissTable {
    private static Logger logger_ = LoggerFactory.getLogger(PanProjectionsTable.class);

    public PanProjectionsTable(TableModel model) {
        super(model);
        JTableHeader jth = this.getTableHeader();
        jth.setReorderingAllowed(false);
        this.setAutoResizeMode(2);
        this.setSelectionMode(1);
        this.setCellSelectionEnabled(true);
        TableColumnModel tcm = this.getColumnModel();
        int icols = this.getColumnCount();
        int irows = this.getRowCount();
        for (int col = 0; col < icols; ++col) {
            TableColumn column = tcm.getColumn(col);
            int width = 0;
            TableCellRenderer tcr = column.getHeaderRenderer();
            if (tcr == null) {
                tcr = jth.getDefaultRenderer();
            }
            if (tcr instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)tcr).setHorizontalAlignment(0);
            }
            Component c = tcr.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            width = c.getPreferredSize().width;
            for (int row = 0; row < irows; ++row) {
                tcr = this.getCellRenderer(row, col);
                c = tcr.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                width = Math.max(width, c.getPreferredSize().width);
            }
            column.setPreferredWidth(width);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.repaint();
    }
}

