/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import java.util.ArrayList;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionPrefs {
    private static Logger logger_ = LoggerFactory.getLogger(PanProjectionPrefs.class);
    private static final Boolean TRUE = true;
    private static final Boolean FALSE = false;
    private static ArrayList<ProjInfo> projinfo_;

    private PanProjectionPrefs() {
    }

    private static void initList() {
        String[] projections = ProjectionFactory.getNames();
        projinfo_ = new ArrayList(projections.length);
        boolean count = false;
        for (String pname : projections) {
            ProjInfo pi = new ProjInfo(pname, true);
            projinfo_.add(pi);
        }
    }

    public static void reset() {
        projinfo_ = null;
        PanProjectionPrefs.initList();
    }

    public static void printList() {
        if (projinfo_ == null) {
            PanProjectionPrefs.initList();
        }
        for (ProjInfo item : projinfo_) {
            System.out.println(item.getName());
        }
    }

    public static String[] getGlobal(boolean visiblesOnly) {
        if (projinfo_ == null) {
            PanProjectionPrefs.initList();
        }
        Vector<String> v = new Vector<String>(projinfo_.size());
        for (ProjInfo item : projinfo_) {
            if (item.getName() == "Equirectangular (Regional)" || visiblesOnly && !item.isVisible()) continue;
            v.add(item.getName());
        }
        return v.toArray(new String[0]);
    }

    public static String[] getAll(boolean visiblesOnly) {
        if (projinfo_ == null) {
            PanProjectionPrefs.initList();
        }
        Vector<String> v = new Vector<String>(projinfo_.size());
        for (ProjInfo item : projinfo_) {
            if (visiblesOnly && !item.isVisible() && item.getName() != "Equirectangular (Regional)") continue;
            v.add(item.getName());
        }
        return v.toArray(new String[0]);
    }

    public static boolean isVisible(String pname) {
        if (projinfo_ == null) {
            PanProjectionPrefs.initList();
        }
        for (ProjInfo item : projinfo_) {
            if (!item.getName().equalsIgnoreCase(pname)) continue;
            return item.isVisible();
        }
        return false;
    }

    public static void setVisible(String pname, String s) {
        PanProjectionPrefs.setVisible(pname, Boolean.valueOf(s));
    }

    public static void setVisible(String pname, Boolean b) {
        PanProjectionPrefs.setVisible(pname, (boolean)b);
    }

    public static void setVisible(String pname, boolean b) {
        if (pname.toLowerCase().indexOf("equirect") == 0) {
            return;
        }
        ProjInfo info = PanProjectionPrefs.getInfo(pname);
        if (info != null) {
            info.setVisible(b);
        }
    }

    public static void setVisible(boolean b) {
        if (projinfo_ == null) {
            PanProjectionPrefs.initList();
        }
        for (ProjInfo item : projinfo_) {
            item.setVisible(b);
        }
    }

    public static String getParam(String pname, int id) {
        ProjInfo info = PanProjectionPrefs.getInfo(pname);
        if (info != null) {
            return info.getParam(id);
        }
        return null;
    }

    public static void setParam(String pname, int id, String value) {
        ProjInfo info = PanProjectionPrefs.getInfo(pname);
        if (info != null) {
            info.setParam(id, value);
        }
    }

    private static ProjInfo getInfo(String pname) {
        if (projinfo_ == null) {
            PanProjectionPrefs.initList();
        }
        for (ProjInfo item : projinfo_) {
            if (!item.getName().equalsIgnoreCase(pname)) continue;
            return item;
        }
        return null;
    }

    static {
        ProjectionFactory.registerProjection(EquirectangularRegional.class);
    }

    public static class ProjInfo {
        private String pname_;
        private boolean visible_;
        private String[] params_;

        ProjInfo(String pname, boolean visible) {
            this.pname_ = pname;
            this.visible_ = visible;
            AbstractProjection projection = ProjectionFactory.create(pname, 2, 2);
            int psize = projection.getParameterCount();
            this.params_ = new String[psize];
            for (int i = 0; i < psize; ++i) {
                this.params_[i] = null;
            }
        }

        String getName() {
            return this.pname_;
        }

        boolean isVisible() {
            return this.visible_;
        }

        void setVisible(boolean visible) {
            this.visible_ = visible;
        }

        String getParam(int id) {
            if (id >= this.params_.length) {
                return null;
            }
            return this.params_[id];
        }

        void setParam(int id, String value) {
            if (id >= this.params_.length) {
                return;
            }
            this.params_[id] = value;
        }
    }
}

