/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanProjectionPrefs;
import javax.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionMenu
extends JComboBox {
    private static Logger logger_ = LoggerFactory.getLogger(PanProjectionMenu.class);
    private boolean visiblesOnly_;
    private boolean includeRegional_;

    public PanProjectionMenu(boolean visiblesOnly, boolean includeRegional) {
        this.setMaximumRowCount(24);
        this.visiblesOnly_ = visiblesOnly;
        this.includeRegional_ = includeRegional;
        this.refresh();
    }

    public void refresh() {
        String[] newList;
        Object oldItem = this.getSelectedItem();
        String oldName = oldItem == null ? null : oldItem.toString();
        boolean oldIsNew = false;
        this.removeAllItems();
        for (String newItem : newList = this.includeRegional_ ? PanProjectionPrefs.getAll(this.visiblesOnly_) : PanProjectionPrefs.getGlobal(this.visiblesOnly_)) {
            this.addItem(newItem);
            if (oldName == null || !newItem.equals(oldName)) continue;
            this.setSelectedItem(newItem);
            oldIsNew = true;
        }
        if (oldIsNew) {
            return;
        }
        this.setSelectedItemByName("Equirectangular");
    }

    public void setSelectedItemByName(String name) {
        if (name == null) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!name.equalsIgnoreCase(this.getItemAt(i).toString())) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setSelectedItemByName("Equirectangular");
    }
}

