/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.tabbedpane.FolderTabbedPane;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanCommonPrefsPanel;
import gov.nasa.giss.panoply.PanContoursAndVectorsPrefsPanel;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanLatVertPrefsPanel;
import gov.nasa.giss.panoply.PanLonLatPrefsPanel;
import gov.nasa.giss.panoply.PanLonVertPrefsPanel;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanMiscPrefsPanel;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProjectionsPrefsPanel;
import gov.nasa.giss.panoply.PanScalePrefsPanel;
import gov.nasa.giss.panoply.PanTimeLatPrefsPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanPreferencesFrame
extends PanFrame {
    private static PanPreferencesFrame frame_;
    private FolderTabbedPane mainTPane_;
    private PanAbstractPrefsPanel commonPanel_;
    private PanAbstractPrefsPanel scalePanel_;
    private PanAbstractPrefsPanel cnvPanel_;
    private PanLonLatPrefsPanel lonlatPanel_;
    private PanAbstractPrefsPanel projPanel_;
    private PanAbstractPrefsPanel latvertPanel_;
    private PanAbstractPrefsPanel lonvertPanel_;
    private PanAbstractPrefsPanel timelatPanel_;
    private PanAbstractPrefsPanel miscPanel_;

    public static PanPreferencesFrame findFrame(boolean create) {
        if (frame_ == null && create) {
            frame_ = new PanPreferencesFrame();
        }
        return frame_;
    }

    private PanPreferencesFrame() {
        super("Preferences");
        this.setName(this.getTitle());
        this.setResizable(false);
        GuiUtilities.applyBrushMetalLook(this);
        this.setPanMenuBar(new PanMenuBar(this));
        this.commonPanel_ = new PanCommonPrefsPanel();
        this.scalePanel_ = new PanScalePrefsPanel();
        this.cnvPanel_ = new PanContoursAndVectorsPrefsPanel();
        this.lonlatPanel_ = new PanLonLatPrefsPanel();
        this.projPanel_ = new PanProjectionsPrefsPanel();
        this.miscPanel_ = new PanMiscPrefsPanel();
        JPanel otherPanel = this.makeOtherPanel();
        this.projPanel_.setPreferredSize(this.lonlatPanel_.getPreferredSize());
        this.mainTPane_ = new FolderTabbedPane();
        this.mainTPane_.setFixedButtonWidth(false);
        this.mainTPane_.setBackgroundDraggable(true);
        this.mainTPane_.setName("[main tpane]");
        this.mainTPane_.addTab("All Plots", this.commonPanel_);
        this.mainTPane_.addTab("Scale", this.scalePanel_);
        this.mainTPane_.addTab("C&V", this.cnvPanel_);
        this.mainTPane_.addTab("Lon-Lat", this.lonlatPanel_);
        this.mainTPane_.addTab("Proj", this.projPanel_);
        this.mainTPane_.addTab("Other", otherPanel);
        this.mainTPane_.addTab("Misc.", this.miscPanel_);
        JButton resetButton = new JButton("Reset All Prefs");
        resetButton.setHorizontalAlignment(0);
        resetButton.setAlignmentX(0.5f);
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanPreferences.getPrefs().restoreDefaults();
                PanPreferencesFrame.this.refresh();
            }
        });
        QuickBox resetBox = QuickBox.createCenterBox(resetButton);
        resetBox.setOpaque(true);
        resetBox.setBackground(new Color(230, 230, 230));
        resetBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(PanGuiConstants.NO_BORDER);
        contentPanel.setOpaque(false);
        contentPanel.add(this.mainTPane_);
        contentPanel.add(resetBox);
        Container contentPane = this.getContentPane();
        contentPane.add(contentPanel);
        this.mainTPane_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanPreferencesFrame.this.refresh();
            }
        });
        this.pack();
        Rectangle rr = GuiUtilities.getMainScreenBounds();
        if (rr == null) {
            this.setLocation(250, 100);
        } else {
            Dimension psize = contentPane.getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) / 2;
            this.setLocation(rr.x + x, rr.y + y);
        }
    }

    private JPanel makeOtherPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(PanGuiConstants.STD_BORDER);
        this.latvertPanel_ = new PanLatVertPrefsPanel();
        this.lonvertPanel_ = new PanLonVertPrefsPanel();
        this.timelatPanel_ = new PanTimeLatPrefsPanel();
        this.latvertPanel_.setBorder(GuiUtilities.createPaddedTitleBorder("Lat-Vert Plots"));
        this.lonvertPanel_.setBorder(GuiUtilities.createPaddedTitleBorder("Lon-Vert Plots"));
        this.timelatPanel_.setBorder(GuiUtilities.createPaddedTitleBorder("Time-Lat Plots"));
        panel.add(this.latvertPanel_);
        panel.add(Box.createVerticalStrut(2));
        panel.add(this.lonvertPanel_);
        panel.add(Box.createVerticalStrut(2));
        panel.add(this.timelatPanel_);
        panel.add(Box.createVerticalGlue());
        panel.add(Box.createVerticalGlue());
        this.latvertPanel_.setOpaque(false);
        this.lonvertPanel_.setOpaque(false);
        this.timelatPanel_.setOpaque(false);
        panel.setOpaque(false);
        return panel;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.commonPanel_.refresh();
        this.scalePanel_.refresh();
        this.cnvPanel_.refresh();
        this.lonlatPanel_.refresh();
        this.projPanel_.refresh();
        this.latvertPanel_.refresh();
        this.lonvertPanel_.refresh();
        this.timelatPanel_.refresh();
        this.miscPanel_.refresh();
    }
}

