/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.ColorUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanBookmarkType;
import gov.nasa.giss.panoply.PanBookmarksFolder;
import gov.nasa.giss.panoply.PanBookmarksList;
import gov.nasa.giss.panoply.PanBookmarksNode;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanContourStyle;
import gov.nasa.giss.panoply.PanGridStyle;
import gov.nasa.giss.panoply.PanHistoryFolder;
import gov.nasa.giss.panoply.PanHistoryList;
import gov.nasa.giss.panoply.PanLonLatPlotType;
import gov.nasa.giss.panoply.PanOverlayList;
import gov.nasa.giss.panoply.PanParameterNames;
import gov.nasa.giss.panoply.PanPlotSize;
import gov.nasa.giss.panoply.PanProjectionPrefs;
import gov.nasa.giss.panoply.PanScaleCaptionLocation;
import gov.nasa.giss.panoply.PanScaleOutlier;
import gov.nasa.giss.panoply.PanVectorStyle;
import gov.nasa.giss.panoply.PanVertUnit;
import gov.nasa.giss.prefs.AbstractPreferences;
import gov.nasa.giss.prefs.PreferencesHash;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.xml.EasyParser;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPreferences
extends AbstractPreferences
implements PanParameterNames {
    private static Logger logger_ = LoggerFactory.getLogger(PanPreferences.class);
    private static final String LATEST_PREFS_VERSION = "3.0.0";
    public static final PrintfFormat PFORMATG = new PrintfFormat("%.10g");
    private static PanPreferences myPrefs_;

    public static PanPreferences getPrefs() {
        if (myPrefs_ == null) {
            myPrefs_ = new PanPreferences();
        }
        return myPrefs_;
    }

    private PanPreferences() {
        super("gov.nasa.giss", "Panoply");
    }

    @Override
    public synchronized void restoreDefaults() {
        super.set("path:open", "");
        super.set("path:save", "");
        super.set("launch:splash", TRUE);
        super.set("launch:dialog", FALSE);
        super.set("save:dialog.always", FALSE);
        super.set("save:image.extension", "PNG");
        super.set("save:animation.extension", "MOV");
        super.set("save:animation.frate", new Integer(4));
        super.set("save:animation.quality", new Integer(100));
        super.set("save:animation.subtitles", TRUE);
        super.set("grib:strict", TRUE);
        super.set("history:days", new Integer(30));
        super.set("sources:nodes.expanded", TRUE);
        super.set("sources:toolbar.labels", TRUE);
        super.set("sources:nodes.plottables", FALSE);
        super.set("sources:info.visible", TRUE);
        super.set("sources:bounds.left", new Integer(25));
        super.set("sources:bounds.top", new Integer(25));
        super.set("sources:bounds.width", new Integer(500));
        super.set("sources:bounds.height", new Integer(300));
        if (PanPlotSize.fitsDisplay(120)) {
            super.set("plot:size.factor", new Integer(120));
        } else if (PanPlotSize.fitsDisplay(100)) {
            super.set("plot:size.factor", new Integer(100));
        } else {
            super.set("plot:size.factor", new Integer(80));
        }
        super.set("plot:colors.background", Color.WHITE);
        super.set("plot:colors.invalids", Color.LIGHT_GRAY);
        super.set("plot:colorbar.name", PanColorTableList.getList().findByName("panoply.gct"));
        super.set("plot:colorbar.invert", FALSE);
        super.set("plot:scale.interpolate", TRUE);
        super.set("plot:scale.autofit", FALSE);
        super.set("plot:scale.log10", FALSE);
        super.set("plot:scale.tick.format", "%.1E");
        super.set("plot:scale.majordiv", new Integer(5));
        super.set("plot:scale.minordiv", new Integer(2));
        super.set("plot:scale.tick.size", new Integer(11));
        super.set("plot:scale.outlier", PanScaleOutlier.TRIANGLE.getValue());
        super.set("plot:scale.caption.location", PanScaleCaptionLocation.ABOVE.getValue());
        super.set("plot:scale.minmaxnote", TRUE);
        super.set("plot:contour.style", PanContourStyle.NONE.getValue());
        super.set("plot:contour.color", Color.BLACK);
        super.set("plot:contour.weight", new Integer(75));
        super.set("plot:contour.labels", FALSE);
        super.set("plot:contour.location", "major");
        super.set("plot:vector.style", PanVectorStyle.ARROW.getValue());
        super.set("plot:vector.color", Color.BLACK);
        super.set("plot:vector.weight", new Integer(75));
        super.set("plot:vector.spacing", new Integer(110));
        super.set("plot:font.master", "SansSerif");
        super.set("plot:lonlat.type", PanLonLatPlotType.MAP.getValue());
        super.set("plot:lonlat.map.projection", "Equirectangular");
        super.set("plot:lonlat.map.center.lon", new Double(0.0));
        super.set("plot:lonlat.map.center.lat", new Double(0.0));
        super.set("plot:lonlat.map.projnote", FALSE);
        super.set("plot:lonlat.map.grid.spacing", new Double(10.0));
        super.set("plot:lonlat.map.grid.color", Color.DARK_GRAY);
        super.set("plot:lonlat.map.grid.weight", new Integer(50));
        super.set("plot:lonlat.map.grid.style", PanGridStyle.SOLID.getValue());
        super.set("plot:lonlat.map.overlay", PanOverlayList.getList().findByName("Earth.cno"));
        super.set("plot:lonlat.map.overlay.color", Color.BLACK);
        super.set("plot:lonlat.map.overlay.weight", new Integer(80));
        super.set("plot:lonlat.map.overlay.invert", FALSE);
        super.set("plot:lonlat.zonal.lataxis.flipped", TRUE);
        super.set("plot:lonlat.zonal.grid.color", Color.BLACK);
        super.set("plot:lonlat.zonal.grid.weight", new Integer(100));
        super.set("plot:lonlat.zonal.stroke.color", Color.RED);
        super.set("plot:lonlat.zonal.lataxis.max", new Double(90.0));
        super.set("plot:lonlat.zonal.lataxis.min", new Double(-90.0));
        super.set("plot:latvert.grid.color", Color.BLACK);
        super.set("plot:latvert.grid.weight", new Integer(25));
        super.set("plot:latvert.vaxis.units", PanVertUnit.SCALAR.getValue());
        super.set("plot:latvert.vaxis.format", "%.1f");
        super.set("plot:latvert.lataxis.flipped", TRUE);
        super.set("plot:latvert.vaxis.flipped", FALSE);
        super.set("plot:latvert.lataxis.min", new Double(-90.0));
        super.set("plot:latvert.lataxis.max", new Double(90.0));
        super.set("plot:lonvert.grid.color", Color.BLACK);
        super.set("plot:lonvert.grid.weight", new Integer(25));
        super.set("plot:lonvert.vaxis.units", PanVertUnit.SCALAR.getValue());
        super.set("plot:lonvert.vaxis.format", "%.1f");
        super.set("plot:lonvert.vaxis.flipped", FALSE);
        super.set("plot:lonvert.lonaxis.min", new Double(-180.0));
        super.set("plot:lonvert.lonaxis.max", new Double(180.0));
        super.set("plot:timelat.grid.color", Color.BLACK);
        super.set("plot:timelat.grid.weight", new Integer(25));
        super.set("plot:timelat.taxis.majordiv", new Integer(5));
        super.set("plot:timelat.taxis.minordiv", new Integer(2));
        super.set("plot:timelat.lataxis.max", new Double(90.0));
        super.set("plot:timelat.lataxis.min", new Double(-90.0));
        if (this.get("plot:colorbar.name") == null) {
            super.set("plot:colorbar.name", PanColorTableList.getList().get(0));
        }
        if (this.get("plot:lonlat.map.overlay") == null) {
            super.set("plot:lonlat.map.overlay", PanOverlayList.getList().get(0));
        }
        PanProjectionPrefs.reset();
    }

    @Override
    protected void readStream(InputStream istream) throws IOException, JDOMException {
        Document document = EasyParser.parseDocument(istream);
        Element root = document.getRootElement();
        String rootName = root.getName();
        if (!rootName.equals("application")) {
            logger_.warn("Root of prefs tree is not 'application'. Skipping.");
            return;
        }
        try {
            String name = root.getAttribute("name").getValue();
            if (!name.equals(this.getAppName().toLowerCase())) {
                logger_.warn("Root of prefs tree has wrong application name. Skipping.");
                return;
            }
        }
        catch (Exception exc) {
            logger_.warn("Could not read prefs app name. Skipping.");
            return;
        }
        String version = LATEST_PREFS_VERSION;
        try {
            version = root.getAttribute("version").getValue();
            if (version == null) {
                version = LATEST_PREFS_VERSION;
            }
        }
        catch (Exception exc) {
            logger_.warn("Could not read prefs version. Skipping.");
            return;
        }
        if (version.compareTo(LATEST_PREFS_VERSION) < 0) {
            logger_.warn("Old prefs version. Skipping.");
            return;
        }
        for (Element child : root.getChildren()) {
            String tagName = child.getName();
            if (tagName.equals("property")) {
                this.readProperty(this, child);
                continue;
            }
            if (tagName.equals("group")) {
                try {
                    String pkey = child.getAttribute("key").getValue();
                    if (pkey != null) {
                        if (pkey.equals("projections")) {
                            this.readProjections(child);
                            continue;
                        }
                        if (pkey.equals("bookmarks") || pkey.equals("history")) {
                            this.readBookmarks(child);
                            continue;
                        }
                    }
                }
                catch (Exception exc) {
                    logger_.warn("Unable to parse pref property.");
                    return;
                }
                this.readGroup(this, child);
                continue;
            }
            if (tagName.equals("projections")) {
                this.readProjections(child);
                continue;
            }
            if (tagName.equals("bookmarks") || tagName.equals("history")) {
                this.readBookmarks(child);
                continue;
            }
            logger_.warn("Unknown pref name {} in root group", (Object)tagName);
        }
    }

    private void readGroup(PreferencesHash parent, Element newGroup) {
        String pkey = null;
        try {
            pkey = newGroup.getAttribute("key").getValue();
        }
        catch (Exception exc) {
            logger_.warn("Unable to parse pref property.");
            return;
        }
        if (pkey == null) {
            logger_.warn("Pref property has no key.");
            return;
        }
        Object already = parent.get(pkey);
        if (already == null) {
            logger_.warn("Unknown pref group for key {}", (Object)pkey);
            return;
        }
        if (!(already instanceof PreferencesHash)) {
            logger_.warn("Existing pref {} is not a subgroup", (Object)pkey);
            return;
        }
        PreferencesHash pg = (PreferencesHash)already;
        for (Element child : newGroup.getChildren()) {
            String tagName = child.getName();
            if (tagName.equals("property")) {
                this.readProperty(pg, child);
                continue;
            }
            if (tagName.equals("group")) {
                this.readGroup(pg, child);
                continue;
            }
            logger_.warn("Unknown pref name {} in group {}", (Object)tagName, (Object)pkey);
        }
    }

    private void readProperty(PreferencesHash parent, Element child) {
        String pkey = null;
        String pvalue = null;
        try {
            pkey = child.getAttribute("key").getValue();
            pvalue = child.getAttribute("value").getValue();
        }
        catch (Exception exc) {
            logger_.warn("Unable to parse pref property.");
            return;
        }
        if (pkey == null) {
            logger_.warn("Pref property has no key.");
            return;
        }
        if (!parent.containsKey(pkey)) {
            logger_.warn("Unknown pref property key {} in {}", (Object)pkey, (Object)parent.getName());
            return;
        }
        Object already = parent.get(pkey);
        if (already == null && !pkey.equals("lonlat.map.overlay")) {
            logger_.warn("Unknown pref class for key {} with null value", (Object)pkey);
            return;
        }
        if (pkey.equals("lonlat.map.overlay")) {
            if (pvalue == null) {
                parent.set(pkey, null);
                return;
            }
            Object o = PanOverlayList.getList().findByName(pvalue);
            if (o == null) {
                pvalue = pvalue.replaceAll(" outline$", ".CNO");
                o = PanOverlayList.getList().findByName(pvalue);
            }
            if (o == null) {
                pvalue = pvalue.replaceAll("\\.CNO$", ".CNOB");
                o = PanOverlayList.getList().findByName(pvalue);
            }
            if (o == null) {
                pvalue = pvalue.replaceAll(" mask$", ".GIF");
                o = PanOverlayList.getList().findByName(pvalue);
            }
            parent.set(pkey, o);
        } else if (already instanceof AbstractColorTable) {
            Object o = PanColorTableList.getList().findByName(pvalue);
            if (o == null) {
                pvalue = pvalue.replaceAll(" ", ".");
                o = PanColorTableList.getList().findByName(pvalue);
            }
            if (o == null) {
                logger_.warn("No color table for key {}", (Object)pvalue);
            } else {
                parent.set(pkey, o);
            }
        } else if (already instanceof Double) {
            try {
                parent.setDouble(pkey, pvalue);
            }
            catch (Exception exc) {
                logger_.warn("Bad double for key {}", (Object)pkey);
            }
        } else if (already instanceof Integer) {
            try {
                parent.setInt(pkey, pvalue);
            }
            catch (Exception exc) {
                logger_.warn("Bad int for key {}", (Object)pkey);
            }
        } else if (already instanceof Boolean) {
            parent.set(pkey, Boolean.valueOf(pvalue));
        } else if (already instanceof String) {
            parent.set(pkey, pvalue);
        } else if (already instanceof Color) {
            try {
                parent.setColor(pkey, pvalue);
            }
            catch (Exception exc) {
                logger_.warn("Bad color for key {}", (Object)pkey);
            }
        } else {
            logger_.warn("No class handler for pref property key {}", (Object)pkey);
        }
    }

    private void readBookmarks(Element bookmarksElement) {
        this.readBookmarksFolder(null, bookmarksElement);
    }

    private void readBookmarksFolder(PanBookmarksNode parentNode, Element folderElement) {
        String folderType = folderElement.getName();
        if (parentNode == null && folderType.equals("group")) {
            try {
                folderType = folderElement.getAttribute("key").getValue();
            }
            catch (Exception exc) {
                folderType = "unknown";
            }
        }
        PanBookmarksNode folder = null;
        if (folderType.equals("bookmarks")) {
            folder = PanBookmarksList.getList();
        } else if (folderType.equals("history")) {
            folder = PanHistoryList.getList();
        } else if (folderType.equals("folder") && parentNode instanceof PanHistoryList) {
            try {
                String date = folderElement.getAttribute("name").getValue();
                folder = new PanHistoryFolder(parentNode, date);
                parentNode.add(folder);
            }
            catch (Exception exc) {
                logger_.warn("Could not parse history folder date.");
                exc.printStackTrace();
            }
        } else if (folderType.equals("folder")) {
            Attribute nameAttr = folderElement.getAttribute("name");
            String name = nameAttr != null ? nameAttr.getValue() : "Unnamed Folder";
            folder = new PanBookmarksFolder(parentNode, name);
            parentNode.add(folder);
        } else {
            logger_.warn("Unknown bookmarks folder type.");
            return;
        }
        for (Element lchild : folderElement.getChildren()) {
            String lchildName = lchild.getName();
            if (lchildName.equals("folder") || lchildName.equals("day")) {
                this.readBookmarksFolder(folder, lchild);
                continue;
            }
            if (!lchildName.equals("link")) continue;
            Attribute typeAttr = lchild.getAttribute("atype");
            Attribute addressAttr = lchild.getAttribute("address");
            Attribute nameAttr = lchild.getAttribute("name");
            if (typeAttr == null || addressAttr == null) continue;
            String address = addressAttr.getValue();
            String name = nameAttr != null ? nameAttr.getValue() : null;
            PanBookmark b = null;
            try {
                b = new PanBookmark(typeAttr.getValue(), (Object)address, name);
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (b == null) continue;
            folder.add(b);
        }
        if (folderType.equals("folder") && parentNode instanceof PanHistoryList && folder.getChildCount() < 1) {
            parentNode.remove(folder);
        }
    }

    private void readProjections(Element projections) {
        Iterator<Element> piter = projections.getChildren().iterator();
        if (!piter.hasNext()) {
            return;
        }
        for (String pname : PanProjectionPrefs.getAll(false)) {
            PanProjectionPrefs.setVisible(pname, true);
        }
        while (piter.hasNext()) {
            Element lchild = piter.next();
            String lchildName = lchild.getName();
            if (lchildName.equals("projection")) {
                String lname;
                Attribute nattrib = lchild.getAttribute("name");
                if (nattrib == null || (lname = nattrib.getValue()) == null || lname.equals("")) continue;
                Attribute pvis = lchild.getAttribute("visible");
                String isVisible = "true";
                if (pvis != null && (isVisible = pvis.getValue()) == null) {
                    isVisible = "true";
                }
                PanProjectionPrefs.setVisible(lname, isVisible);
                for (int i = 0; i < 5; ++i) {
                    Attribute param = lchild.getAttribute("param" + i);
                    if (param == null) continue;
                    PanProjectionPrefs.setParam(lname, i, param.getValue());
                }
                continue;
            }
            logger_.warn("Unknown projections setting '{}'", (Object)lchildName);
        }
    }

    @Override
    protected void saveStream(OutputStream ostream) throws IOException {
        if (ostream == null) {
            throw new IllegalArgumentException("Null output stream.");
        }
        Element root = new Element("application");
        root.setAttribute("name", this.getAppName().toLowerCase());
        root.setAttribute("version", LATEST_PREFS_VERSION);
        this.writeGroup(this, root);
        this.writeProjections(root);
        this.writeBookmarks(root);
        Document d = new Document(root);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(d, ostream);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void writeGroup(PreferencesHash group, Element element) {
        for (String pkey : group.keySet()) {
            Object pvalue = group.get(pkey);
            Element ex = null;
            if (pvalue instanceof PreferencesHash) {
                PreferencesHash pg = (PreferencesHash)pvalue;
                ex = new Element("group");
                ex.setAttribute("key", pkey);
                this.writeGroup(pg, ex);
            } else {
                ex = new Element("property");
                ex.setAttribute("key", pkey);
                if (pkey.equals("lonlat.map.overlay") && pvalue == null) {
                    ex.setAttribute("value", "<null>");
                } else if (pvalue instanceof Double) {
                    ex.setAttribute("value", PFORMATG.sprintf(pvalue));
                } else if (pvalue instanceof Color) {
                    String s = ColorUtilities.colorToString((Color)pvalue);
                    ex.setAttribute("value", s);
                } else if (pvalue instanceof AbstractColorTable) {
                    ex.setAttribute("value", ((AbstractColorTable)pvalue).toString());
                } else if (pvalue instanceof AbstractOverlay) {
                    ex.setAttribute("value", ((AbstractOverlay)pvalue).toString());
                } else {
                    ex.setAttribute("value", pvalue.toString());
                }
            }
            element.addContent(ex);
        }
    }

    private void writeBookmarks(Element parentElement) throws IOException {
        PanBookmarksList blist = PanBookmarksList.getList();
        this.writeBookmarksFolder(parentElement, blist);
        blist = PanHistoryList.getList();
        ((PanHistoryList)blist).enforceAgeLimit(this.getInt("history:days"));
        this.writeBookmarksFolder(parentElement, blist);
    }

    private void writeBookmarksFolder(Element parentElement, PanBookmarksNode folder) throws IOException {
        TreeTableNode[] children;
        Element ffex;
        if (folder instanceof PanHistoryList) {
            ffex = new Element("group");
            ffex.setAttribute("key", "history");
        } else if (folder instanceof PanHistoryFolder) {
            ffex = new Element("folder");
            ffex.setAttribute("name", ((PanHistoryFolder)folder).getDateString());
        } else if (folder instanceof PanBookmarksList) {
            ffex = new Element("group");
            ffex.setAttribute("key", "bookmarks");
        } else if (folder instanceof PanBookmarksFolder) {
            ffex = new Element("folder");
            if (folder.isNameSet()) {
                ffex.setAttribute("name", folder.getName());
            }
        } else {
            logger_.warn("Unknown bookmarks 'folder' type.");
            return;
        }
        block5: for (TreeTableNode child : children = folder.getChildren()) {
            PanBookmarksNode node = (PanBookmarksNode)child;
            if (node instanceof PanBookmark) {
                Element bfex = new Element("link");
                PanBookmark b = (PanBookmark)node;
                Object o = node.getObject();
                PanBookmarkType btype = b.getAccessType();
                switch (btype) {
                    case LOCAL_DATASET: {
                        bfex.setAttribute("atype", "local");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    case REMOTE_DATASET: {
                        bfex.setAttribute("atype", "remote");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    case CATALOG: {
                        bfex.setAttribute("atype", "catalog");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (b.isNameSet()) {
                    bfex.setAttribute("name", b.getName());
                }
                ffex.addContent(bfex);
                continue;
            }
            if (!(node instanceof PanBookmarksFolder) && !(node instanceof PanHistoryFolder)) continue;
            this.writeBookmarksFolder(ffex, node);
        }
        parentElement.addContent(ffex);
    }

    private void writeProjections(Element parent) throws IOException {
        Element projex = new Element("group");
        projex.setAttribute("key", "projections");
        for (String pname : PanProjectionPrefs.getAll(false)) {
            boolean visible = PanProjectionPrefs.isVisible(pname);
            Element fex = new Element("projection");
            fex.setAttribute("name", pname);
            fex.setAttribute("visible", "" + visible);
            for (int i = 0; i < 5; ++i) {
                String pval = PanProjectionPrefs.getParam(pname, i);
                if (pval == null) continue;
                fex.setAttribute("param" + i, pval);
            }
            projex.addContent(fex);
        }
        parent.addContent(projex);
    }

    @Override
    public Object get(String key) {
        Object o = super.get(key);
        if (o == null && key.equals("plot:colorbar.name")) {
            o = (AbstractColorTable)PanColorTableList.getList().get(0);
        }
        return o;
    }
}

