/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.panoply.PanAbstractBookmarksMenu;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotSize;
import gov.nasa.giss.panoply.PanProperties;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;

public class PanPlotSizeMenu
extends PanAbstractBookmarksMenu {
    private JCheckBoxMenuItem miXSmall_;
    private JCheckBoxMenuItem miSmall_;
    private JCheckBoxMenuItem miStandard_;
    private JCheckBoxMenuItem miLarge_;
    private JCheckBoxMenuItem miXLarge_;
    private JCheckBoxMenuItem miJumbo_;
    private JCheckBoxMenuItem miXJumbo_;

    public PanPlotSizeMenu(PanFrame parent) {
        super(parent, "size-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        AbstractAction a = null;
        if (parentIsPlot) {
            a = new AbstractAction(PanProperties.MENUS.getString("xsmall-size")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPlotSizeMenu.this.resizePlot(PanPlotSize.XSMALL);
                }
            };
        }
        this.miXSmall_ = this.makeCheckBoxItemFromProperties("xsmall-size", a);
        this.add(this.miXSmall_);
        a = null;
        if (parentIsPlot && PanPlotSize.SMALL.fitsDisplay()) {
            a = new AbstractAction(PanProperties.MENUS.getString("small-size")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPlotSizeMenu.this.resizePlot(PanPlotSize.SMALL);
                }
            };
        }
        this.miSmall_ = this.makeCheckBoxItemFromProperties("small-size", a);
        this.add(this.miSmall_);
        a = null;
        if (parentIsPlot && PanPlotSize.STANDARD.fitsDisplay()) {
            a = new AbstractAction(PanProperties.MENUS.getString("standard-size")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPlotSizeMenu.this.resizePlot(PanPlotSize.STANDARD);
                }
            };
        }
        this.miStandard_ = this.makeCheckBoxItemFromProperties("standard-size", a);
        this.add(this.miStandard_);
        a = null;
        if (parentIsPlot && PanPlotSize.LARGE.fitsDisplay()) {
            a = new AbstractAction(PanProperties.MENUS.getString("large-size")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPlotSizeMenu.this.resizePlot(PanPlotSize.LARGE);
                }
            };
        }
        this.miLarge_ = this.makeCheckBoxItemFromProperties("large-size", a);
        this.add(this.miLarge_);
        a = null;
        if (parentIsPlot && PanPlotSize.XLARGE.fitsDisplay()) {
            a = new AbstractAction(PanProperties.MENUS.getString("xlarge-size")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPlotSizeMenu.this.resizePlot(PanPlotSize.XLARGE);
                }
            };
        }
        this.miXLarge_ = this.makeCheckBoxItemFromProperties("xlarge-size", a);
        this.add(this.miXLarge_);
        a = null;
        if (parentIsPlot && PanPlotSize.JUMBO.fitsDisplay()) {
            a = new AbstractAction(PanProperties.MENUS.getString("jumbo-size")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPlotSizeMenu.this.resizePlot(PanPlotSize.JUMBO);
                }
            };
        }
        this.miJumbo_ = this.makeCheckBoxItemFromProperties("jumbo-size", a);
        this.add(this.miJumbo_);
        a = null;
        if (parentIsPlot && PanPlotSize.XJUMBO.fitsDisplay()) {
            a = new AbstractAction(PanProperties.MENUS.getString("xjumbo-size")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanPlotSizeMenu.this.resizePlot(PanPlotSize.XJUMBO);
                }
            };
        }
        this.miXJumbo_ = this.makeCheckBoxItemFromProperties("xjumbo-size", a);
        this.add(this.miXJumbo_);
        this.refresh();
    }

    public void resizePlot(PanPlotSize size) {
        JFrame pf = GuiUtilities.getParentFrame(this);
        if (pf != null) {
            ((PanPlotFrame)pf).setPlotSize(size);
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        this.miXSmall_.setEnabled(this.miXSmall_.getAction() != null);
        this.miSmall_.setEnabled(this.miSmall_.getAction() != null);
        this.miStandard_.setEnabled(this.miStandard_.getAction() != null);
        this.miLarge_.setEnabled(this.miLarge_.getAction() != null);
        this.miXLarge_.setEnabled(this.miXLarge_.getAction() != null);
        this.miJumbo_.setEnabled(this.miJumbo_.getAction() != null);
        this.miXJumbo_.setEnabled(this.miXJumbo_.getAction() != null);
        JFrame pf = GuiUtilities.getParentFrame(this);
        if (pf == null) {
            return;
        }
        if (pf instanceof PanPlotFrame) {
            int sf = ((PanPlotFrame)pf).getSizeFactor();
            this.miXSmall_.setSelected(PanPlotSize.XSMALL.getSizeFactor() == sf);
            this.miSmall_.setSelected(PanPlotSize.SMALL.getSizeFactor() == sf);
            this.miStandard_.setSelected(PanPlotSize.STANDARD.getSizeFactor() == sf);
            this.miLarge_.setSelected(PanPlotSize.LARGE.getSizeFactor() == sf);
            this.miXLarge_.setSelected(PanPlotSize.XLARGE.getSizeFactor() == sf);
            this.miJumbo_.setSelected(PanPlotSize.JUMBO.getSizeFactor() == sf);
            this.miXJumbo_.setSelected(PanPlotSize.XJUMBO.getSizeFactor() == sf);
        }
        super.refresh();
    }
}

