/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public enum PanPlotSize {
    XSMALL(80, "Extra Small"),
    SMALL(100, "Small"),
    STANDARD(120, "Standard"),
    LARGE(140, "Large"),
    XLARGE(160, "Extra Large"),
    JUMBO(180, "Jumbo"),
    XJUMBO(200, "Super Jumbo");

    private int factor_;
    private String description_;
    private static Rectangle screenSize_;
    private static int vertical_;

    private PanPlotSize(int factor, String description) {
        this.factor_ = factor;
        this.description_ = description;
    }

    public String toString() {
        return this.description_;
    }

    public int getSizeFactor() {
        return this.factor_;
    }

    public boolean fitsDisplay() {
        return PanPlotSize.fitsDisplay(this.factor_);
    }

    public static boolean fitsDisplay(int factor) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge.isHeadless()) {
            return true;
        }
        if (screenSize_ == null) {
            screenSize_ = GuiUtilities.getMainScreenBounds();
            vertical_ = PanPlotSize.screenSize_.height;
            if (PlatformUtilities.isMacintosh()) {
                vertical_ -= 22;
                vertical_ -= 268;
            } else if (PlatformUtilities.isWindows()) {
                vertical_ -= 40;
                vertical_ -= 278;
            } else {
                vertical_ -= 290;
            }
        }
        return vertical_ > (int)(496.0 * ((double)factor * 0.01)) - 4;
    }
}

