/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.cursor.CursorUtilities;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotGlass;
import gov.nasa.giss.panoply.plot.PanPlotHolder;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMouseListener
extends MouseInputAdapter
implements KeyEventDispatcher,
KeyListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanPlotMouseListener.class);
    protected static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected static final boolean META_IS_SHORTCUT = SHORTCUT_MASK == 4;
    protected static final boolean CTRL_IS_SHORTCUT = SHORTCUT_MASK == 2;
    protected static int SHORTCUT_LIT = 4096;
    protected static int OTHER_LIT = 256;
    protected static int ALT_LIT = 16;
    protected static int SHIFT_LIT = 1;
    protected PanPlotFrame frame_;

    public PanPlotMouseListener(PanPlotFrame frame) {
        this.frame_ = frame;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public synchronized void flush() {
        this.frame_ = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.frame_.isFocused()) {
            return false;
        }
        PanPlotHolder ph = this.frame_.getPlotHolder();
        if (!ph.isVisible()) {
            return false;
        }
        Point framePt = this.frame_.getMousePosition(true);
        if (framePt == null) {
            return false;
        }
        if (this.frame_.getComponentAt(framePt) == ph) {
            return false;
        }
        if (ph.isFocusOwner()) {
            return false;
        }
        int km = this.getModifiers(e);
        if (e.getID() == 401) {
            this.keyPressed(e);
        } else if (e.getID() == 402) {
            this.keyReleased(e);
        }
        return false;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handleKeyEvent(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Component c = e.getComponent();
        if (c == null || !(c instanceof PanPlotHolder)) {
            return;
        }
        PanPlotHolder ph = (PanPlotHolder)c;
        if (!ph.isVisible()) {
            return;
        }
        ph.requestFocus();
        PanPlotGlass glass = (PanPlotGlass)this.frame_.getGlassPane();
        glass.setContentType(PanPlotGlass.ContentType.NONE);
        glass.repaint();
        CursorUtilities.setDefaultCursor(this.frame_);
        if (e.isPopupTrigger()) {
            return;
        }
        int keyModifiers = this.getModifiers(e);
        Point eventPt = e.getPoint();
        if (keyModifiers == ALT_LIT) {
            Point glassPt = SwingUtilities.convertPoint(ph, eventPt, glass);
            glass.setPoint(glassPt);
            glass.setText(ph.describePoint(eventPt.x, eventPt.y));
            glass.setContentType(PanPlotGlass.ContentType.TEXT_BOX);
            glass.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        CursorUtilities.setDefaultCursor(this.frame_);
        PanPlotGlass glass = (PanPlotGlass)this.frame_.getGlassPane();
        glass.setContentType(PanPlotGlass.ContentType.NONE);
        glass.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateCursor(e);
    }

    protected void handleKeyEvent(KeyEvent e) {
        PanPlotHolder plotHolder = this.frame_.getPlotHolder();
        if (!plotHolder.isVisible()) {
            return;
        }
        this.updateCursor(e);
    }

    protected void updateCursor(InputEvent e) {
        Point framePt = this.frame_.getMousePosition(true);
        if (framePt == null) {
            CursorUtilities.setDefaultCursor(this.frame_);
            return;
        }
        Point phPt = SwingUtilities.convertPoint(this.frame_, framePt, this.frame_.getPlotHolder());
        Point2D.Double p2d = this.transformXY2GridCoords(phPt);
        if (p2d == null) {
            CursorUtilities.setDefaultCursor(this.frame_);
            return;
        }
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == ALT_LIT) {
            CursorUtilities.setHelpCursor(this.frame_);
        } else {
            CursorUtilities.setDefaultCursor(this.frame_);
        }
    }

    protected int getModifiers(InputEvent e) {
        int result = 0;
        if (META_IS_SHORTCUT) {
            if (e.isMetaDown()) {
                result |= SHORTCUT_LIT;
            }
            if (e.isControlDown()) {
                result |= OTHER_LIT;
            }
        } else if (CTRL_IS_SHORTCUT) {
            if (e.isControlDown()) {
                result |= SHORTCUT_LIT;
            }
            if (e.isMetaDown()) {
                result |= OTHER_LIT;
            }
        }
        if (e.isShiftDown()) {
            result |= SHIFT_LIT;
        }
        if (e.isAltDown()) {
            result |= ALT_LIT;
        }
        return result;
    }

    private Point2D.Double transformXY2GridCoords(Point pt) {
        PanPlotHolder ph = this.frame_.getPlotHolder();
        return ph.transformXY2GridCoords(pt.x, pt.y);
    }
}

