/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.panoply.PanGraphicUtilities;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class PanPlotGlass
extends JComponent {
    private static final Color DRAG_FRAME_COLOR = Color.WHITE;
    private static final Color DRAG_BACK_COLOR = Color.WHITE;
    private static final Color DATA_FRAME_COLOR = Color.GRAY;
    private static final Color DATA_TEXT_COLOR = Color.BLACK;
    private static final Color DATA_BACK_COLOR = new Color(255, 255, 221);
    private static final BasicStroke DATA_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke DRAG_STROKE = PanGraphicUtilities.buttMiterStroke(100, new float[]{3.0f, 2.0f, 3.0f, 2.0f});
    private static final AlphaComposite DRAG_ALPHA = AlphaComposite.getInstance(3, 0.25f);
    private static final int BOX_X_MARGIN = 5;
    private static final int BOX_Y_MARGIN = 3;
    private ContentType contentType_ = ContentType.NONE;
    private Rectangle rectangle_;
    private Point point_;
    private String text_;

    public PanPlotGlass() {
        this.setOpaque(false);
        this.setFont(new Font("SansSerif", 0, 10));
    }

    public void setContentType(ContentType ct) {
        this.contentType_ = ct;
    }

    public void setPoint(Point point) {
        this.point_ = point;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle_ = rectangle;
    }

    public void setText(String text) {
        this.text_ = text;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.contentType_ == ContentType.NONE) {
            return;
        }
        if (this.contentType_ == ContentType.TEXT_BOX) {
            this.paintText(g);
        } else if (this.contentType_ == ContentType.DRAG_FRAME) {
            this.paintDrag(g);
        }
    }

    private void paintDrag(Graphics g) {
        if (this.rectangle_.width == 0 || this.rectangle_.height == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        GraphicUtilities.antialias(g2d);
        g2d.setPaintMode();
        g2d.setColor(DRAG_FRAME_COLOR);
        g2d.setStroke(DRAG_STROKE);
        GraphicUtilities.drawRect(g2d, this.rectangle_.x, this.rectangle_.y, this.rectangle_.width, this.rectangle_.height);
        g2d.setComposite(DRAG_ALPHA);
        g2d.setColor(DRAG_BACK_COLOR);
        GraphicUtilities.fillRect(g2d, this.rectangle_.x, this.rectangle_.y, this.rectangle_.width, this.rectangle_.height);
        g2d.dispose();
    }

    private void paintText(Graphics g) {
        if (this.point_ == null || this.text_ == null || this.text_.length() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        GraphicUtilities.antialias(g2d);
        int x = this.point_.x;
        int y = this.point_.y;
        g2d.setColor(DATA_TEXT_COLOR);
        g2d.setStroke(DATA_STROKE);
        g2d.drawLine(x - 3, y, x + 3, y);
        g2d.drawLine(x, y - 3, x, y + 3);
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics(this.getFont());
        int lineHeight = fm.getHeight();
        int lineAscent = fm.getAscent();
        StringTokenizer t = new StringTokenizer(this.text_.toString(), "\n");
        int numLines = t.countTokens();
        String[] lines = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            lines[i] = t.nextToken();
        }
        int twidth = 0;
        for (String line : lines) {
            twidth = Math.max(twidth, fm.stringWidth(line));
        }
        twidth += 10;
        int awidth = ((JFrame)this.getTopLevelAncestor()).getWidth() - 40;
        if (x < awidth / 2) {
            if ((x += 2) + twidth > awidth - 20) {
                x -= x + twidth - (awidth - 20);
            }
        } else if ((x -= 2 + twidth) < 20) {
            x += 20 - x;
        }
        int theight = numLines * lineHeight + 6;
        g2d.setColor(DATA_BACK_COLOR);
        GraphicUtilities.fillRect(g2d, x, y += 5, twidth, theight);
        g2d.setColor(DATA_FRAME_COLOR);
        g2d.setStroke(DATA_STROKE);
        GraphicUtilities.drawRect(g2d, x, y, twidth, theight);
        x += 5;
        y += 3 + lineAscent;
        g2d.setColor(DATA_TEXT_COLOR);
        int i = 0;
        while (i < numLines) {
            g2d.drawString(lines[i], x, y);
            ++i;
            y += lineHeight;
        }
        g2d.dispose();
    }

    public static enum ContentType {
        NONE,
        TEXT_BOX,
        DRAG_FRAME;

    }
}

