/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import gov.nasa.giss.graphics.ps.PsDocument;
import gov.nasa.giss.graphics.ps.PsGraphics2D;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.menu.GissMenu;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanAnimationNote;
import gov.nasa.giss.panoply.PanArrayControls;
import gov.nasa.giss.panoply.PanArrayDataPanel;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanControlsTabbedPane;
import gov.nasa.giss.panoply.PanDisplayFrame;
import gov.nasa.giss.panoply.PanLonLatMouseListener;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPlotDropTargetListener;
import gov.nasa.giss.panoply.PanPlotGlass;
import gov.nasa.giss.panoply.PanPlotMouseListener;
import gov.nasa.giss.panoply.PanPlotSize;
import gov.nasa.giss.panoply.PanPlotTabbedPane;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.actions.PanExportAnimationAction;
import gov.nasa.giss.panoply.actions.PanExportKmzAction;
import gov.nasa.giss.panoply.actions.PanLargerPlotAction;
import gov.nasa.giss.panoply.actions.PanSaveImageAsAction;
import gov.nasa.giss.panoply.actions.PanSmallerPlotAction;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlotHolder;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotFrame
extends PanDisplayFrame
implements Printable {
    private static Logger logger_ = LoggerFactory.getLogger(PanPlotFrame.class);
    public static final int MAX_FRAMES = 10;
    protected static int frameCount_ = 0;
    protected static String[] showTabNames_;
    protected PanPlotMeta pmeta_;
    protected PanPlotType plotType_;
    protected PanAbstractData data_;
    protected PanAbstractPlot plot_;
    protected PanPlotHolder plotHolder_;
    protected JPanel mainBox_;
    protected PanPlotTabbedPane topTabPane_;
    protected PanControlsTabbedPane controlsTabPane_;
    protected PanArrayDataPanel[] adataPanels_ = new PanArrayDataPanel[2];
    protected ShowTopTabAction[] showTopTabActions_ = new ShowTopTabAction[3];
    private PanLargerPlotAction largerAction_;
    private PanSmallerPlotAction smallerAction_;
    protected PanPlotMouseListener mouseAdapter_;
    private PanAnimationNote controlsCover_;
    private JComponent statusBar_;
    private Vector<Action> hiddenActions_;
    private int nonplotHeight_;
    private int nonplotWidth_;
    private boolean resizing_ = false;
    private boolean closing_ = false;

    public PanPlotFrame(PanPlotMeta pmeta) {
        super("Plot Frame");
        GuiUtilities.applyBrushMetalLook(this);
        this.setResizable(false);
        if (pmeta == null) {
            throw new IllegalArgumentException("pmeta is null.");
        }
        pmeta.setFrame(this);
        this.pmeta_ = pmeta;
        this.plotType_ = pmeta.getType();
        this.data_ = pmeta.getData();
        this.plot_ = pmeta.getPlot();
        if (this.data_ == null) {
            throw new IllegalArgumentException("Data is null.");
        }
        this.setName("plot frame #" + frameCount_++);
        String vname = this.data_.getArray(0).getName().replace(' ', '_');
        String dname = this.data_.getArray(0).getDataset().getNameRoot().replace(' ', '_');
        if (vname.length() > 32) {
            vname = vname.substring(0, 32);
        }
        if (dname.length() > 32) {
            dname = dname.substring(0, 32);
        }
        for (int ix = 1; ix < 9999; ++ix) {
            String ftitle = vname + " in " + dname;
            if (ix > 1) {
                ftitle = ftitle + " " + ix;
            }
            boolean matched = false;
            for (PanPlotFrame frame : PanPlotFrame.getListOfFrames()) {
                if (!frame.isVisible() || !frame.getTitle().equalsIgnoreCase(ftitle)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            this.setTitle(ftitle);
            break;
        }
        this.createPlotHolder();
        this.attachNonMenuActions();
        this.attachMenuBarAndActions();
        this.attachContentBox();
        this.attachGlass();
        this.setDefaultCloseOperation(0);
        this.updateComponentSizes();
        this.pack();
        this.nonplotWidth_ = this.getContentPane().getWidth() - this.pmeta_.getDimension((String)"plot:size.pixels").width;
        this.nonplotHeight_ = this.getContentPane().getHeight() - this.pmeta_.getDimension((String)"plot:size.pixels").height;
        this.setMinimumSize(new Dimension(540, 570));
        java.awt.Rectangle rr = GuiUtilities.getMainScreenBounds();
        Dimension psize = this.getPreferredSize();
        if (rr == null) {
            this.setLocation(25, 25);
        } else if (PlatformUtilities.isMacintosh()) {
            this.setLocation(rr.x + (rr.width - psize.width) / 2, rr.y + 5 + 22);
        } else {
            this.setLocation(rr.x + (rr.width - psize.width) / 2, rr.y + 5);
        }
    }

    @Override
    public void setTitle(String s) {
        Action a;
        super.setTitle(s);
        PanMenuBar mbar = this.getPanMenuBar();
        if (mbar != null && (a = mbar.getItemActionByName("file-menu", "save-image-as")) != null) {
            ((PanSaveImageAsAction)a).flush();
        }
    }

    protected void createPlotHolder() {
        this.plotHolder_ = new PanPlotHolder(this.plot_);
        this.mouseAdapter_ = this.plotType_ == PanPlotType.LON_LAT ? new PanLonLatMouseListener(this) : new PanPlotMouseListener(this);
        this.plotHolder_.setRequestFocusEnabled(true);
        this.plotHolder_.addMouseListener(this.mouseAdapter_);
        this.plotHolder_.addMouseMotionListener(this.mouseAdapter_);
        this.plotHolder_.addKeyListener(this.mouseAdapter_);
        PanPlotDropTargetListener pdtl = new PanPlotDropTargetListener(this);
        DropTarget dt = new DropTarget(this.plotHolder_, pdtl);
    }

    private void attachNonMenuActions() {
        InputMap im = this.plotHolder_.getInputMap(2);
        ActionMap am = this.plotHolder_.getActionMap();
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean metaIsShortcut = shortcutMask == 4;
        AbstractAction action = new CancelAnimationAction();
        KeyStroke ks = KeyStroke.getKeyStroke("ESCAPE");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta PERIOD") : KeyStroke.getKeyStroke("ctrl PERIOD");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
        action = new ChangeCombinationAction(PanCombinationType.A1_MINUS_A2);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift M") : KeyStroke.getKeyStroke("ctrl shift M");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
        action = new ChangeCombinationAction(PanCombinationType.AVERAGE_A1_A2);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift G") : KeyStroke.getKeyStroke("ctrl shift G");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
        action = new ChangeCombinationAction(PanCombinationType.COMBINE_A1_A2);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift C") : KeyStroke.getKeyStroke("ctrl shift C");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
        action = new ChangeCombinationAction(PanCombinationType.VECTOR_A1_A2);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift V") : KeyStroke.getKeyStroke("ctrl shift V");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
    }

    protected void attachMenuBarAndActions() {
        AbstractAction a;
        if (showTabNames_ == null) {
            showTabNames_ = new String[3];
            PanPlotFrame.showTabNames_[0] = PanProperties.MENUS.getString("show-plot");
            PanPlotFrame.showTabNames_[1] = PanProperties.MENUS.getString("show-array-1");
            PanPlotFrame.showTabNames_[2] = PanProperties.MENUS.getString("show-array-2");
        }
        PanMenuBar mbar = new PanMenuBar(this);
        GissMenu fileMenu = mbar.getMenuByName("file-menu");
        GissMenu exportMenu = mbar.getMenuByName("export-menu");
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        GissMenu viewMenu = mbar.getMenuByName("view-menu");
        if (this.plotType_ == PanPlotType.LON_LAT) {
            a = new PanExportKmzAction(this);
            fileMenu.getItemByName("export-kmz").setAction(a);
            a.setEnabled(true);
        }
        a = new PanExportAnimationAction(this);
        fileMenu.getItemByName("export-animation").setAction(a);
        this.largerAction_ = new PanLargerPlotAction(this);
        this.smallerAction_ = new PanSmallerPlotAction(this);
        viewMenu.getItemByName("show-larger").setAction(this.largerAction_);
        viewMenu.getItemByName("show-smaller").setAction(this.smallerAction_);
        for (int i = 0; i < 3; ++i) {
            this.showTopTabActions_[i] = new ShowTopTabAction(i);
            if (i == 2) {
                this.showTopTabActions_[i].setEnabled(false);
            }
            viewMenu.getItemByText(showTabNames_[i]).setAction(this.showTopTabActions_[i]);
        }
        ((JRadioButtonMenuItem)viewMenu.getItemByName("show-plot")).setSelected(true);
        ShowControlsAction showArrayControlsAction = new ShowControlsAction("show-array-controls", PanProperties.PCONTROLS.getString("arrays-tab"));
        ShowControlsAction showScaleControlsAction = new ShowControlsAction("show-scale-controls", PanProperties.PCONTROLS.getString("scale-tab"));
        ShowControlsAction showContourControlsAction = this.plotType_ == PanPlotType.LON_LAT || this.plotType_ == PanPlotType.LAT_VERT ? new ShowControlsAction("show-contour-controls", PanProperties.PCONTROLS.getString("contours-and-vectors-tab")) : new ShowControlsAction("show-contour-controls", PanProperties.PCONTROLS.getString("contours-tab"));
        ShowControlsAction showGridControlsAction = new ShowControlsAction("show-grid-controls", PanProperties.PCONTROLS.getString("grid-tab"));
        ShowControlsAction showLabelControlsAction = new ShowControlsAction("show-label-controls", PanProperties.PCONTROLS.getString("labels-tab"));
        viewMenu.getItemByName("show-array-controls").setAction(showArrayControlsAction);
        viewMenu.getItemByName("show-scale-controls").setAction(showScaleControlsAction);
        viewMenu.getItemByName("show-contour-controls").setAction(showContourControlsAction);
        viewMenu.getItemByName("show-grid-controls").setAction(showGridControlsAction);
        viewMenu.getItemByName("show-label-controls").setAction(showLabelControlsAction);
        this.setPanMenuBar(mbar);
    }

    protected void attachContentBox() {
        this.topTabPane_ = new PanPlotTabbedPane(this);
        this.topTabPane_.setLowerBorder(true);
        this.topTabPane_.addTab("Plot", this.plotHolder_);
        this.updateArrayDataPanel(0);
        this.controlsTabPane_ = new PanControlsTabbedPane(this, this.getPanMenuBar(), this.pmeta_);
        this.statusBar_ = this.createStatusBar();
        this.mainBox_ = new JPanel();
        this.mainBox_.setOpaque(false);
        this.mainBox_.setLayout(new BoxLayout(this.mainBox_, 1));
        this.mainBox_.add(this.topTabPane_);
        this.mainBox_.add(this.controlsTabPane_);
        this.mainBox_.add(this.statusBar_);
        this.getContentPane().add(this.mainBox_);
        this.refresh();
    }

    protected void attachGlass() {
        PanPlotGlass glass = new PanPlotGlass();
        this.setGlassPane(glass);
        glass.setVisible(true);
    }

    public Component findComponentNamed(String pname) {
        return PanPlotFrame.findComponentNamed(this, pname);
    }

    protected static Component findComponentNamed(Container parent, String pname) {
        Component[] children = parent.getComponents();
        if (children == null) {
            return null;
        }
        for (Component child : children) {
            Component c;
            if (child.getName() != null && child.getName().equals(pname)) {
                return child;
            }
            if (!(child instanceof Container) || (c = PanPlotFrame.findComponentNamed((Container)child, pname)) == null) continue;
            return c;
        }
        return null;
    }

    public PanPlotMeta getMeta() {
        return this.pmeta_;
    }

    public PanAbstractData getData() {
        return this.data_;
    }

    public PanAbstractPlot getPlot() {
        return this.plot_;
    }

    public PanPlotType getPlotType() {
        return this.plotType_;
    }

    public PanPlotHolder getPlotHolder() {
        return this.plotHolder_;
    }

    public PanControlsTabbedPane getControls() {
        return this.controlsTabPane_;
    }

    public PanArrayDataPanel[] getArrayDataPanels() {
        return this.adataPanels_;
    }

    public NcArray[] getArrays() {
        return this.data_.getArrays();
    }

    public void addVariable(NcArray nca) {
        this.toFront();
        if (this.data_.getArray(0) == null) {
            this.addVariable(0, nca);
        } else if (this.data_.getArray(1) == null) {
            this.addVariable(1, nca);
        } else {
            this.showReplaceDialog(nca);
        }
    }

    protected void addVariable(int vindex, NcArray nca) {
        this.toFront();
        NcArray2D nca2D = (NcArray2D)nca;
        NcArray2D nca2D0 = (NcArray2D)this.data_.getArray(0);
        if (this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT) {
            boolean compatible = nca2D.getYAxis().isCompatible(nca2D0.getYAxis());
            if (!compatible) {
                GuiUtilities.showSlowMessage(this, "Plot Warning", "The vertical axes of the arrays have units\nthat do not appear to be compatible. Your\ncombination request will be canceled.");
                return;
            }
        } else if (this.plotType_ == PanPlotType.TIME_LAT) {
            boolean compatible = nca2D.getXAxis().isCompatible(nca2D0.getXAxis());
            boolean equal = nca2D.getXAxis().equals(nca2D0.getXAxis());
            if (!compatible) {
                GuiUtilities.showSlowMessage(this, "Plot Warning", "The time axes of the arrays have units\nthat do not appear to be compatible. Your\ncombination request will be canceled.");
                return;
            }
            if (compatible && !equal) {
                this.showForceDialog(vindex, nca);
                return;
            }
        }
        this.setVariable(vindex, nca);
    }

    protected void setVariable(int vindex, NcArray nca) {
        if (vindex < 0 || vindex > 1) {
            return;
        }
        this.pmeta_.setDataVariable(vindex, nca, null);
    }

    public void updateArrayDataPanel(int arrayIndex) {
        int tabIndex = arrayIndex + 1;
        if (this.adataPanels_[arrayIndex] != null) {
            this.topTabPane_.removeTabAt(tabIndex);
        }
        this.adataPanels_[arrayIndex] = new PanArrayDataPanel(this.plotType_, this.data_, arrayIndex);
        this.adataPanels_[arrayIndex].setName("Array " + tabIndex);
        this.topTabPane_.add((Component)this.adataPanels_[arrayIndex], tabIndex);
        this.topTabPane_.repaint();
        this.topTabPane_.refresh();
        Component c = this.findComponentNamed("array-controls");
        if (c != null) {
            ((PanArrayControls)c).updateSlicePanel(arrayIndex);
        }
    }

    public void setAnimationInProgress(final boolean hide) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PanPlotFrame.this.closing_) {
                    return;
                }
                if (hide) {
                    if (PanPlotFrame.this.controlsCover_ == null) {
                        PanPlotFrame.this.controlsCover_ = new PanAnimationNote();
                    }
                    PanPlotFrame.this.mainBox_.remove(PanPlotFrame.this.controlsTabPane_);
                    PanPlotFrame.this.mainBox_.remove(PanPlotFrame.this.statusBar_);
                    PanPlotFrame.this.mainBox_.add(PanPlotFrame.this.controlsCover_);
                    PanPlotFrame.this.mainBox_.add(PanPlotFrame.this.statusBar_);
                } else {
                    PanPlotFrame.this.setResizable(true);
                    PanPlotFrame.this.mainBox_.remove(PanPlotFrame.this.controlsCover_);
                    PanPlotFrame.this.mainBox_.remove(PanPlotFrame.this.statusBar_);
                    PanPlotFrame.this.mainBox_.add(PanPlotFrame.this.controlsTabPane_);
                    PanPlotFrame.this.mainBox_.add(PanPlotFrame.this.statusBar_);
                    PanPlotFrame.this.setResizable(false);
                }
                PanPlotFrame.this.mainBox_.invalidate();
                PanPlotFrame.this.mainBox_.validate();
                PanPlotFrame.this.repaint();
                if (hide) {
                    PanPlotFrame.this.disableActions();
                } else {
                    PanPlotFrame.this.enableActions();
                }
            }
        });
    }

    private void enableActions() {
        for (Action a : this.hiddenActions_) {
            a.setEnabled(true);
        }
    }

    private void disableActions() {
        this.hiddenActions_ = new Vector(40);
        PanMenuBar mbar = this.getPanMenuBar();
        GissMenu fileMenu = mbar.getMenuByName("file-menu");
        GissMenu viewMenu = mbar.getMenuByName("view-menu");
        GissMenu sizeMenu = mbar.getMenuByName("size-menu");
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        this.hiddenActions_.add(fileMenu.getItemActionByName("save-image"));
        this.hiddenActions_.add(fileMenu.getItemActionByName("save-image-as"));
        this.hiddenActions_.add(fileMenu.getItemActionByName("export-animation"));
        this.hiddenActions_.add(fileMenu.getItemActionByName("print"));
        this.hiddenActions_.add(viewMenu.getItemActionByName("show-array-controls"));
        this.hiddenActions_.add(viewMenu.getItemActionByName("show-scale-controls"));
        this.hiddenActions_.add(viewMenu.getItemActionByName("show-contour-controls"));
        this.hiddenActions_.add(viewMenu.getItemActionByName("show-grid-controls"));
        this.hiddenActions_.add(viewMenu.getItemActionByName("show-label-controls"));
        this.hiddenActions_.add(plotMenu.getItemActionByName("interpolate"));
        this.hiddenActions_.add(plotMenu.getItemActionByName("invert-scale"));
        this.hiddenActions_.add(plotMenu.getItemActionByName("autoscale"));
        this.hiddenActions_.add(plotMenu.getItemActionByName("logarithmic"));
        this.hiddenActions_.add(plotMenu.getItemActionByName("fit-scale"));
        this.hiddenActions_.add(plotMenu.getItemActionByName("zero-scale"));
        this.hiddenActions_.add(plotMenu.getItemActionByName("background"));
        Action a = fileMenu.getItemByName("export-kmz").getAction();
        if (a != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = viewMenu.getItemByName("show-larger").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = viewMenu.getItemByName("show-smaller").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = plotMenu.getItemByName("plot-type").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = sizeMenu.getItemByName("xsmall-size").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = sizeMenu.getItemByName("small-size").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = sizeMenu.getItemByName("standard-size").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = sizeMenu.getItemByName("large-size").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = sizeMenu.getItemByName("xlarge-size").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = sizeMenu.getItemByName("jumbo-size").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        if ((a = sizeMenu.getItemByName("xjumbo-size").getAction()) != null) {
            this.hiddenActions_.add(a);
        }
        for (Action a2 : this.hiddenActions_) {
            a2.setEnabled(false);
        }
    }

    protected void showReplaceDialog(final NcArray nca) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] options = new String[]{"Cancel", "Replace Var 2", "Replace Var 1"};
                int choice = JOptionPane.showOptionDialog(PanPlotFrame.this, "This plot window already has two variables\nassigned to it. Should I replace one?", null, 1, 3, null, options, null);
                if (choice == 1) {
                    PanPlotFrame.this.addVariable(1, nca);
                } else if (choice == 2) {
                    PanPlotFrame.this.addVariable(0, nca);
                } else {
                    return;
                }
            }
        });
    }

    protected void showForceDialog(final int vindex, final NcArray nca) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] options = new String[]{"Continue", "Cancel"};
                int choice = JOptionPane.showOptionDialog(PanPlotFrame.this, "The time axes of the arrays have units\nthat seem similar but are not equal.", null, 2, 3, null, options, null);
                if (choice == 0) {
                    PanPlotFrame.this.setVariable(vindex, nca);
                } else if (choice == 2) {
                    return;
                }
            }
        });
    }

    @Override
    public void refresh() {
        if (this.topTabPane_ != null) {
            this.topTabPane_.refresh();
        }
        if (this.controlsTabPane_ != null) {
            this.controlsTabPane_.refresh();
        }
        if (this.adataPanels_[0] != null) {
            this.adataPanels_[0].refresh();
        }
        if (this.adataPanels_[1] != null) {
            this.adataPanels_[1].refresh();
        }
        this.showTopTabActions_[2].setEnabled(this.adataPanels_[1] != null);
        if (this.plot_ instanceof PanLonLatPlot) {
            PanLonLatPlot llp = (PanLonLatPlot)this.plot_;
            PanMenuBar mbar = this.getPanMenuBar();
            GissMenu fileMenu = mbar.getMenuByName("file-menu");
            Action a = fileMenu.getItemByName("export-kmz").getAction();
            if (a != null) {
                a.setEnabled(llp.isMap());
            }
        }
        super.refresh();
    }

    @Override
    public void close() {
        this.closing_ = true;
        this.setVisible(false);
        if (this.mainBox_ != null) {
            this.mainBox_.removeAll();
        }
        if (this.mouseAdapter_ != null) {
            this.mouseAdapter_.flush();
        }
        if (this.plotHolder_ != null) {
            this.plotHolder_.flush();
        }
        if (this.pmeta_ != null) {
            this.pmeta_.flush();
        }
        if (this.topTabPane_ != null) {
            this.topTabPane_.removeAll();
        }
        if (this.plot_ != null) {
            this.plot_.flush();
        }
        if (this.controlsTabPane_ != null) {
            this.controlsTabPane_.flush();
            this.controlsTabPane_.removeAll();
        }
        this.removeAll();
        this.controlsTabPane_ = null;
        this.pmeta_ = null;
        this.plotType_ = null;
        this.data_ = null;
        this.plot_ = null;
        this.mainBox_ = null;
        this.mouseAdapter_ = null;
        this.plotHolder_ = null;
        this.adataPanels_[0] = null;
        this.adataPanels_[1] = null;
        for (WindowListener windowListener : this.getWindowListeners()) {
            this.removeWindowListener(windowListener);
        }
        for (EventListener eventListener : this.getWindowFocusListeners()) {
            this.removeWindowFocusListener((WindowFocusListener)eventListener);
        }
        this.setPanMenuBar(null);
        this.dispose();
    }

    public static PanPlotFrame[] getListOfFrames() {
        ArrayList<PanPlotFrame> fList = new ArrayList<PanPlotFrame>(10);
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame) || !frame.isVisible()) continue;
            fList.add((PanPlotFrame)frame);
        }
        Comparator titleCmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Frame)o1).getTitle().compareTo(((Frame)o2).getTitle());
            }
        };
        Collections.sort(fList, titleCmp);
        PanPlotFrame[] array = fList.toArray(new PanPlotFrame[0]);
        return array;
    }

    public static int countVisibleFrames() {
        int count = 0;
        for (Frame f : Frame.getFrames()) {
            if (f == null || !(f instanceof PanPlotFrame) || !f.isVisible()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double scaleY = pf.getImageableWidth() / (double)this.plot_.getHeight();
        double scaleX = pf.getImageableHeight() / (double)this.plot_.getWidth();
        double scale = Math.min(scaleY, scaleX);
        double tranX = 0.5 * (pf.getImageableWidth() + scale * (double)this.plot_.getHeight());
        g2d.translate(pf.getImageableX() + tranX, pf.getImageableY());
        g2d.rotate(1.5707963267948966);
        g2d.scale(scale, scale);
        this.plot_.print(g2d);
        return 0;
    }

    @Override
    public BufferedImage getImage() {
        return this.plot_.getImage();
    }

    @Override
    public void paintImage(BufferedImage img) {
        this.plot_.paintImage(img);
    }

    @Override
    public void paintContentPDF(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        Rectangle pageSize = document.getPageSize();
        Dimension useSize = new Dimension((int)(pageSize.width() - 144.0f), (int)(pageSize.height() - 144.0f));
        Dimension plotSize = this.plot_.getSize();
        float scaleX = (float)useSize.width / (float)plotSize.width;
        float scaleY = (float)useSize.height / (float)plotSize.height;
        float scale = Math.min(scaleY, scaleX);
        cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, (pageSize.width() - (float)plotSize.width * scale) / 2.0f, (pageSize.height() - (float)plotSize.height * scale) / 2.0f);
        cb.concatCTM(scale, 0.0f, 0.0f, scale, 0.0f, 0.0f);
        Graphics2D g2d = cb.createGraphicsShapes(this.plot_.getWidth(), this.plot_.getHeight());
        this.plot_.print(g2d);
        g2d.dispose();
    }

    @Override
    public void paintContentPs(PsDocument document) {
        PsGraphics2D g2d = document.createGraphics(true);
        Dimension pageSize = document.getSize();
        Dimension useSize = new Dimension((int)((float)pageSize.width - 144.0f), (int)((float)pageSize.height - 144.0f));
        Dimension plotSize = this.plot_.getSize();
        float scaleX = (float)useSize.width / (float)plotSize.width;
        float scaleY = (float)useSize.height / (float)plotSize.height;
        float scale = Math.min(scaleY, scaleX);
        ((Graphics2D)g2d).translate(((float)pageSize.width - (float)plotSize.width * scale) / 2.0f, ((float)pageSize.height - (float)plotSize.height * scale) / 2.0f);
        ((Graphics2D)g2d).scale(scale, scale);
        this.plot_.print(g2d);
        ((Graphics)g2d).dispose();
    }

    public void setPlotSize(PanPlotSize size) {
        this.setSizeFactor(size.getSizeFactor());
    }

    public int getSizeFactor() {
        return this.pmeta_.getSizeFactor();
    }

    public void setSizeFactor(int sf) {
        this.resizing_ = true;
        this.pmeta_.setSizeFactor(sf);
        this.updateComponentSizes();
        this.pack();
        this.setSize(this.getPreferredSize());
        this.repaint();
        this.resizing_ = false;
    }

    public void updateComponentSizes() {
        Dimension psize = this.pmeta_.getDimension("plot:size.pixels");
        Dimension phsize = this.plotHolder_.getPreferredSize();
        if (phsize.width < 928) {
            phsize.width = 928;
        }
        this.plotHolder_.setSize(phsize);
        this.plotHolder_.setMinimumSize(phsize);
        this.plotHolder_.setMaximumSize(phsize);
        int pleft = (phsize.width - psize.width) / 2;
        int ptop = (phsize.height - psize.height) / 2;
        this.plot_.setLocation(pleft, ptop);
        for (PanArrayDataPanel panel : this.adataPanels_) {
            if (panel == null) continue;
            panel.setPreferredSize(psize);
            panel.setPreferredSize(phsize);
            panel.setMinimumSize(phsize);
            panel.setMaximumSize(new Dimension(4000, phsize.height));
        }
        this.mainBox_.invalidate();
        this.mainBox_.validate();
        this.repaint();
        int sf = this.pmeta_.getSizeFactor();
        this.smallerAction_.setEnabled(sf > 70);
        this.largerAction_.setEnabled(sf < 200 && PanPlotSize.fitsDisplay(sf + 10));
    }

    class ChangeCombinationAction
    extends AbstractAction {
        PanCombinationType ctype_;

        ChangeCombinationAction(PanCombinationType ctype) {
            super(ctype.getValue());
            this.ctype_ = ctype;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanPlotFrame.this.controlsTabPane_ == null) {
                return;
            }
            if (PanPlotFrame.this.data_.getArray(0) == null || PanPlotFrame.this.data_.getArray(1) == null) {
                return;
            }
            PanArrayControls acp = (PanArrayControls)PanPlotFrame.this.controlsTabPane_.getComponent("arrays-tab");
            if (acp == null) {
                return;
            }
            acp.setCombinationType(this.ctype_);
        }
    }

    class CancelAnimationAction
    extends AbstractAction {
        CancelAnimationAction() {
            super("Cancel Animation");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GissMenu fileMenu = PanPlotFrame.this.getPanMenuBar().getMenuByName("file-menu");
            Action a = fileMenu.getItemByName("export-animation").getAction();
            if (a != null) {
                ((PanExportAnimationAction)a).cancel();
            }
        }
    }

    class ShowTopTabAction
    extends AbstractAction {
        private int pid_;

        ShowTopTabAction(int pid) {
            super(showTabNames_[pid]);
            this.pid_ = pid;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanPlotFrame.this.topTabPane_.setSelectedIndex(this.pid_);
            if (PanPlotFrame.this.controlsTabPane_ != null) {
                PanPlotFrame.this.controlsTabPane_.refresh();
            }
        }
    }

    class ShowControlsAction
    extends AbstractAction {
        String itemName_;
        String tabName_;

        ShowControlsAction(String itemName, String tabName) {
            super(PanProperties.MENUS.getString(itemName));
            this.itemName_ = itemName;
            this.tabName_ = tabName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanMenuBar mbar;
            if (PanPlotFrame.this.controlsTabPane_ != null) {
                PanPlotFrame.this.controlsTabPane_.setSelectedComponent(this.tabName_);
            }
            if ((mbar = PanPlotFrame.this.getPanMenuBar()) == null) {
                return;
            }
            GissMenu viewMenu = mbar.getMenuByName("view-menu");
            if (viewMenu == null) {
                return;
            }
            JMenuItem item = viewMenu.getItemByName(this.itemName_);
            ((JRadioButtonMenuItem)item).setSelected(true);
        }
    }
}

