/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.netcdf.NcFilenameFilter;
import gov.nasa.giss.netcdf.NcTransferableVariable;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanFileConstants;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanMapControls;
import gov.nasa.giss.panoply.PanNetcdfUtilities;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanScaleControls;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;

public class PanPlotDropTargetListener
implements DropTargetListener {
    private PanPlotFrame pframe_;

    public PanPlotDropTargetListener(PanPlotFrame pf) {
        this.pframe_ = pf;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || e.isDataFlavorSupported(NcTransferableVariable.NC_VARIABLE_FLAVOR)) {
            this.pframe_.getPlotHolder().toggleBorderActive(true);
            e.acceptDrag(1);
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.pframe_.getPlotHolder().toggleBorderActive(false);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this.pframe_.getPlotHolder().toggleBorderActive(false);
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(NcTransferableVariable.NC_VARIABLE_FLAVOR)) {
            e.acceptDrop(1);
            try {
                this.pframe_.addVariable(PanNetcdfUtilities.createArray(this.pframe_.getPlotType(), (NcVariable)t.getTransferData(NcTransferableVariable.NC_VARIABLE_FLAVOR), (JFrame)this.pframe_));
                e.dropComplete(true);
            }
            catch (Exception exc) {
                e.dropComplete(false);
            }
        } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            try {
                List flist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                for (Object fobj : flist) {
                    Component c;
                    Object o;
                    File f = (File)fobj;
                    if (NcFilenameFilter.accept(f)) continue;
                    if (PanFileConstants.CTABLE_FILTER.accept(f)) {
                        o = PanFileUtilities.openLocalFile(this.pframe_, f);
                        if (o == null || (c = this.pframe_.findComponentNamed("scale-controls")) == null) continue;
                        ((PanScaleControls)c).setColorTable((AbstractColorTable)o);
                        continue;
                    }
                    if (PanFileConstants.CNO_FILTER.accept(f) || PanFileConstants.IMAGE_FILTER.accept(f)) {
                        o = PanFileUtilities.openLocalFile(this.pframe_, f);
                        if (o == null || (c = this.pframe_.findComponentNamed("lonlat-map-controls")) == null) continue;
                        ((PanMapControls)c).setOverlay((AbstractOverlay)o);
                        continue;
                    }
                    if (!PanFileConstants.SETTINGS_FILTER.accept(f)) continue;
                }
                this.pframe_.getPlotHolder().repaint();
                e.dropComplete(true);
            }
            catch (Exception exc) {
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.pframe_.getPlotHolder().toggleBorderActive(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.pframe_.getPlotHolder().toggleBorderActive(false);
    }
}

