/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.map.overlay.MaskOverlay;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.panoply.PanPreferences;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PanOverlayPanel
extends JPanel {
    private static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final int DEFAULT_MAP_WIDTH = 540;
    private static final int DEFAULT_MAP_HEIGHT = 270;
    private static final int MAP_MARGIN = 6;
    private static BufferedImage mapImage_;
    private AbstractOverlay overlay_;
    private boolean oInverted_;
    private AbstractProjection projection_;
    private Dimension imgSize_;
    private Dimension mapSize_;
    private int margin_;

    public PanOverlayPanel(AbstractOverlay ao) {
        this();
        this.setOverlay(ao);
    }

    public PanOverlayPanel() {
        PanPreferences PREFS = PanPreferences.getPrefs();
        Rectangle rr = GuiUtilities.getMainScreenBounds();
        int mapW = 540;
        int mapH = 270;
        if (rr != null && rr.width > mapW * 3 / 2 + 40) {
            mapW = mapW * 3 / 2;
            mapH = mapH * 3 / 2;
        }
        mapImage_ = new BufferedImage(mapW, mapH, 2);
        this.imgSize_ = new Dimension(mapW, mapH);
        this.mapSize_ = new Dimension(mapW + 12, mapH + 12);
        this.setOpaque(false);
        this.setBorder(SIMPLE_OUTLINE_BORDER);
        Insets ins = this.getInsets();
        Dimension size = new Dimension(this.mapSize_.width + ins.left + ins.right, this.mapSize_.height + ins.top + ins.bottom);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setProjection(PREFS.getString("plot:lonlat.map.projection"));
        this.setOverlay((AbstractOverlay)PREFS.get("plot:lonlat.map.overlay"));
        this.setOverlayInverted(PREFS.getBoolean("plot:lonlat.map.overlay.invert"));
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int w, int h) {
        if (this.projection_ != null) {
            Insets ins = this.getInsets();
            this.mapSize_ = new Dimension(w - (ins.left + ins.right), h - (ins.top + ins.bottom));
            this.projection_.setSize(this.mapSize_.width, this.mapSize_.height, 6, 6);
        }
        super.setSize(w, h);
    }

    public void setOverlay(AbstractOverlay o) {
        this.overlay_ = o;
        this.repaint();
    }

    public void setOverlayInverted(boolean b) {
        this.oInverted_ = b;
        this.repaint();
    }

    public AbstractProjection getProjection() {
        return this.projection_;
    }

    public void setProjection(String name) {
        AbstractProjection old = this.projection_;
        int w = Math.max(1, this.getWidth());
        int h = Math.max(1, this.getHeight());
        try {
            this.projection_ = ProjectionFactory.create(name, this.mapSize_.width, this.mapSize_.height, 6, 6);
        }
        catch (Exception exc) {
            this.projection_ = new Equirectangular(this.mapSize_.width, this.mapSize_.height, 6, 6);
        }
        if (old != null) {
            this.projection_.setCenter(old.getCenter());
            this.projection_.setBackground(old.getBackground());
            this.projection_.setForeground(old.getForeground());
            this.projection_.setZoom(old.getZoom());
            this.projection_.setBorderStroke(old.getBorderStroke());
            this.projection_.setLonGridSpacing(old.getLonGridSpacing());
            this.projection_.setLatGridSpacing(old.getLatGridSpacing());
            this.projection_.setGridColor(old.getGridColor());
            this.projection_.setGridStroke(old.getGridStroke());
            this.projection_.setGridLabeled(old.isGridLabeled());
            this.projection_.setPathPoints(old.getPathPoints());
            this.projection_.setPathColor(old.getPathColor());
            this.projection_.setPathColor(old.getPathColor());
        } else {
            PanPreferences PREFS = PanPreferences.getPrefs();
            this.projection_.setCenter(PREFS.getDouble("plot:lonlat.map.center.lon"), PREFS.getDouble("plot:lonlat.map.center.lat"));
            this.projection_.setBackground(Color.LIGHT_GRAY);
            this.projection_.setForeground(Color.BLACK);
            this.projection_.setPathColor(Color.BLACK);
            this.projection_.setGridSpacing(15.0);
            this.projection_.setGridColor(Color.LIGHT_GRAY);
        }
        this.repaint();
    }

    @Override
    public void printBorder(Graphics g) {
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        GraphicUtilities.antialias(g2d);
        Graphics2D imgG2D = mapImage_.createGraphics();
        imgG2D.setColor(Color.WHITE);
        GraphicUtilities.fillRect(imgG2D, 0.0f, 0.0f, this.imgSize_.width, this.imgSize_.height);
        if (this.overlay_ instanceof MaskOverlay) {
            BufferedImage mask = ((MaskOverlay)this.overlay_).getMask(Color.BLACK, this.oInverted_);
            imgG2D.drawImage(mask, 0, 0, this.imgSize_.width, this.imgSize_.height, 0, 0, ((Image)mask).getWidth(this), ((Image)mask).getHeight(this), this);
            this.projection_.setPathPoints(null);
        } else if (this.overlay_ instanceof OutlineOverlay) {
            this.projection_.setPathPoints(((OutlineOverlay)this.overlay_).getPoints());
        }
        imgG2D.dispose();
        this.projection_.setSource(mapImage_);
        Insets ins = this.getInsets();
        g2d.translate(ins.left, ins.top);
        g2d.setColor(Color.LIGHT_GRAY);
        GraphicUtilities.fillRect(g2d, 0.0f, 0.0f, this.mapSize_.width, this.mapSize_.height);
        this.projection_.paintCompleteMap(g2d);
        g2d.translate(-ins.left, -ins.top);
    }

    public BufferedImage getImage() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.paintImage(img);
        return img;
    }

    public void paintImage(BufferedImage img) {
        Graphics2D g = img.createGraphics();
        this.paintComponent(g);
        this.paintChildren(g);
        g.dispose();
    }
}

