/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.panoply.PanAbstractSupportMenu;
import gov.nasa.giss.panoply.PanOverlayList;
import gov.nasa.giss.panoply.PanSupportEvent;
import gov.nasa.giss.panoply.PanSupportListener;

public class PanOverlayMenu
extends PanAbstractSupportMenu
implements PanSupportListener {
    private static PanOverlayList overlayList_ = PanOverlayList.getList();
    private boolean nullAtFirst_ = true;

    public PanOverlayMenu(boolean includeNull) {
        super(PanOverlayList.getList().toArray());
        this.nullAtFirst_ = includeNull;
        if (this.nullAtFirst_) {
            this.insertItemAt("None", 0);
            this.setSelectedIndex(0);
        }
        this.setMaximumSize(this.getPreferredSize());
        PanOverlayList.getList().addSupportListener(this);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item);
        }
    }

    public void setSelectedItem(AbstractOverlay item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item);
        }
    }

    public void setSelectedItemByName(String item) {
        if (item == null) {
            this.setSelectedIndex(0);
            return;
        }
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            if (!this.getItemAt(i).toString().equals(item)) continue;
            super.setSelectedIndex(i);
            return;
        }
    }

    public AbstractOverlay getOverlay() {
        Object o = this.getSelectedItem();
        if (o == null || !(o instanceof AbstractOverlay)) {
            return null;
        }
        return (AbstractOverlay)o;
    }

    @Override
    public void itemAdded(PanSupportEvent e) {
        int isize = overlayList_.size();
        if (this.getItemCount() > isize || !this.nullAtFirst_ && this.getItemCount() == isize) {
            return;
        }
        Object lastAdded = null;
        for (int i = 0; i < isize; ++i) {
            int j = i;
            if (this.nullAtFirst_) {
                ++j;
            }
            if (overlayList_.get(i) == this.getItemAt(j)) continue;
            lastAdded = overlayList_.get(i);
            this.insertItemAt(lastAdded, j);
        }
        this.notifyParentOfNewItem(lastAdded);
    }

    public synchronized void flush() {
        PanOverlayList.getList().removeSupportListener(this);
        this.removeAll();
    }
}

