/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.map.overlay.MaskOverlay;
import gov.nasa.giss.map.overlay.OverlayFactory;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.TOutlineOverlay;
import gov.nasa.giss.panoply.PanAbstractSupportList;
import gov.nasa.giss.panoply.Panoply;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PanOverlayList
extends PanAbstractSupportList {
    private static PanOverlayList list_;

    public static synchronized PanOverlayList getList() {
        if (list_ == null) {
            list_ = new PanOverlayList();
        }
        return list_;
    }

    private PanOverlayList() {
        super(new OverlayFilenameFilter());
        URL url;
        try {
            url = Panoply.class.getResource("resources/overlays/Earth.cno");
            this.add(new TOutlineOverlay(url));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            url = Panoply.class.getResource("resources/overlays/Earth.gif");
            this.add(new MaskOverlay(url));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.readFavorites("overlays");
    }

    @Override
    public Object add(File f) throws InterruptedException, IOException, FileNotFoundException {
        AbstractOverlay o = OverlayFactory.open(f);
        return this.add(o);
    }

    @Override
    public Object add(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof AbstractOverlay)) {
            throw new IllegalArgumentException("Object is not an overlay");
        }
        return super.add(o);
    }
}

